#include <stdio.h>
#include <stdlib.h> /* for malloc & free */
#include "memory.h"
#include <math.h> 
#include <R.h>
#include <Rmath.h>
#include <Rinternals.h>

#include <R_ext/Arith.h>	/* NA handling */
#include <R_ext/Random.h>	/* ..RNGstate */
#include <R_ext/Applic.h>	/* NA handling */

#define INF 1.0e32
#define MINF -1.0e32
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))


double F77_NAME(mvbvn)(double *lower, 
			double *upper, 
			int* infin, 
			double *correl);





double logphi(double y1, double y2, double rho)
/*
return  the logarithm of standardized bivariate  Gaussian density at point y1,y2.
with given rho correlation

*/

{
	double  m,sd, val;
	
	m = rho*y1;
	sd = sqrt(1.0-rho*rho);
	val = dnorm(y1, 0, 1, 1)+dnorm(y2, m, sd,1);	
  
	
	return(val);
}

double bivnor( double x, double y, double corr ) {
/*     A function for computing bivariate normal probabilities.  */	
/* Selected portion of code taken from: */
/*    http://www.math.wsu.edu/faculty/genz/software/mvtdstpack.f */
/* to compute bivariate normal and Student's t distribution functions. */

/* Author: */
/*          Alan Genz */
/*          Department of Mathematics */
/*          Washington State University */
/*          Pullman, WA 99164-3113 */
/*          Email : alangenz@wsu.edu */

  double val;	
  double lim_inf[2]={0.0, 0.0};
  double lim_sup[2]={0.0, 0.0};
  int infin[2]={0, 0};
  lim_sup[0]=x;
  lim_sup[1]=y;	
  val = mvbvn_(lim_inf, lim_sup, infin, &corr);

  return(val);	
}




double lF1(double y1, double y2, double rho)
/*
evaluate the logarithm of the partial derivative of bivariate  Gaussian CDF at point y1,y2.
rho correlation with respect to y1

*/


{
	double  val, m, sd;
	
	m = rho*y1;
	sd = sqrt(1.0-rho*rho);
	val = dnorm(y1, 0, 1, 1)+pnorm(y2, m, sd, 1,1);	
	
	return(val);
}



double lF2(double y1, double y2, double rho)
/*
evaluate the logarithm of the partial derivative of bivariate  Gaussian CDF at point y1,y2.
rho correlation with respect to y2

*/

{
	double  val, m , sd;

	m = rho*y2;
	sd = sqrt(1.0-rho*rho);
    val = dnorm(y2, 0, 1, 1)+pnorm(y1, m, sd, 1,1);	
	
	return(val);
}


double C(double u1, double u2, double rho)
{
	double val;
	/*
evaluate the bivariate distribution of
a  Gaussian process  at point u1,u2.
with 
rho correlation
*/

	val = bivnor(u1, u2, rho);
	return(val);
}



double lC1(double u1, double u2, double rho)
/*
evaluate the logarithm of the partial derivative of a bivariate CDF of
a  Gaussian process  at point u1,u2.
with 
alpha 
rho correlation
*/

{
	double val;
		
	val = lF1(u1, u2, rho);
	
	return(val);
}


double lC2(double u1, double u2, double rho)
/*
evaluate the logarithm of the partial derivative of a bivariate CDF of
a  Gaussian process  at point u1,u2.
with rho correlation
*/

{
	double val;
	
/* marginal tranformations */
	

	val = lF2(u1, u2, rho);
	
	return(val);
}


double lc(double u1, double u2,  double rho)
/*
evaluate the log of bivariate density of
a  Gaussian process  at point u1,u2.
with 
rho correlation
*/

{
	double   val;
	
	val = logphi(u1, u2,  rho);

	return(val);
}


double dist(double a1, double b1, double a2, double b2 )
 {
/* returns distance given dx, dy, */
      
      double val, d1 , d2;
      d1 = a1 - a2;
	  d2 = b1 - b2;
	  val = d1*d1 + d2*d2;
	  val = sqrt(val);   
	  return(val);
}

double dist_aniso(double a1, double b1, double a2, double b2 , double alpha, double lambda)
 {
/* returns distances between a=(a1,a2) and b=(b1,b2)  */
      
      double val, d1 , d2;
      d1 = cos(alpha)*(a1 - a2)-sin(alpha)* (b1-b2);
	  d2 = (cos(alpha)* (b1-b2)+sin(alpha)*(a1 - a2)) /sqrt(lambda);
	  val = d1*d1 + d2*d2;
	  val = sqrt(val);   
	  return(val);
}


double chkcorr(double *theta, int corrmodel) {
   double val=1;				
   switch(corrmodel) {
		case 1: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);
				}
				if ((theta[2] < 1) || (theta[2] > 2) || (theta[3] < 1) || (theta[3] > 2)|| (theta[4] < 1)) /* iacocesare */{
					val = MINF *(1-theta[2])*(1-theta[2])*(1-theta[3])*(1-theta[3])*(1-theta[4])*(1-theta[4]);	
					return(val);
				}
				break;
		case 2: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);
				}
		
				if ((theta[2] <= 0) || (theta[2] > 1) || (theta[3] <= 0) || (theta[3] > 1) || (theta[4] < 0) || (theta[4] > 1)) {  /* gneiting */
					val = MINF *(1-theta[2])*(1-theta[2])*(1-theta[3])*(1-theta[3])*(1-theta[4])*(1-theta[4]);	
					return(val);
				}
                break;
		case 3: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);
				}
				if ((theta[2] < 0) || (theta[2] > 1) || (theta[3] < 0) || (theta[3] > 1) || (theta[4] < 0) || (theta[4] > 2)) {  /* porcu */
					val = MINF *(1-theta[2])*(1-theta[2])*(1-theta[3])*(1-theta[3])*(1-theta[4])*(1-theta[4]);	
					return(val);
				}
                break;
		case 4: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);
				}
				break;
		case 5: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);
				}
				break;
		case 6: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);
				}
				break;
		case 7: if (theta[0] <= 0)  {
					val = MINF *(1-theta[0])*(1-theta[0]);
					return(val);
				}
				break;
		case 8: if (theta[0] <= 0)  {
					val = MINF *(1-theta[0])*(1-theta[0]);
					return(val);
				}
				break;	
           	case 9: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);			
				}
			if ((theta[2] <= 0) || (theta[2] > 2) || (theta[3] <= 0) || (theta[3] > 2)) { 
					val = MINF *(1-theta[2])*(1-theta[2])*(1-theta[3])*(1-theta[3]);	
					return(val);
				}
           	case 10: if ((theta[0] <= 0) || (theta[1] <= 0)) {
					val = MINF *(1-theta[0])*(1-theta[0])*(1-theta[1])*(1-theta[1]);
					return(val);			
				}
			if ((theta[2] < 0)  || (theta[3] <= 0) || (theta[3] > 2)) { 
					val = MINF *(1-theta[2])*(1-theta[2])*(1-theta[3])*(1-theta[3]);	
					return(val);
				}
		default:  val  = 1; /*  only for safety*/
		}
	
	
        return(val);
}


double corr(double x, double y, double t, double x1,  double y1,  double t1, double alpha, double lambda, double *velocity, double *theta, int corrmodel) {
        
        double ds, dt, hs[2], ht, val, val1, val2;
        
        ht = t - t1;
        hs[0] = cos(alpha)*(x - x1)-sin(alpha)* (y-y1);
	hs[1] = (cos(alpha)*(y-y1)+sin(alpha)*(x - x1)) /sqrt(lambda);

		
        switch(corrmodel) {
		case 1: ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				dt = fabs(ht);
				ds = ds/theta[0];
				dt = dt/theta[1];
				val1  =  1+ R_pow(ds,theta[2]) +R_pow(dt,theta[3]); /* iacocesare */
				val  =  1/R_pow(val1,theta[4]);
                break;

		case 2: ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				dt = fabs(ht);
				ds = ds/theta[0];
				dt = dt/theta[1];
				val1 = 1+ R_pow(dt,2*theta[3]); /* 1+dt^(2\alpha)  gneiting equation 14 in Gneiting (2002) with tau=1*/
		    
				val = R_pow(ds,2*theta[2])/R_pow(val1,theta[2]*theta[4]); 
                                         /*\frac{ds^{2\gamma}}{(dt^\alpha+1)^{\beta\gamma}*/
				val = exp(-val)/val1;
				/* C(ds,dt)=\frac{1}{(dt^{2\alpha}+1)}\exp\{-\frac{ds^{2*\gamma}}
                                          {(dt^{2\alpha}+1)^{\beta\gamma}\}
				 0<\gamma<=1  theta[2]
				  0<\alpha<=1  theta[3]
				 0<=\beta<=1  theta[4] 
				 */
                break;

		case 3: ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				dt = fabs(ht);
				ds = ds/theta[0];
				dt = dt/theta[1];
				val1 = 1+ R_pow(dt,theta[3]); /* porcu */
				val2 = 1+ R_pow(ds,theta[2]);
				val = 0.5*(R_pow(val1,theta[4])+ R_pow(val2,theta[4]));
				val = R_pow(val, -1/theta[4]);
                break;

		case 4: ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				dt = fabs(ht);
				ds = ds/theta[0];
				dt = dt/theta[1];
				val = exp(-ds-dt); /* exponential-exponential separable model */
                break;
       
		case 5: ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = ds/theta[0];
				dt = ht*ht/theta[1];
				val = exp(-ds-dt); /* Gaussian-Gaussian separable model */
                break;
       
                case 6: ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				dt = fabs(ht);
				ds = ds/theta[0];
				dt = dt/theta[1];
				if (ds < 1) {
					val = 1 - (1.5 * ds) + (0.5 * R_pow(ds,3)) ;
				}
				else {
					val = 0.0;			
					break;
				}	
				if (dt < 1) {
				val = val * (1 - (1.5 * dt) + (0.5 * R_pow(dt,3)) );
				}
				else {
					val = 0.0;			
					break;
				}
			case 7: hs[0] =(hs[0]-ht*velocity[0]);
				hs[1] =(hs[1]-ht*velocity[1]);
				ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				ds = ds/theta[0];
				val = exp(-ds); /* exponential velocity model */
				break;
			case 8: hs[0] =(hs[0]-ht*velocity[0]);  /* spherical velocity model */
				hs[1] =(hs[1]-ht*velocity[1]);
				ds = hs[0]*hs[0]+hs[1]*hs[1];
				ds = sqrt(ds);
				ds = ds/theta[0];
				if (ds < 1) {
					val = 1 - (1.5 * ds) + (0.5 * R_pow(ds,3)) ;
					break ;
				}
				else {
					val = 0.0;			
					break;
				}
				
				break;
       			case 9: ds = hs[0]*hs[0]+hs[1]*hs[1]; /* stable-stable separable model */
				ds = sqrt(ds)/theta[0];
				dt = fabs(ht)/theta[1];
				val = exp(-R_pow(ds,theta[2])-R_pow(dt,theta[3])); 
		                break;
       			case 10: ds = hs[0]*hs[0]+hs[1]*hs[1]; /* Cauchy-stable separable model Chiles Delfiner (2.55)*/
				ds = ds/(theta[0]*theta[0]);
				dt = fabs(ht)/theta[1];
				val = exp(-R_pow(dt,theta[3]))/R_pow(1+ds,theta[2]/2); 
		                break;
		default:  val  = 0.5; /*  only for safety*/
		}
	
		return(val);
}    











/* version for parallel computing */
void  pwl_copula_parallel(double *y, int *nobs, int *nsites, int *nblocks, int *lag, double *theta, 
			double *alpha, double *lambda, double *velocity, double *loglik, 
                        double *threshold, double *xcoords, double *ycoords, double *tcoords, 
			double *delta, int *corrmodel, double *count)
{
	double  ds,   rho, indloglik,  tmp, xx, yy;
	int  end, i, j, k, ntot,  start, zcase;
/* this function calculates the pairwise likelihood for the exceedandes */	
        *count=0.0;	

	if ( *lambda <= 0) {
		*loglik = MINF*(1-*lambda)*(1-*lambda);				
		return;
	}
	
	if ( (*alpha < 0) || (*alpha >= M_PI)) {
		*loglik = MINF*(1-*alpha)*(1-*alpha);				
		return;
	}
   
	tmp = chkcorr(theta, *corrmodel); 
    	if ( tmp <= 0) {
		*loglik = MINF*(1-tmp)*(1-tmp);	
		return;
	}
	
	*loglik = 0;
	
	ntot = (*nsites)*(*lag);
	for (k = 0; k < (*nblocks); k ++) {
		start = k*(*nsites);
		end = (k+1)*(*nsites);
		/*if (end > *nobs )*/
		for (i = start; i < end; i++) {
                 if (!ISNA(y[i])) {		    							 
			for (j = (i+1); j < MIN((end+ntot),*nobs); j++){
			 if (!ISNA(y[j])) {   
				ds = dist(xcoords[i],ycoords[i],xcoords[j],ycoords[j]);			
				if ( ds <= *delta ) {
						rho  =  corr(xcoords[i],ycoords[i],tcoords[i],xcoords[j],ycoords[j], tcoords[j], *alpha, *lambda, velocity, theta, *corrmodel); /*correlation */																					
						zcase = (y[i] > *threshold) + 2 * (y[j] > *threshold);
						*count+=1.0;
                        	switch(zcase) {
					case 0: xx = yy = *threshold;
						indloglik = log(C(xx,yy, rho)); /* below , below*/
						break;
					case 1: xx = y[i]; /* above, below */
						yy = *threshold;
						indloglik = lC1(xx,yy, rho);
						break;	
					case 2: xx = *threshold; /* above, below */
						yy = y[j];
						indloglik = lC2(xx,yy,rho);					
						break ;
					case 3: xx = y[i];  /* above, above */
						yy = y[j];
						indloglik = lc(xx,yy,rho);
						break;
					default:  indloglik = 0.0;  /*  only for safety*/
					}
			 	*loglik += indloglik; 
				}		
			   }	
		  	}
		   }
		}
	}	
}

    

double chi_u(double q, double p, double x, double y, double t, double x1,  double y1,  double t1, double alpha, double lambda, double *velocity, double *theta, int corrmodel)
{
	double rho ,val;
	 /* p=Pr(X <=q)= Pr(Y <=q) */
	
	rho  = corr(x,y,t,x1,y1,t1, alpha, lambda, velocity, theta, corrmodel); /*correlation */	

	val = C(q,  q,  rho);	/* Pr(X <=q,Y <=q) */	
	val = 1-2*p+ val; /* Pr(X > q,Y  > q) = 1-  Pr(X <=q) - Pr(Y <=q) + Pr(X <=q,Y <=q) */		
	val = val/(1-p); /* Pr(X > u,Y  > u | x > u) = /* Pr(X > q,Y  > q)/ ( 1-  Pr(X <=q)) */	
	return(val);	
}

void chi_u_wrap(double *q, double *p, int *n,  double *x, double *y, double *t, double *x1, double *y1, double *t1,
                       double *theta,  int *corrmodel, 
                       double *alpha, double *lambda, double *velocity, double *val) {
	double tmp;
	int i; 
	
    tmp = chkcorr(theta, *corrmodel); 
    if ( tmp <= 0) {
		Rprintf("Invalid parameter model %d",*corrmodel);		
		return;
	}

    for (i =0; i < (*n); i++) {
        val[i] = chi_u(*q, *p,  x[i], y[i], t[i], x1[i], y1[i],  t1[i], *alpha, *lambda, velocity, theta, *corrmodel);		
	}
			
}


