
PLneg.spt.censgauss<-function(theta,y, threshold,  
                           xcoords, ycoords, tcoords, 
                             delta, param, mask, ncores,nsites, 
                           ntimes, corrmodel) {
		tmp<-PLneg.spt.censgauss.wrap(theta,y, threshold,  xcoords, ycoords, tcoords, 
                             delta, param, mask, ncores,nsites, ntimes, corrmodel) 
		return(tmp$val) 
}
PLneg.spt.censgauss.wrap<-function(theta,y, threshold,  xcoords, ycoords, tcoords, 
                             delta, param, mask, ncores,nsites, ntimes, corrmodel) {
  
  # ncores number of cores
  # vector param contains the parameters
  
  
  param[mask]<-theta
  
  m<-ntimes %/%ncores
  lag<-delta[2]
  if (lag > m) stop("lag too high")
  ntimes.for.cores<-rep(m,ncores)
  ntimes.for.cores[ncores]<-ntimes.for.cores[ncores]+(ntimes-m*ncores)
  start<-c(0,cumsum(ntimes.for.cores)[-ncores])
  end<-cumsum(ntimes.for.cores)
  end[-ncores]<-end[-ncores]+lag
  results<-numeric(ncores)
  loglik<-rep(0,ncores)
  npairs<-rep(0,ncores)
  results<-foreach(j=1:ncores,.combine=rbind) %dopar%{ 
  ind<-(start[j]*nsites+1):(end[j]*nsites)
  v1<-y[ind]
  nobs<-length(v1)
  val<-.C("pwl_copula_parallel",y=as.double(v1), nobs=as.integer(nobs), 
            nsites=as.integer(nsites), nblocks=as.integer(ntimes.for.cores[j]), 
            lag=as.integer(lag), theta=as.double(param[-c(1:4)]), 
            alpha=as.double(param[1]), lambda=as.double(param[2]),
            velocity=as.double(param[3:4]),
            loglik=as.double(loglik[j]),
            threshold=as.double(threshold), xcoords=as.double(xcoords[ind]), 
            ycoords=as.double(ycoords[ind]), tcoords=as.double(tcoords[ind]), 
            delta = as.double(delta[1]), corrmodel =as.integer(corrmodel),count=as.double(npairs[j]), 
            NAOK = TRUE,  DUP =FALSE)	
	c(-val$loglik,val$count)
  
  }  
 if (ncores == 1) {
 return(list(val=results[1],npairs=results[2])) 
 }  
 return(list(val=sum(results[,1]),npairs=sum(results[,2]))) 
}

