library(QREM)
# https://github.com/haimbar/QREM

# Mixed Effect Modeling and Variable Selection for Quantile Regression
# Bar, Booth, and Wells (Statistical Modelling 2021)

# Code to create Figure 4 (flat Q-Q plots)

# generate the data
n <- 10000
x <- seq(0,1,length.out = n)
x2 <- x[sample(n)]
x3 <- factor(c(rep("C",5000), rep("T1", 3000), rep("T2",2000)))
y <- 4*x*x2 + rnorm(n,0,0.1+0.2*x) # the true model

L <- 20
qns <- seq(0.05,0.95,by=0.05)
xqs <- quantile(x, probs = (1:(L-1))/L)
names(xqs) <- c()
qqp  <- matrix(0, nrow=length(xqs), ncol=length(qns))
qqp2 <- matrix(0, nrow=length(xqs), ncol=length(qns))
b0 <- rep(0,length(qns))
b02 <- rep(0,length(qns))
i <- 1
# run two QR models at 19 different quantiles
for (qn in qns) {
  # fit a linear model
  qremFit <- QREM("lm",linmod=y~x+x2, df=data.frame(y,x,x^2), qn=qn)
  b0[i] <- qremFit$coef$beta[1]
  qrdg <- QRdiagnostics(x, "x",qremFit$ui, qn, plot.it = F)
  for (j in 1:(L-1)) {
    qqp[j,i] <- length(which(qrdg$y < xqs[j])) / length(which(qrdg$x < xqs[j]))
  }
  
  # fit an interaction model (the correct specification)
  qremFit <- QREM("lm",linmod=y~x*x2 +x3, df=data.frame(y,x), qn=qn)
  b02[i] <- qremFit$coef$beta[1]
  qrdg <- QRdiagnostics(x, "x",qremFit$ui, qn,  plot.it = F)
  for (j in 1:(L-1)) {
    qqp2[j,i] <- length(which(qrdg$y < xqs[j])) / length(which(qrdg$x < xqs[j]))
  }
  i <- i+1
}
flatQQplot(x,xqs,qqp,qns) # estimated using the linear model
flatQQplot(x,xqs,qqp2,qns) # estimated using the interaction model
