library(QREM)
# https://github.com/haimbar/QREM

# Mixed Effect Modeling and Variable Selection for Quantile Regression
# Bar, Booth, and Wells (Statistical Modelling 2021)

# Code to create Figure 3 (Q-Q plots)

n <- 10000
x <- seq(0,1,length.out = n)
y <- 6*(x)^2 + x +120 + rnorm(n, 0, 0.2+1*x) # the true model
qn <- 0.1

# fit a linear (incorrect) model
qremFit <- QREM("lm",linmod=y~x, df=data.frame(y,x,x^2), qn=qn)
qrdg <- QRdiagnostics(x, "x",qremFit$ui, qn, plot.it = T)

# fit a quadratic (correct) model
qremFit <- QREM("lm",linmod=y~x+I(x^2), df=data.frame(y,x), qn=qn)
qrdg <- QRdiagnostics(x, "x",qremFit$ui, qn,  plot.it = T)
