// [[Rcpp::depends(RcppArmadillo)]]

# include <RcppArmadillo.h>

#define ARMA_USE_LAPACK

#define ARMA_USE_BLAS

using namespace Rcpp;
using namespace arma;

// [[Rcpp::export]]
double beta_pos_optim(arma::vec& par, arma::vec& Y, arma::mat& X, arma::mat& W, arma::vec& z, double& lambda, double& tau, int& N, int& K, int& P) {
  arma::vec mu(N), fden(N), u(N);
  arma::vec beta(P), b_pos(K);
  double sigma = exp(as_scalar(par.tail(1))), ind, lnd = 0, pen = 0;
  int t, i;
  
  for(t = 0; t < K; t++) {
    b_pos(t) = par(t);
  }
  
  for(t = K; t < (K+P); t++) {
    beta(t - K) = par(t);
    pen += std::abs(beta(t - K));
  }
  
  mu = X * beta + W * b_pos;
  
  for(i = 0; i < N; i++) {
      ind = 1 * (Y(i) < mu(i)) + 0 * (Y(i) > mu(i));
      fden(i) = - log(sigma) - (Y(i) - mu(i)) / sigma * (tau - ind);
  }
  
  lnd = dot(fden, z) - lambda * pen;
  
  return -lnd;
}