# the normal fitting 
rm(list=ls())
library(gamlss.foreach)
library(zoo)
library(tictoc)
library(ggplot2)
# bring data 
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))
load(file="da1.RData")
ls()
names(da1)

#pdf("/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/PreperationForTheFinalVersions/Figure/figure111-1.pdf")
da <- data.frame(time=time(da1$resgr), spreads=da1$resgr)
head(da)
######################################################################
# defining main effects X and first order interactions XX 
X <- as.matrix(da1[,xvars])
dim(X)
colnames(X)
#-------------------------------
#interaction formula
form2 <- as.formula(paste("resgr ~ ",paste0(paste0("(",paste(colnames(X), collapse='+')), ")^2"))) 
form2
# geting the interactions
XX <- model.matrix(form2, data=da1)[,-1]
dim(XX)
#######################################################################
#######################################################################
# svd of the design matrices 
Xsvd <- getSVD(X)
XXsvd <- getSVD(XX)
#######################################################################
# model 1
m0  <- gamlss(resgr~X, data=da1)
#######################################################################
# model 2
m1t <- gamlss(resgr~pc(x.svd=Xsvd, method="t-value"), data=da1)
# model 4
m1g <- gamlss(resgr~pc(x.svd=Xsvd, method="GAIC"), data=da1)
# model 3
t1g <- gamlss(resgr~pcr(x=X, method="GAIC"), data=da1)
getSmo(t1g)$pc 
#model 5
t1t <- gamlss(resgr~pcr(x=X, method="t-value"), data=da1)
#####################################################################
# model 6
m00 <- gamlss(resgr~X, sigma.fo=~X, data=da1, 
              family=NO(sigma.link="Slog"), n.cyc=100)
####################################################################
cl <- parallel::makeCluster(8)
doParallel::registerDoParallel(cl)
# model 7 
m11t <- gamlss(resgr~pc(x.svd=Xsvd, method="t-value"), 
               sigma.fo=~pc(x.svd=Xsvd, method="t-value"), 
               c.crit=0.01, n.cyc=50, data=da1,
               family=NO(sigma.link="Slog"))
# model 9
m11g <- gamlss(resgr~pc(x.svd=Xsvd, method="GAIC"), 
               sigma.fo=~pc(x.svd=Xsvd, method="GAIC"), 
               data=da1, c.crit=0.01, n.cyc=50,
               family=NO(sigma.link="Slog"))
# model 8
t11t <- gamlss(resgr~pcr(x=X, method="t-value"), 
               sigma.fo=~pcr(x=X, method="t-value"), 
               c.crit=0.01, n.cyc=50,data=da1,
               family=NO(sigma.link="Slog"))
# model 10
# PCR GAIC 
t11g <- gamlss(resgr~pcr(x=X, method="GAIC"), 
               sigma.fo=~pcr(x=X, method="GAIC"), 
               c.crit=0.01, data=da1,
               family=NO(sigma.link="Slog"))
#######################################################################
#######################################################################
# INTERACTIONS
#######################################################################
#######################################################################
# model 11
mi1t <- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=200), 
               data=da1)
# model 13 
mi1g <- gamlss(resgr~pc(x.svd=XXsvd, method="GAIC", max.number=200), 
               data=da1)
# model 12
ti1g <- gamlss(resgr~pcr(x=XX, M=200, method="GAIC"), 
               family=NO(sigma.link="Slog"),
               data=da1)
# model 14
ti1t <- gamlss(resgr~pcr(x=XX, M=200, method="t-values"), 
               family=NO(sigma.link="Slog"),
               data=da1)
######################################################################
# model 15
mi11t <- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=200), 
                sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=200),
                data=da1, family=NO(sigma.link="Slog"), n.cyc=50, c.crit=0.01 )
# model 17
mi11g <- gamlss(resgr~pc(x.svd=XXsvd, method="GAIC", max.number=200), 
                sigma.fo=~pc(x.svd=XXsvd, method="GAIC", max.number=10),
                data=da1, family=NO(sigma.link="Slog"), n.cyc=50, c.crit=0.01 )
#  model 16

ti11g <- gamlss(resgr~pcr(x=XX, method="GAIC", M=200), 
                sigma.fo=~pcr(x=XX, method="GAIC", M=100), 
                data=da1, family=NO(sigma.link="Slog"), n.cyc=50, c.crit=0.01)
# model 18
ti11t <- gamlss(resgr~pcr(x=XX, method="t-values", M=200), 
                sigma.fo=~pcr(x=XX, method="t-values", M=100), 
                data=da1, family=NO(sigma.link="Slog"), n.cyc=10, 
                cyc=3, c.crit=0.01)
#################################################################
stopImplicitCluster()
#################################################################
#################################################################