# the normal fitting 
# 
rm(list=ls())
library(gamlss.foreach)
library(zoo)
library(tictoc)
library(ggplot2)
# bring data 
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))
load(file="da1.RData")
names(da1)

#pdf("/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/PreperationForTheFinalVersions/Figure/figure111-1.pdf")
da <- data.frame(time=time(da1$resgr), spreads=da1$resgr)
head(da)
######################################################################
# defining main effects X and first order interactions XX 
X <- as.matrix(da1[,xvars])
dim(X)
colnames(X)
#-------------------------------
#interaction formula
form2 <- as.formula(paste("resgr ~ ",paste0(paste0("(",paste(colnames(X), collapse='+')), ")^2"))) 
form2
# geting the interactions
XX <- model.matrix(form2, data=da1)[,-1]
dim(XX)
#######################################################################
#######################################################################
# svd of the design matrices 
Xsvd <- getSVD(X)
XXsvd <- getSVD(XX)
#######################################################################
# Using chooseDist to choose a suitable distribution
tm0<- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=150), 
             sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=100),
             nu.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
             tau.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
             data=da1, family=NO(sigma.link="Slog"), n.cyc=10, c.crit=0.01 )
# get a table
T1 <- chooseDist(tm0, type="realAll", parallel = "snow", ncpus=8)
# T1
# the results are in da1-Table.RData
# the table is plotted in figure 4
########################################################################
# BCT distributions fits
# model 1 all parameers are modolled
fm<- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=150), 
            sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=100),
            nu.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
            tau.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
            data=da1, family=BCT(sigma.link="Slog"), n.cyc=200, c.crit=0.01 )
fm$mu.df
fm$sigma.df
fm$nu.df
fm$tau.df
##########################################################################
# model 2 tau constant
fm1<- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=150), 
             sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=100),
             nu.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
             # tau.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
             data=da1, family=BCT(sigma.link="Slog"), n.cyc=50, c.crit=0.01 )
fm1$mu.df
fm1$sigma.df
fm1$nu.df
##########################################################################
# model 3 nu and tau constant 
fm2<- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=150), 
             sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=100),
             #nu.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
             # tau.fo=~pc(x.svd=XXsvd, method="t-value", max.number=50),
             data=da1, family=BCT(sigma.link="Slog"), n.cyc=50, c.crit=0.01 )
fm2$mu.df
fm2$sigma.df
fm2$nu.df
#############################################################################
# log normal distribution
fm4<- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=150), 
             sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=100),
             data=da1, family=LOGNO(sigma.link="Slog"), n.cyc=50, c.crit=0.01 )
############################################################################
fm3<- gamlss(resgr~pc(x.svd=XXsvd, method="t-value", max.number=150), 
             sigma.fo=~pc(x.svd=XXsvd, method="t-value", max.number=100),
             data=da1, family=BCCG(sigma.link="Slog"), n.cyc=50, c.crit=0.01 )


##########################################################################

AIC(fm, fm1, fm2, fm3, fm4, k=0)
AIC(fm, fm1, fm2, fm3, fm4)
AIC(fm, fm1, fm2,fm3, fm4, k=log(1388))
##########################################################################






