#######################################################################
#######################################################################
# figures for the statistical modelling PCR paper 
#######################################################################
#######################################################################
rm(list=ls())
library(gamlss.foreach)
library(zoo)
library(tictoc)
library(ggplot2)
library(gamlss.ggplots)
# bring data 
load(file="da1.RData") 
ls()
names(da1)
###################################################################
###################################################################
###################################################################
###################################################################
# FIGURE 1
###################################################################
###################################################################
da <- data.frame(time=time(da1$resgr), spreads=da1$resgr)
head(da)
theme_update(text = element_text(size=18))
ggplot(da, aes(x=time, y = spreads))+
  geom_line( colour=gray(.5) )+
  xlab("year") 
###################################################################
###################################################################
###################################################################
###################################################################
# FIGURE 2
###################################################################
################################################################### 
library(gamlss.foreach) 
 X <- as.matrix(da1[,xvars])
#-------------------------------
#interaction formula
form2 <- as.formula(paste("resgr ~ ",paste0(paste0("(",paste(colnames(X), collapse='+')), ")^2"))) 
form2
# geting the interactions
XX <- model.matrix(form2, data=da1)[,-1]
dim(XX)
colnames(XX)
cl <- parallel::makeCluster(8)
doParallel::registerDoParallel(cl)
m1 <- fitPCR(x=XX, y=da1$resgr, M=300,  k=log(1288))
stopImplicitCluster()
library(gamlss.ggplots)
pp <- PCR_coef_path(m1,plot=F)
pp+ geom_vline(xintercept = m1$pc, colour = "gray") 
#######################################################################
#######################################################################
#######################################################################
#######################################################################
# FIGURE 3
#######################################################################
####################################################################### 
# models
load(file="/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/da1-Model.RData")
###################################################################
# figure a only main effects 
###################################################################
da <- data.frame(time=time(da1$resgr), spreads=da1$resgr, 
                 fv=fitted(m11t), res=(da1$resgr-fitted(m11t)),
                 sigma=fitted(m11t,"sigma"))

theme_update(text = element_text(size=18))
ggplot(da, aes(x=time, y = spreads))+
  geom_line( colour=gray(.7) )+
  geom_line(aes(x=time, y = fv), colour="darkblue" )+
  geom_line(aes(x=time, y = res), colour="darkgreen" )+
  xlab("")+
  ggtitle("(a) no interactions: data, mu model and residuals")+
  theme(legend.position = "bottom")+ 
  guides(fill = "none")


###################################################################
theme_update(text = element_text(size=18))
ggplot(da, aes(x=time, y = sigma))+
  geom_line(aes(x=time, y = sigma), colour="darkblue" )+
  xlab("")+
  ggtitle("(c) no interactions: sigma fitted model")+
  theme(legend.position = "bottom")+ 
  guides(fill = "none")
#
####################################################################
da <- data.frame(time=time(da1$resgr), spreads=da1$resgr, 
                 fv=fitted(mi11t), res=(da1$resgr-fitted(mi11t)),
                 sigma=fitted(mi11t,"sigma"))

theme_update(text = element_text(size=18))
ggplot(da, aes(x=time, y = spreads))+
  geom_line( colour=gray(.7) )+
  geom_line(aes(x=time, y = fv), colour="darkblue" )+
  geom_line(aes(x=time, y = res), colour="darkgreen" )+
  xlab("")+
  ggtitle("(b) interactions: data, mu model and residuals")+
  theme(legend.position = "bottom")+ 
  guides(fill = "none")

####################################################################
####################################################################

theme_update(text = element_text(size=18))
ggplot(da, aes(x=time, y = sigma))+
  geom_line(aes(x=time, y = sigma), colour="darkblue" )+
  xlab("")+
  ggtitle("(d) interactions: sigma fitted model")+
  theme(legend.position = "bottom")+ 
  guides(fill = "none")


#######################################################################
#######################################################################
#######################################################################
#######################################################################
# figure 4
#######################################################################
#######################################################################
load( file="/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/da1-Table.RData")
###################################################################

library(gamlss.ggplots)
theme_update(text = element_text(size=18))
model_GAIC(T1, horiz=TRUE, text.cex = 1 )

##########################################################################
##########################################################################
##########################################################################
##########################################################################
# Figure 5 worm plots
##########################################################################
########################################################################## 

load(file="/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/fm_fm1_fm2.RData") 
##########################################################################
# worm plots 

resid_wp(mi11t,  title= "(a) normal" )


resid_wp(mi11t,  title= "(a) normal",  poly.col = gray(.4),  points.col =gray(.5))


#########################################################################

resid_wp(fm,  title= "(b) BCT all" )

#########################################################################

resid_wp(fm1,  title= "(c) BCT constant for tau" )

########################################################################

pp <- resid_wp(fm2,  title= "(d) BCT constant for nu and tau" )

#########################################################################
#########################################################################

model_wp(mi11t,fm, fm1, fm2)
#########################################################################
#########################################################################
#########################################################################
#########################################################################
# FIGURE 7
########################################################################
######################################################################## 
library(gamlss.foreach)
library(gamlss.ggplots)
library(zoo)
library(tictoc)
library(ggplot2)

# bring data 
load(file="/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/da1.RData") 
names(da1)
###################################################################
###################################################################
###################################################################
###################################################################
library(gamlss.foreach) 
X <- as.matrix(da1[,xvars])
#-------------------------------
#interaction formula
form2 <- as.formula(paste("resgr ~ ",paste0(paste0("(",paste(colnames(X), collapse='+')), ")^2"))) 
form2

load(file="/Users/dimitriosstasinopoulos/Dropbox/Nikos-Speads/StatisticalModellingPaper/fm3.RData") 
ind <- 1:2278
fm3da <- data.frame(coef=getSmo(fm3)$beta, ind=ind, 
                 v05= ifelse(abs(getSmo(fm3)$beta)>0.05,ind,NA),
                 v04= ifelse(abs(getSmo(fm3)$beta)>0.04,ind,NA),
                 v03= ifelse(abs(getSmo(fm3)$beta)>0.03,ind,NA))


theme_update(text = element_text(size=18))
ggplot(fm3da , aes(x = ind, y = coef, label = v05,  ymin=0, ymax=coef)) + 
  geom_linerange(colour =  "steelblue4" ) + 
  geom_point(shape = 1, colour = "steelblue4"  ) + 
  geom_hline(yintercept = 0, colour = "gray") + 
  geom_hline(yintercept = c(-0.04,0.04), colour = "gray")+
  xlab("Observation number") + 
  ylab("beta") + 
  ggtitle("(a) The beta coefficients for the mu model") 











das <- data.frame(coef=getSmo(fm3,"sigma")$beta, ind=ind, 
                 v05= ifelse(abs(getSmo(fm3,"sigma")$beta)>0.5,ind,NA),
                 v04= ifelse(abs(getSmo(fm3,"sigma")$beta)>0.45,ind,NA),
                 v03= ifelse(abs(getSmo(fm3,"sigma")$beta)>0.4,ind,NA))



theme_update(text = element_text(size=18))
ggplot(das, aes(x = ind, y = coef, label = v04,  ymin=0, ymax=coef)) + 
  geom_linerange(colour =  "steelblue4" ) + 
  geom_point(shape = 1, colour = "steelblue4"  ) + 
  geom_hline(yintercept = 0, colour = "gray") + 
  geom_hline(yintercept = c(-0.4,0.4), colour = "gray")+
  xlab("Observation number") + 
  ylab("beta") + 
  ggtitle("The beta coefficient") 


#########################################################################
#########################################################################
#########################################################################
#########################################################################
