rm(list=ls(all=TRUE))

require(ThreeWay)
require(mvtnorm)
require(npmlreg)
require(lsei)

source("EMfittingParafac.R")
source("EMfittingStandard.R")

#data in dta
dta=read.csv("dataNMES.csv",sep=",",header=T)

#selection of K1, K2, K3, (Parafac approach) and K (standard approach) by AIC
#K (standard approach)
Kmax=6
aic=matrix(NA,(Kmax-1),1)
for (k in 2:Kmax)
{
  aic[k-1]=-2*(EMdatastandard(dta,k)$likeli)+4*k
}
Kbest=which(aic==min(aic))+1

#K1 (Parafac approach)
K1max=6
aic1=matrix(NA,(K1max-1),1)
for (k1 in 2:K1max)
{
  aic1[(k1-1)]=alldist(Y5~X1+X2+X3+X4+X8+X15+X16,random=~1,random.distribution="np",k1,family="poisson",data=dta,plot.opt=0,verbose=F)$disparity+4*k1
}
K1best=which(aic1==min(aic1))+1

#K2 (Parafac approach)
K2max=6
aic2=matrix(NA,(K2max-1),1)
for (k2 in 2:K2max)
{
  aic2[(k2-1)]=alldist(Y6~X1+X2+X3+X4+X8+X15+X16,random=~1,random.distribution="np",k2,family="poisson",data=dta,plot.opt=0,verbose=F)$disparity+4*k2
}
K2best=which(aic2==min(aic2))+1

#K3 (Parafac approach)
K3max=4
aic3=matrix(NA,(K3max-1), 1)
for (k3 in 2:K3max)
{
  aic3[(k3-1)]=alldist(cbind(X15,1-X15)~X7+X9+X10+X11+X12+X14,random=~1,random.distribution="np",k3,family="binomial",data=dta,plot.opt=0,verbose=F)$disparity+4*k3
}
K3best=which(aic3==min(aic3))+1
Kappabest=c(K1best,K2best,K3best)

#Solution (Parafac approach)
#(repeated 10 times using different random starts)
ModParafac=EMdataparafac(dta,Kappabest,2)

#Solution (Standard approach)
#(repeated 10 times using different random starts)
ModStandard=EMdatastandard(dta,Kbest)