source("cgrq1.r")
source("ncross.rq.fitXB1.r")
source("ps.r")
source("print.gcrq.r")
source("plot.gcrq.r")


d<-read.table("sljumpMuggeo.txt", header=TRUE, sep="\t")

library(splines)
library(quantreg)


my.tau<-.95
o1<-gcrq(slj ~ sex + ps(age) + ps(weight) + ps(height,K=2.5), tau = my.tau, data = d, n.boot = 100, display=TRUE)


par(mfrow=c(1,3))
plot(o1, "age",    res=TRUE, lwd=3, pch.p=19, shade=TRUE, col.p=grey(.1, alpha=.35), conf.level=.95, 
     ylab=paste("ps(age, ", round(o1$edf.j["age"], 2),")",sep=""))
plot(o1, "weight", res=TRUE, lwd=3, pch.p=19, shade=TRUE, col.p=grey(.1, alpha=.35), conf.level=.95, 
     ylab=paste("ps(weight, ", round(o1$edf.j["weight"], 2),")",sep=""))
plot(o1, "height", res=TRUE, lwd=3, pch.p=19, shade=TRUE, col.p=grey(.1, alpha=.35), conf.level=.95, 
     ylab=paste("ps(height, ", round(o1$edf.j["height"], 2),")",sep=""))




