##
## Due to confidentiality problems, the data provided in the Electronic Supplement 
## to illustrate the example in Section 4.1 are data simulated from the fit of the original dataset.
##



#rm(list=ls())
graphics.off()
library(splines)
library(fields)

setwd('C:/Users/ASUS/Desktop/PaperEnviadoRevistas/smj_revision_final_sim/ElectronicSuplements/SOPbiomasa')

getwd() #para ver el directorio donde estamos
datos=read.table("biomasadataSim.txt",header=TRUE)
attach(datos)
head(datos)


diametro = datos[, 1]
altura = datos[, 2]
peso = datos[, 3] 

x1.antes = diametro
x2.antes = altura

x1 = diametro -mean(diametro)
x2 = altura - mean(altura)
length(unique(x1))
length(unique(x2))

y = peso 
summary(x1)
summary(x2)

pord2 = pord1 = 2
nseg1 = 15 
nseg2 = 15 
bdeg = 3

setwd('C:/Users/ASUS/Desktop/PaperEnviadoRevistas/smj_revision_2/Codigos_2/FuncionsSOP')
# se leen todos los ficheiros:
for (f in list.files(pattern="*.R")) {
  source(f)
}


MM1 = MM.basis(x1, min(x1), max(x1), ndx = 15, bdeg = 3, pord = 2, decom =  2 )    
X1 = MM1$X; Z1.sop = MM1$Z; B1 = MM1$B; D1 = MM1$D; knots1= MM1$knots
P.svd.1=svd(t(D1)%*%D1)
U1=(P.svd.1$u)[,1:(ncol(B1)-2)]
d1=(P.svd.1$d)[1:(ncol(B1)-2)]
Delta1=diag(1/sqrt(d1))
omega1=U1%*%Delta1
#omega1 = U1
Z1=B1%*%omega1


MM2 = MM.basis(x2, min(x2), max(x2), ndx = 15, bdeg = 3, pord = 2, decom =  2 )    
X2 = MM2$X; Z2.sop = MM2$Z; B2 = MM2$B; D2 = MM2$D; knots2= MM2$knots
P.svd.2=svd(t(D2)%*%D2)
U2=(P.svd.2$u)[,1:(ncol(B2)-2)]
d2=(P.svd.2$d)[1:(ncol(B2)-2)]
Delta2=diag(1/sqrt(d2))
omega2=U2%*%Delta2
#omega2 = U2
Z2=B2%*%omega2

X = as.matrix(cbind(X1, X2[,2]))
Z = as.matrix(cbind(Z1, Z2))

g1 = c(rep(1, ncol(Z1.sop)), rep(0, ncol(Z2.sop) ) )
g2 =c(rep(0, ncol(Z1.sop)), rep(1, ncol(Z2.sop)) )
fit.SOP =  sop.fit(X = X, y, Z = cbind(Z1, Z2),  G = list(  g1, g2  )) 

sig.2 = as.numeric(fit.SOP$out$la[[1]])
sigma1 = as.numeric(fit.SOP$out$la[[2]])
sigma2 = as.numeric(fit.SOP$out$la[[3]])
G1 = sigma1 * solve(t(omega1) %*% t(D1) %*% D1 %*% omega1  )
G2 = sigma2 * solve(t(omega2) %*% t(D2) %*% D2 %*% omega2  )
G = as.matrix(Matrix::bdiag(G1, G2  ))
R = sig.2 * diag(length(x1))
Rinv = solve(R)


# FIT: 
#Z = as.matrix(cbind(Z1.sop, Z2.sop))
#G.sop = diag(fit.SOP$aver)
V = R + Z %*% G %*% t(Z)
beta = solve(t(X)%*% solve(V) %*% X) %*% t(X) %*% solve(V) %*% y
alpha= G %*% t(Z) %*% solve(V) %*% (y-X %*% beta)
ajuste =  X %*% beta + Z %*% alpha
f1 = X[,2] * beta[2] + Z1 %*% alpha[1:ncol(Z1)]
f2 = X[,3] * beta[3] + Z2 %*% alpha[(ncol(Z1)+1):(ncol(Z1)+ ncol(Z2))]   


# otra forma, con el sistema:
L = rbind( cbind(t(X) %*% Rinv %*% X, t(X) %*% Rinv %*% Z ), cbind(t(Z) %*% Rinv %*% X, t(Z) %*% Rinv %*% Z  + solve(G))    ) 
r = rbind( t(X) %*% Rinv, t(Z) %*% Rinv )
sol.ajuste = cbind(X, Z ) %*% solve(L) %*% r %*% y
summary(sol.ajuste - fit.SOP$fitted.values)

# Para los intervalos de confianza del ajuste:
E.aux.fx1 = diag( c( c(0,1,0),  rep(1, ncol(Z1)), rep(0, ncol(Z2)) ) )
fx1 = cbind(X, Z) %*% E.aux.fx1 %*% solve(L) %*% r %*% y
var.fx1 = cbind(X, Z) %*% E.aux.fx1 %*% solve(L) %*% t(cbind(X, Z) %*% E.aux.fx1 )

# library(mgcv)
# gam.sol = gam(y ~ s(x1,k=15, bs = "ps") + s(x2, k=15, bs="ps") )
# plot(gam.sol)

E.aux.fx2 = diag( c( c(0,0,1),  rep(0, ncol(Z1)), rep(1, ncol(Z2)) ) )
fx2 = cbind(X, Z) %*% E.aux.fx2 %*% solve(L) %*% r %*% y
var.fx2 = cbind(X, Z) %*% E.aux.fx2 %*% solve(L) %*% t(cbind(X, Z) %*% E.aux.fx2 )


# Prediction:
dx1 = 0.2
dx2 = 0.2
x1.pp.22 = seq(max(x1)+dx1 ,11-mean(x1.antes) , length = 6) # cambiar: verte ata 11, unal ata 11 e i123 ata 10
#x1.pp.22 = seq(max(x1)+dx1 , max(x1)+6*dx1 , by = dx1 )
n1.pp.22 = length(x1.pp.22) # voy a predecir para seis nuevos valores de diametro 
x2.pp.22 = seq(max(x2)+dx2 , 15-mean(x2.antes) , length = 10 )
#x2.pp.22 = seq(max(x2)+dx2 , max(x2)+10*dx2 , by = dx2 )
n2.pp.22 = length(x2.pp.22)# voy a predecir para diez nuevos valores de altura

x1.p.22=NULL
for(j in 1:n1.pp.22){
  x1.p.22 = c(x1.p.22, rep(x1.pp.22[j], n2.pp.22 ))
}
x2.p.22 = rep(x2.pp.22, n1.pp.22)

x1.p = x1.p.22; x2.p = x2.p.22

n1.p = length(x1.p)
n2.p = length(x2.p)

# hacia atras:
x2.0 = seq( 0.5-mean(x2.antes), min(x2)-dx2, length = 5 )
x1.0 = sort(x1)[1:length(x2.0)]

n1.0 = length(x1.0); n2.0 = length(x2.0)

x1.new = c(x1.0,x1, x1.p); x2.new = c(x2.0,x2, x2.p)

y.new = c(rep(0, n1.0),y, rep(0, length(x1.p)))

if(n1.p==0){
  full.knots1 = knots1
} else {
  full.knots1 = seq(min(knots1),max(knots1)+60*diff(knots1)[1],by=diff(knots1)[1])
  b =  which(full.knots1>=max(x1.new))
  full.knots1.aux = full.knots1[1:(min(b)+(bdeg))]
  full.knots1 = full.knots1.aux 
}

if(n2.p==0){
  full.knots2 = knots2
} else {
  full.knots2.aux = seq(min(knots2),max(knots2)+60*diff(knots2)[1],by=diff(knots2)[1])
  a =  which(full.knots2.aux>=max(x2.new))
  full.knots2.aux = full.knots2.aux[1:(min(a)+(bdeg))]
  
}



knots2.aux2 = seq(from=min(knots2)-10*diff(knots2)[1],to=min(knots2)-diff(knots2)[1],by=diff(knots2)[1])
a = which(knots2.aux2<=min(x2.new))
a = a[(max(a)-2): max(a)]
knots2.aux22 = knots2.aux2[min(a):length(knots2.aux2)]

full.knots2 <-c(knots2.aux22,full.knots2.aux)  # todos los nodos



B1.new = spline.des(full.knots1, x1.new, bdeg + 1, 0 * x1.new, outer.ok=TRUE)$design
B2.new = spline.des(full.knots2, x2.new, bdeg + 1, 0 * x2.new, outer.ok=TRUE)$design

nb1.new = ncol(B1.new) 
nb2.new = ncol(B2.new)

D1.new = diff(diff(diag(nb1.new))) 
P.svd.1.new = svd(crossprod(D1.new))
U.1.new = (P.svd.1.new$u)[,1:(ncol(B1.new)-2)] # eigenvectors
d.1.new = (P.svd.1.new$d)[1:(ncol(B1.new)-2)]  # eigenvalues
D1.new.2 = D1.new[(nrow(D1)+1):nrow(D1.new), (ncol(D1)+1):ncol(D1.new)]
omega1.new = as.matrix(Matrix::bdiag(omega1, solve(D1.new.2)))
Z1.new = B1.new%*%omega1.new
G1.new = sigma1 * solve( t(omega1.new) %*% t(D1.new) %*% D1.new %*% omega1.new )

D2.new = diff(diff(diag(nb2.new)))
#D2.new = diff(diag(ncol(B2.new)), differences=2)
# P.svd.2.new = svd(crossprod(D2.new))
# U.2.new = (P.svd.2.new$u)[,1:(ncol(B2.new)-2)] # eigenvectors
# d.2.new = (P.svd.2.new$d)[1:(ncol(B2.new)-2)]  # eigenvalues
# D2.new.2 = D2.new[(nrow(D2)+1):nrow(D2.new), (ncol(D2)+1):ncol(D2.new)]
# omega2.new = as.matrix(Matrix::bdiag(omega2, solve(D2.new.2)))
# Z2.new = B2.new%*%omega2.new
# G2.new = sigma2 * solve(t(omega2.new) %*% t(D2.new) %*% D2.new %*% omega2.new  )

u = length(full.knots2) - length(full.knots2.aux)
D2.new.atras = D2.new[1:u, 1:u]
D2.new.delante =  D2.new[(nrow(D2)+u+1):nrow(D2.new), (ncol(D2)+u+1):ncol(D2.new) ]

omega.atras = solve(D2.new.atras)
omega.delante = solve(D2.new.delante)
omega2.new = as.matrix( Matrix::bdiag(omega.atras,omega2, omega.delante) )

Z2.new = B2.new%*%omega2.new
G2.new = sigma2 * solve(t(omega2.new) %*% t(D2.new) %*% D2.new %*% omega2.new  )


G.new = as.matrix(Matrix::bdiag(G1.new, G2.new  ))
R.new = sig.2 * diag( c(rep(0, n1.0),rep(1, length(x1)), rep(0, length(x1.p))) )
Rinv.new = (1/sig.2) * diag( c(rep(0, n1.0),rep(1, length(x1)), rep(0, length(x1.p))) )

X.new  = cbind(rep(1, length(x1.new)), x1.new, x2.new )
Z.new = cbind(Z1.new, Z2.new)
L.new = rbind( cbind(t(X.new) %*% Rinv.new %*% X.new, t(X.new) %*% Rinv.new %*% Z.new ), cbind(t(Z.new) %*% Rinv.new %*% X.new, t(Z.new) %*% Rinv.new %*% Z.new  + solve(G.new))    ) 
r.new = rbind( t(X.new) %*% Rinv.new, t(Z.new) %*% Rinv.new )
sol.ajuste.new = cbind(X.new, Z.new) %*% solve(L.new) %*% r.new %*% y.new

E.aux.fx1.new = diag( c(c(0,1,0), rep(1, ncol(Z1.new)), rep(0, ncol(Z2.new)) ) )
f1.sol.new =  cbind(X.new, Z.new)%*% E.aux.fx1.new  %*% solve(L.new) %*% r.new %*% y.new
var.f1.sol.new =  cbind(X.new, Z.new)%*% E.aux.fx1.new  %*% solve(L.new) %*% t(cbind(X.new, Z.new)%*% E.aux.fx1.new)


E.aux.fx2.new = diag( c(c(0,0,1), rep(0, ncol(Z1.new)), rep(1, ncol(Z2.new)) ) )
f2.sol.new = cbind(X.new, Z.new)%*% E.aux.fx2.new  %*% solve(L.new) %*% r.new %*% y.new
var.f2.sol.new = cbind(X.new, Z.new)%*% E.aux.fx2.new  %*% solve(L.new) %*% t(cbind(X.new, Z.new)%*% E.aux.fx2.new)



# Prediction intervals:
# Para os intervalos de prediccin de x1 
n = length(y)
V1.pred = Z1.new %*% G1.new %*% t(Z1.new) + sig.2 * diag(nrow(Z1.new))
Voo.1 = V1.pred[1:(n+n1.0), 1:(n+n1.0)]
Vop.1 = V1.pred[1:(n+n1.0), (1+(n+n1.0)):ncol(V1.pred)]
Vpo.1 = t(Vop.1)#Vpo.1 = V1.pred[(n+1+n1.0):nrow(V1.pred), 1:(n+n1.0)]
Vpp.1 = V1.pred[(n+1+n1.0):nrow(V1.pred),(n+1+ n1.0):ncol(V1.pred)]
#summary(c(Vpo.1  - t(Vop.1 )))
# Prediction intervals:
UU.1 = Vpp.1 - Vpo.1 %*% solve(Voo.1) %*% Vop.1
IC1predi.1 = (f1.sol.new[(n+1+n1.0):length(f1.sol.new)])[order(x1.p)] + 1.96 * sqrt(diag(UU.1)[order(x1.p)])
IC2predi.1 = (f1.sol.new[(n+1+n1.0):length(f1.sol.new)])[order(x1.p)] - 1.96 * sqrt(diag(UU.1)[order(x1.p)])



# Para os intervalos de prediccin de x2
n = length(y)
V2.pred = Z2.new %*% G2.new %*% t(Z2.new) + sig.2 * diag(nrow(Z2.new))
Vaa.2 = V2.pred[1:n2.0, 1:n2.0]
Vao.2 = V2.pred[1:n2.0, (n2.0+1): (n+n2.0)]
Voa.2 = V2.pred[(n2.0+1): (n+n2.0), 1:n2.0]
#round(Voa.2-t(Vao.2),4)
Voo.2 = V2.pred[(n2.0+1):(n+n2.0), (n2.0+1):(n+n2.0)]
Vop.2 = V2.pred[(n2.0+1):(n+n2.0), (n2.0+1+n):ncol(V2.pred)]
Vpo.2 = V2.pred[(n+n2.0+1):nrow(V2.pred), (n2.0+1):(n+n2.0)]
Vpp.2 = V2.pred[(n+n2.0+1):nrow(V2.pred),(n+n2.0+1):ncol(V2.pred)]

# Prediction intervals:
UU.2 = Vpp.2 - Vpo.2 %*% solve(Voo.2) %*% Vop.2
IC1predi.2 = (f2.sol.new[(n2.0+n+1):length(f2.sol.new)])[order(x2.p)] + 1.96 * sqrt(diag(UU.2)[order(x2.p)])
IC2predi.2 = (f2.sol.new[(n2.0+n+1):length(f2.sol.new)])[order(x2.p)] - 1.96 * sqrt(diag(UU.2)[order(x2.p)])

UU2.2 = Vaa.2 - Vao.2 %*% solve(Voo.2) %*% Voa.2
IC1predi2.2 = (f2.sol.new[1:n2.0])[ order(x2.0) ] + 1.96 * sqrt(diag(UU2.2)[ order(x2.0) ])
IC2predi2.2 = (f2.sol.new[1:n2.0])[ order(x2.0) ] - 1.96 * sqrt(diag(UU2.2)[ order(x2.0)])






## Si lo que quiero son los grficos de los partial residuals:
partial.diam = y - X.new[ (n1.0+1):(n1.0+n) ,1]*beta[1] - f2.sol.new[(n1.0+1):(n1.0+n) ]
#aux.1 = - mean(partial.diam) + mean(y)
#partial.diam.cent = partial.diam + aux.1
partial.diam.cent = partial.diam 

x11();
par(mfrow=c(1,2))

int1.1 = f1.sol.new [order(x1.new)]  + 1.96 * sqrt( diag( var.f1.sol.new)[order(x1.new)])
int1.2 = f1.sol.new[order(x1.new)]- 1.96 * sqrt( diag( var.f1.sol.new)[order(x1.new)])
plot(x1.new[order(x1.new)]+ mean(x1.antes), f1.sol.new, ylim = range(f1.sol.new , int1.1 , int1.2 , IC1predi.1 , IC2predi.1), type = "n", xlab = 'diameter', ylab = 'partial effects', cex.lab = 1.3)
#lines(x1.new, fx1.new[order(x1.new)] + aux.1, col=2)
lines(x1.new[order(x1.new)] + mean(x1.antes),f1.sol.new[order(x1.new)]  , lwd = 2)
lines(x1.new[order(x1.new)] + mean(x1.antes), int1.1 , lwd = 2, lty = 1, col='grey')
lines(x1.new[order(x1.new)] + mean(x1.antes), int1.2 , lwd = 2, lty = 1, col ='grey')
abline(v = max(x1)+mean(x1.antes))
lines((x1.new[(n+1+n1.0):length(f1.sol.new)])[order(x1.new[(n+1+n1.0):length(f1.sol.new)])]+ mean(x1.antes), IC1predi.1 , lwd=2, lty=2)
lines((x1.new[(n+1+n1.0):length(f1.sol.new)])[order(x1.new[(n+1+n1.0):length(f1.sol.new)])]+ mean(x1.antes), IC2predi.1, lwd=2, lty=2)
points(x1+ mean(x1.antes), partial.diam.cent,pch=".",cex=6)

#abline(v = min(x1))
#points(x1, y)



partial.height = y - X.new[ (n1.0+1):(n1.0+n) ,1]*beta[1] - f1.sol.new[(n1.0+1):(n1.0+n) ]
#aux.2 = - mean(partial.height) + mean(y)
#partial.height.cent = partial.height + aux.2
partial.height.cent = partial.height 

int2.1 = f2.sol.new[order(x2.new)] + 1.96 * sqrt( diag( var.f2.sol.new)[order(x2.new)])
int2.2 = f2.sol.new[order(x2.new)] - 1.96 * sqrt( diag( var.f2.sol.new)[order(x2.new)]) 
plot(x2.new + mean(x2.antes), f2.sol.new, ylim = range(f2.sol.new, int2.1 ,int2.2, IC1predi.2, IC2predi.2,IC1predi2.2, IC2predi2.2), type = "n", xlab = 'height', ylab = 'partial effects', cex.lab = 1.3) #stem biomass
lines(x2.new[order(x2.new)]+mean(x2.antes),f2.sol.new[order(x2.new)], lwd = 2)
lines(x2.new[order(x2.new)]+mean(x2.antes),int2.1 , lwd = 2, lty = 1, col='grey')
lines(x2.new[order(x2.new)]+mean(x2.antes),int2.2 , lwd = 2, lty = 1, col='grey')
abline(v = max(x2)+mean(x2.antes))
abline(v = min(x2)+mean(x2.antes))
lines((x2.new[(n+1+n2.0):length(f2.sol.new)])[order(x2.new[(n+1+n2.0):length(f2.sol.new)])]+mean(x2.antes), IC1predi.2, lwd=2, lty=2)
lines((x2.new[(n+1+n2.0):length(f2.sol.new)])[order(x2.new[(n+1+n2.0):length(f2.sol.new)])]+mean(x2.antes), IC2predi.2, lwd=2, lty=2)

lines(x2.new[1:n2.0]+mean(x2.antes), IC1predi2.2, lwd=2, lty=2)
lines(x2.new[1:n2.0]+mean(x2.antes), IC2predi2.2, lwd=2, lty=2)
points(x2+mean(x2.antes), partial.height.cent, pch=".",cex=6)


x11();
par(mfrow=c(1,2))
plot(x1, y, pch=".",cex=6, xlab = 'diameter', cex.lab = 1.3, ylab = 'stem biomass' )
plot(x2, y, pch=".",cex=6, xlab = 'height', cex.lab = 1.3, ylab = 'stem biomass' )


# x11();
# par(mfrow=c(1,2))
# plot(x1 + mean(x1.antes), y, xlab = 'diameter', cex.lab = 1.3, ylab = 'stem biomass' )
# plot(x2 + mean(x2.antes), y,  xlab = 'height', cex.lab = 1.3, ylab = 'stem biomass' )
# 

# x11();
# par(mfrow=c(1,2))
# plot(x1 + mean(x1.antes), ajuste, xlab = 'diameter', cex.lab = 1.3, ylab = 'stem biomass' )
# plot(x2 + mean(x2.antes), ajuste,  xlab = 'height', cex.lab = 1.3, ylab = 'stem biomass' )



