summary.sop <- function(object, ...) {
	edf <- object$out$edf
	nam <- names(edf)
	edf <- c(edf, sum(edf), sum(edf) + length(object$b.fixed))
	names(edf) <- c(nam, "Total edf", "Total")
	nobs <- length(object$y) 
	residual.df <- nobs - sum(object$out$edf)
	w <- object$weights
	mean.y <- sum(w * object$y)/sum(w)
	w <- sqrt(w)
	r.sq <- if(inherits(object$family, "general.family") || !is.null(object$family$no.r.sq)) { 
		NULL
	} else {
		1-var(w*(as.numeric(object$y) - object$fitted.values))*(nobs - 1)/(var(w*(as.numeric(object$y) - mean.y))*residual.df)
    }
	deviance <- sum(object$dev.residuals)
	dev.expl <- (object$null.deviance - deviance)/object$null.deviance    
	out <- list(call = object$call, b.random = object$b.random, 
				b.fixed = object$b.fixed, deviance = object$deviance,
				r.sq =r.sq, null.deviance = object$null.deviance,
				dev.expl = dev.expl, n = nobs, iter= object$out$it,
				residual.df = residual.df, edf = edf,
				formula = object$formula, family = object$family,
				na.action = object$na.action)
	
    class(out) <- "summary.sop"
	out
}