#############################################################################################
construct.1D.prediction.matrix <- function(object, newdata) {
	x.coord <- newdata[,object$vars]    
	B <- spline.bbase(object$Xmat$terms$MM$knots, x.coord, object$degree)
	X <- B%*%object$Xmat$terms$MM$U.X
	Z <- B%*%object$Xmat$terms$MM$U.Z
	X <- X[,-1,drop = FALSE]    
	res <- list(X = X, Z = Z)
	res  
}
#############################################################################################
construct.2D.prediction.matrix <- function(object, newdata) {
	x.coord <- newdata[,object$vars[1]]
	y.coord <- newdata[,object$vars[2]]    
	B1p <- spline.bbase(object$Xmat$terms$MM$MM1$knots, x.coord, object$degree[1])
	B2p <- spline.bbase(object$Xmat$terms$MM$MM2$knots, y.coord, object$degree[2])    
	X1p <- B1p%*%object$Xmat$terms$MM$MM1$U.X
	X2p <- B2p%*%object$Xmat$terms$MM$MM2$U.X  
	Z1p <- B1p%*%object$Xmat$terms$MM$MM1$U.Z
	Z2p <- B2p%*%object$Xmat$terms$MM$MM2$U.Z    
	Xp = Rten2(X2p, X1p)
	Xp <- Xp[,-1,drop = FALSE]    
	Zp = cbind(Rten2(X2p, Z1p), Rten2(Z2p, X1p), Rten2(Z2p, Z1p))    
	res <- list(X = Xp, Z = Zp)
	res	
}
#############################################################################################
construct.3D.prediction.matrix <- function(object, newdata) {
	x.coord <- newdata[,object$vars[1]]
	y.coord <- newdata[,object$vars[2]]    
	z.coord <- newdata[,object$vars[3]]        
	B1p <- spline.bbase(object$Xmat$terms$MM$MM1$knots, x.coord, object$degree[1])
	B2p <- spline.bbase(object$Xmat$terms$MM$MM2$knots, y.coord, object$degree[2])
	B3p <- spline.bbase(object$Xmat$terms$MM$MM3$knots, z.coord, object$degree[3])
	X1p <- B1p%*%object$Xmat$terms$MM$MM1$U.X
	X2p <- B2p%*%object$Xmat$terms$MM$MM2$U.X  
	X3p <- B3p%*%object$Xmat$terms$MM$MM3$U.X  
	Z1p <- B1p%*%object$Xmat$terms$MM$MM1$U.Z
	Z2p <- B2p%*%object$Xmat$terms$MM$MM2$U.Z    
	Z3p <- B2p%*%object$Xmat$terms$MM$MM3$U.Z    
	rx12<-Rten2(X1p,X2p)  			
	Xp <- Rten2(rx12,X3p)    
	Xp <- Xp[,-1,drop = FALSE]    
	Zp <- cbind(Rten2(Rten2(Z1p,X2p), X3p), 
				Rten2(Rten2(X1p,Z2p), X3p),
				Rten2(rx12, Z3p),
				Rten2(Rten2(Z1p,Z2p), X3p),
				Rten2(Rten2(Z1p,X2p), Z3p),
				Rten2(Rten2(X1p,Z2p), Z3p),
				Rten2(Rten2(Z1p,Z2p), Z3p))
	res <- list(X = Xp, Z = Zp)
	res  
  }
#############################################################################################
construct.random.prediction.matrix <- function(object, newdata) {
	if(!is.null(object$random)) {
		Zp <- NULL
		mfp <- model.frame(object$random, newdata, xlev = attr(object$random, "xlev"), na.action = na.pass)
		Zp <- model.matrix(object$random, data = mfp, contrasts.arg = attr(object$random, "contrast"))
		Zp <- Zp[,-1,drop = FALSE]
		Zp[is.na(Zp)] <- 0
	} else {
		Zp <- NULL
	}
	Zp
}
#############################################################################################
construct.fixed.prediction.matrix <- function(object, newdata) {
	if(!is.null(object$lin$terms)) {
		mfp <-model.frame(object$lin$terms, newdata, xlev = attr(object$lin$terms, "xlev"))
		Xp <- model.matrix(object$lin$terms, data = mfp, contrasts.arg = attr(object$lin$terms, "contrast"))
		Xp <- Xp[,-1,drop = FALSE]
	} else {
		Xp <- NULL
	}
	Xp
}
#############################################################################################
predict.sop <- function(object, newdata, type = "response", terms = NULL , na.action = na.pass, ...) {
	if (missing(newdata)) {
		if(type == "link") {
			pred <- object$linear.predictors
			return(pred)
		} else if (type == "response"){
			pred <- object$fitted.values
			return(pred)

		} else {
			newdata = object$dat
		}
	}
	cnames <- object$names.terms
	if (type == "terms") {
		if (is.null(terms)) {
			terms <- cnames
		} else { 
			if (sum(!(terms %in% cnames))) {
				stop("Non-existent terms requested")
			}
		}
	}
	b.fixed <- object$b.fixed
	b.random <- object$b.random
	nlin <- object$nterms[1]
	nre  <- object$nterms[2]
	nfun <- object$nterms[3]

	Z <- X <- NULL  
	pterms <- type == "terms"
	y.terms <- NULL
	names.terms <- object$names.terms

	dim.fixed <- c(if(nlin > 0) object$lin$dim, if(nfun > 0) unlist(lapply(object$f, function(x) x$Xmat$dim$fixed)))
	dim.random <- c(if(nre > 0) object$random$dim, if(nfun > 0) unlist(lapply(object$f, function(x) x$Xmat$dim$random)))

	e.f <- cumsum(dim.fixed)
	s.f <- e.f - dim.fixed + 1

	e.r <- cumsum(dim.random)
	s.r <- e.r - dim.random + 1

	if (nlin > 0) {
		X <- construct.fixed.prediction.matrix(object, newdata)
		lab <- object$lin$vars
		if (pterms) {
			for (i.lin in 1:length(lab)) {
				if ((cnames[i.lin] %in% terms))  {
					vcum <- s.f[i.lin]:e.f[i.lin]
					yt <- as.vector(X[,vcum, drop = FALSE]%*%b.fixed[vcum + 1])
					y.terms <- cbind(y.terms, yt)
				}
			}
		}
	}
	if (nre > 0) {
		aa <- construct.random.prediction.matrix(object, newdata) 
		lab <- object$random$vars
		if (pterms) {
			for (i.re in 1:length(lab)) {
				if ((cnames[i.re + nlin] %in% terms))  {
					vcum <- s.r[i.re]:e.r[i.re]
					yt <- as.vector(aa[,vcum, drop = FALSE]%*%b.random[vcum])
					y.terms <- cbind(y.terms, yt)  
				}
			}
		}
		Z <- cbind(Z, aa)
	}  
	if (nfun > 0){    
		for (i.fun in 1:nfun) {			
			lab <- object$f[[i.fun]]$label
			aa <- switch(as.character(object$f[[i.fun]]$dim),
			   "1" = {
				aa <- construct.1D.prediction.matrix(object$f[[i.fun]],newdata)					
			}, "2" = {      
				aa <- construct.2D.prediction.matrix(object$f[[i.fun]],newdata)				
			}, "3" = {
				aa <- construct.3D.prediction.matrix(object$f[[i.fun]],newdata)				
			}
			)
			if (pterms && (cnames[i.fun + nre + nlin] %in% terms)) {
				vcum.f <- s.f[i.fun + nlin]:e.f[i.fun + nlin]
				vcum.r <- s.r[i.fun + nre]:e.r[i.fun + nre]
				yt <- aa$X%*%b.fixed[vcum.f + 1] + aa$Z%*%b.random[vcum.r]
				y.terms <- cbind(y.terms,yt)
			}
			X <- cbind(X, aa$X)
			Z <- cbind(Z, aa$Z)
		} 
	}

	if (is.null(object$offset)) offset <- 0
	if (length(b.fixed) > 1) {
		eta <- b.fixed[1] + X%*%b.fixed[-1] + Z%*%b.random + offset
	} else { 
		eta <- b.fixed[1] + Z%*%b.random + offset
	}
	if (type=="response") yp <- object$family$linkinv(eta)
	if (type=="link") yp <- eta
	if (pterms) {
		iterms <- which(cnames %in% terms)
		colnames(y.terms) <- object$names.terms[iterms]
		rownames(y.terms) <- rownames(newdata)
		attr(y.terms,"constant") <- b.fixed[1]
		y.terms
	} else {
		drop(yp)
	}
}
