

######  gamma frailty

####  parallel computing and n.cores is the number of cores used in the simulation


r1 = 0
r2 = 0

n = 200

beta0 = c(0.5, -0.5)

eta0 <- 1   #### variance is eta0

n.cores = 20

n.bs = 100

mm = 500

max.loops = 200

loglik.b_n <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

Expx1betab = exp(as.matrix(x1[[1]])*beta[1] + as.matrix(x1[[2]])*beta[2]+log(g))#### k = 1
Expx2betab = exp(as.matrix(x2[[1]])*beta[1] + as.matrix(x2[[2]])*beta[2]+log(g))#### k = 2

L1 = matrix(rep(lambda1, each=n), n, m1)*Expx1betab 
#### n by m1

L2 = matrix(rep(lambda2, each=n), n, m2)*Expx2betab  
#### n by m2

s1 = rep(0,n)
s2 = rep(0,n)

s1 = exp(-G1(rowSums(L1*Ind.c1)))
s2 = exp(-G2(rowSums(L2*Ind.c2)))

f1 = rowSums(matrix(rep(lambda1, each=n),n, m1)*Expx1betab*Ind.d21)*dG1(rowSums(L1*Ind.c1))*s1
f2 = rowSums(matrix(rep(lambda2, each=n),n, m2)*Expx2betab*Ind.d22)*dG2(rowSums(L2*Ind.c2))*s2

f1[f1<=0] = 10
f2[f2<=0] = 10

results = d11*log(((1-s1)<=0)*10^(-3)+((1-s1)>0)*(1-s1)) + 
d12*log(f1) + d13*log(s1) +
d21*log(((1-s2)<=0)*10^(-3)+((1-s2)>0)*(1-s2)) + 
d22*log(f2) + d23*log(s2)

return(results) ## n by 1

}


E.Z1.b.d <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

Expx1betab = exp(as.matrix(x1[[1]])*beta[1] + as.matrix(x1[[2]])*beta[2]+log(g)) #### k = 1

L1 = matrix(rep(lambda1, each=n), n, m1)*Expx1betab

W1 = rep(0,n)
W1 = rowSums(L1*Ind.c1)

results = d11*g*(1-exp(-G1(W1)))^(-1)

return(results)

### n by 1
}

E.Z2.b.d <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){  #### k = 2

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

Expx2betab = exp(as.matrix(x2[[1]])*beta[1] + as.matrix(x2[[2]])*beta[2]+log(g))

L2 = matrix(rep(lambda2, each=n), n, m2)*Expx2betab
#### n by m2

W2 = rep(0,n)

W2 = rowSums(L2*Ind.c2)

results = d21*g*(1-exp(-G2(W2)))^(-1)

return(results)
### n by 1



}

E.mu1.b <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){ #### k = 1

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

Expx1betab = exp(as.matrix(x1[[1]])*beta[1] + as.matrix(x1[[2]])*beta[2]+log(g))

L1 = matrix(rep(lambda1, each=n),n,m1)*Expx1betab
#### n by m1

W1 = rep(0,n)

W1 = rowSums(L1*Ind.c1)

if(r1>0){

results = g*(d11*(1-(r1*W1+1)^(-r1^(-1)-1))/(1-exp(-G1(W1)))+d12*(1+r1)/(r1*W1+1)+
d13*(r1*W1+1)^(-r1^(-1)-1)/exp(-G1(W1)))

} else results = g

return(results)### n by 1

}


E.mu2.b <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

Expx2betab = exp(as.matrix(x2[[1]])*beta[1] + as.matrix(x2[[2]])*beta[2]+log(g))

L2 = matrix(rep(lambda2, each=n), n, m2)*Expx2betab
#### n by m2

W2 = rep(0,n)

W2 = rowSums(L2*Ind.c2)

if(r2>0){

results = g*(d21*(1-(r2*W2+1)^(-r2^(-1)-1))/(1-exp(-G2(W2)))+d22*(1+r2)/(r2*W2+1)+
d23*(r2*W2+1)^(-r2^(-1)-1)/exp(-G2(W2)))

} else results = g

return(results)### n by 1

}




########### eta

E.b.fun <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

results = g

return(results)##### n by 1

}


E.logb.fun <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta){

cdf.b = pnorm(b, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

g = qgamma(cdf.b, eta^(-1), eta^(-1), lower.tail = TRUE,log.p = FALSE)

results = log(g)

return(results)##### n by 1

}




Expec.fun<-function(beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1, G2){

E.mu1.exp.b = eval.h(loglik.b_n, E.mu1.b, grid, X = NULL, W = NULL,beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

E.mu2.exp.b = eval.h(loglik.b_n, E.mu2.b, grid, X = NULL, W = NULL,beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)

E.z_i1 = eval.h(loglik.b_n, E.Z1.b.d, grid, X = NULL, W = NULL,beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

E.z_i2 = eval.h(loglik.b_n, E.Z2.b.d, grid, X = NULL, W = NULL,beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 2

E.b = eval.h(loglik.b_n, E.b.fun, grid, X = NULL, W = NULL,beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

E.logb = eval.h(loglik.b_n, E.logb.fun, grid, X = NULL, W = NULL,beta, lambda1, lambda2, eta, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

return(list(E.mu1.exp.b = E.mu1.exp.b, E.mu2.exp.b = E.mu2.exp.b, 
E.z_i1=E.z_i1,E.z_i2 = E.z_i2, E.b = E.b, E.logb = E.logb))


}



#################################################################
G1.fun <- function(u){#### 
      if(r1 > 0){
      results = log(((1+r1*u)<=0)*10^(-3)+(1+r1*u>0)*(1+r1*u))/r1
      } else results = u
      return(results)
}


G1.inv <- function(u){
   if (r1 > 0) {
      results = (exp(u*r1)-1)/r1
      } else results = u
      return(results)
}

G2.fun <- function(u){#### 
      if(r2 > 0){ 
      results = log(((1+r2*u)<=0)*10^(-3)+(1+r2*u>0)*(1+r2*u))/r2
      } else results = u
      return(results)
}


G2.inv <- function(u){
      if(r2 > 0){ 
      results = (exp(u*r2)-1)/r2
      } else results = u
      return(results)
}


dG1.fun <- function(u){#### 
      if(r1 > 0){
      results = 1/(1+r1*u)
      } else results = 1
      return(results)
}


dG2.fun <- function(u){#### 
      if(r2 > 0){
      results = 1/(1+r2*u)
      } else results = 1
      return(results)
}



##############################################################






####exp(W) weight function  
###FUN=loglik.b_n
###(b,beta.hat,lambda1.hat,lambda2.hat,z,Ind.c1,Ind.c2,G1.fun,G2.fun)  
###X=grid.

eval.h <- function (FUN,h.fun,grid,X = NULL,W = NULL,beta,lambda1,lambda2,eta,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2) 
{
    grid <- init.quad(Q  =  1,  prior  =  list(mu  =  0,  Sigma  =  1),ip=10)
    if (is.list(grid)) {
        W <- grid$W
        X <- grid$X
    }
    if (is.null(X) | is.null(W)) 
        stop("Quadrature points and weights are required. See init.gauss.", 
            call. = F)
    FUN <- match.fun(FUN)
    h.fun <- match.fun(h.fun)
    Q <- ncol(X)
    ipq <- length(W)
    f <- matrix(1,n,ipq)
    h <- matrix(1,n,ipq)
 
    for (i in 1:ipq) {  
f[,i] <- FUN(X[i],beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta)+
W[i]
    }

    for (i in 1:ipq) {
h[,i] <- h.fun(X[i],beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2,eta)
    }
    m <- 700 - max(f)
    f <- f + m
    f <- exp(f)
    p1 <- rowSums(f)
    estimate <- rowSums(f * h)/p1 #### dim(estimate) = n by 1
    return(estimate)
}

##########################################################################

time1= date()

library(MultiGHQuad)

library(survival)

library(pracma)

library(doParallel)

library(doRNG)

ccl <- makeCluster(n.cores)

registerDoParallel(ccl)

###################################################################


tol = 10^(-3)

p <- length(beta0) ### dimension

beta1 = matrix(1,mm,p)
std.b = matrix(1,mm,p)
eta1 = rep(1,mm)
std.eta = rep(1,mm)
cp.b1 = matrix(1,mm,p)
cp.eta1 = rep(1,mm)



##############################################


for(r in 1: mm ){

g = rgamma(n, eta0^(-1), eta0^(-1))

loops = 0

diff.theta = 100

tol = 10^(-3)

tau = 5
##### left and right censored times
U1 <- runif(n,0,1)
U2 <- runif(n,3,tau)


V <- rep(10^100,n)

x11 = rbinom(n,1,0.5) ####  the first covariate
x12 = rbinom(n,1,0.5)

x22 = runif(n,0,1) ####  the second covariate

w1 = runif(n,0,1)

w2 = runif(n,0,1)

####Lambda_1 = Lambda_2 = 0.2*t

t11 <- 5*G1.inv(-log(w1))*exp(-as.matrix(cbind(x11,x22))%*%as.matrix(beta0)-log(g))


t12 <- 5*(G1.inv(-log(w1)) - 0.2*(exp(as.matrix(cbind(x11,x22))%*%as.matrix(beta0)+log(g))-
exp(as.matrix(cbind(x12,x22))%*%as.matrix(beta0)+log(g)))*V)*
(exp(as.matrix(cbind(x12,x22))%*%as.matrix(beta0)+log(g)))^(-1)

t1 = t11*(t11<=V) + t12*(t12>V)

t1[t1==Inf] = 10^3 

t21 <- 5*G2.inv(-log(w2))*exp(-as.matrix(cbind(x11,x22))%*%as.matrix(beta0)-log(g))


t22 <- 5*(G2.inv(-log(w2)) - 0.2*(exp(as.matrix(cbind(x11,x22))%*%as.matrix(beta0)+log(g))-
exp(as.matrix(cbind(x12,x22))%*%as.matrix(beta0)+log(g)))*V)*
(exp(as.matrix(cbind(x12,x22))%*%as.matrix(beta0)+log(g)))^(-1)

t2 = t21*(t21<=V) + t22*(t22>V)

t2[t2==Inf] = 10^3 

tt1 = pmax(pmin(U2,t1),U1) ######  times for analysis
tt2 = pmax(pmin(U2,t2),U1)

d11 = 1*(t1<U1)
d12 = (t1>=U1)*(t1<U2)
d13 = 1*(t1>=U2)

d21 = 1*(t2<U1)
d22 = (t2>=U1)*(t2<U2)
d23 = 1*(t2>=U2)

c11 = tt1*(1-d13)
c1 = c11[c11!=0]

c22 = tt2*(1-d23)
c2 = c22[c22!=0]

order.c1 <- sort(unique(c1))

order.c2 <- sort(unique(c2))

m1 = length(order.c1)

m2 = length(order.c2)

Ind.c1 = matrix(rep(order.c1,each=n), n, m1) <= matrix(rep(tt1,m1), n, m1)

Ind.c2 = matrix(rep(order.c2,each=n), n, m2) <= matrix(rep(tt2,m2), n, m2)

Ind.d21 = matrix(rep(order.c1,each=n), n, m1) == matrix(rep(tt1,m1), n, m1)

Ind.d22 = matrix(rep(order.c2,each=n), n, m2) == matrix(rep(tt2,m2), n, m2)

Ind.V1 = matrix(rep(order.c1,each =n),n,m1) <= matrix(rep(V,m1),n,m1)
Ind.V2 = matrix(rep(order.c2,each =n),n,m2) <= matrix(rep(V,m2),n,m2)


#####covariates

x1 = x2 = list() #########  covariates list

x1[[1]] = matrix(rep(x11,m1),n,m1)*Ind.V1 + matrix(rep(x12,m1),n,m1)*(1-Ind.V1) ### The first component of x1
x1[[2]] = matrix(rep(x22,m1),n,m1) ### The second component of x1

x2[[1]] = matrix(rep(x11,m2),n,m2)*Ind.V2 + matrix(rep(x12,m2),n,m2)*(1-Ind.V2)
x2[[2]] = matrix(rep(x22,m2),n,m2)

####### initial values ############


b.ini = rep(0,p)

lambda1.ini = rep(1/n,m1)

lambda2.ini = rep(1/n,m2)

eta.ini <- 0.8

######### we have obtained all initial values so far.

b.hat = b.ini

lambda1.hat = lambda1.ini
lambda2.hat = lambda2.ini
eta.hat = eta.ini


############ judge start ##############

while(diff.theta >= tol && loops < max.loops){

grid <- init.quad(Q  =  1,  prior  =  list(mu  =  0,  Sigma  = 1))

########E-step

Expec.value = 
Expec.fun(b.hat,lambda1.hat,lambda2.hat,eta.hat,x1,x2,Ind.c1,Ind.c2,dG1.fun,dG2.fun,G1.fun, G2.fun)

E.mu1.exp.b = Expec.value$E.mu1.exp.b  ###n by 1
E.mu2.exp.b = Expec.value$E.mu2.exp.b

E.mu1 = E.mu1.exp.b 
E.mu2 = E.mu2.exp.b 

E.b = Expec.value$E.b
E.logb = Expec.value$E.logb


Expx1beta = exp(as.matrix(x1[[1]])*b.hat[1] + as.matrix(x1[[2]])*b.hat[2])
Expx2beta = exp(as.matrix(x2[[1]])*b.hat[1] + as.matrix(x2[[2]])*b.hat[2])

E.z_i1k = matrix(rep(d11,m1),n,m1)*matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
Expec.value$E.z_i1*Ind.c1 + matrix(rep(d12,m1),n,m1)*Ind.d21 +
matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
matrix(rep(E.mu1,m1),n,m1)*(1-Ind.c1) ###n by m1

E.z_i2k = matrix(rep(d21,m2),n,m2)*matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
Expec.value$E.z_i2*Ind.c2+ matrix(rep(d22,m2),n,m2)*Ind.d22 +
matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
matrix(rep(E.mu2,m2),n,m2)*(1-Ind.c2)  ###n by m2


########M-step


#####  beta is 2 by 1
####  k = 1

num1 = rbind(colSums(x1[[1]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta),
colSums(x1[[2]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta)) #### 2 by m1 

denom1 = colSums(matrix(rep(E.mu1,m1),n,m1)*Expx1beta)   #####  1 by m1


####  k = 2

num2 = rbind(colSums(x2[[1]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta),
colSums(x2[[2]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta)) #### 2 by m2 

denom2 = colSums(matrix(rep(E.mu2,m2),n,m2)*Expx2beta)   #####  1 by m2

################################

U.11 = sum(E.z_i1k*x1[[1]]) - sum(colSums(E.z_i1k)*((num1/denom1)[1,]))+
sum(E.z_i2k*x2[[1]]) - sum(colSums(E.z_i2k)*((num2/denom2)[1,]))  ####  the first component

U.12 = sum(E.z_i1k*x1[[2]]) - sum(colSums(E.z_i1k)*((num1/denom1)[2,]))+
sum(E.z_i2k*x2[[2]]) - sum(colSums(E.z_i2k)*((num2/denom2)[2,]))

U.1 = c(U.11,U.12)

################################################################################

I.11 = sum(-colSums(E.z_i1k)*(colSums(x1[[1]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1[[1]])*
denom1 - num1[1,]*num1[1,])/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2[[1]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2[[1]])*
denom2 - num2[1,]*num2[1,])/denom2^2)

I.22 = sum(-colSums(E.z_i1k)*(colSums(x1[[2]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1[[2]])*
denom1 - num1[2,]*num1[2,])/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2[[2]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2[[2]])*
denom2 - num2[2,]*num2[2,])/denom2^2) 

I.12 = sum(-colSums(E.z_i1k)*(colSums(x1[[1]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1[[2]])*
denom1 - num1[1,]*num1[2,])/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2[[1]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2[[2]])*
denom2 - num2[1,]*num2[2,])/denom2^2)

I.1 = matrix(c(I.11,I.12,I.12,I.22),2,2)



b.est = b.hat - solve(I.1)%*%(U.1)
if(any(is.na(b.est))) b.est = beta0

Expx1beta = exp(as.matrix(x1[[1]])*b.est[1] + as.matrix(x1[[2]])*b.est[2])
Expx2beta = exp(as.matrix(x2[[1]])*b.est[1] + as.matrix(x2[[2]])*b.est[2])


##### lambda_1 and lambda_2

lambda1.est = apply(E.z_i1k,2,sum)/apply(matrix(rep(E.mu1,m1),n,m1)*Expx1beta,2,sum)
if(any(is.na(lambda1.est))) lambda1.est = lambda1.ini

lambda2.est = apply(E.z_i2k,2,sum)/apply(matrix(rep(E.mu2,m2),n,m2)*Expx2beta,2,sum)
if(any(is.na(lambda2.est))) lambda2.est = lambda2.ini



#####obtain the estimator of eta#####################

v.hat = log(eta.hat^(-1))

U.v = n*(exp(v.hat)+v.hat*exp(v.hat)) + exp(v.hat)*sum(E.logb-E.b) - n*digamma(exp(v.hat))*exp(v.hat)

I.v = n*(2*exp(v.hat)+v.hat*exp(v.hat)) + exp(v.hat)*sum(E.logb-E.b) -
      n*(trigamma(exp(v.hat))*exp(v.hat)+digamma(exp(v.hat)))*exp(v.hat)
v.est = v.hat - solve(I.v)*U.v

if(any(is.na(v.est))) v.est = log(eta.ini^(-1))

eta.est = as.vector(exp(-v.est))

diff.eta = eta.est - eta.hat

diff.beta = b.est - b.hat

diff.lambda1 = lambda1.est - lambda1.hat
diff.lambda2 = lambda2.est - lambda2.hat

diff.theta = max(abs(diff.beta),abs(diff.lambda1), abs(diff.lambda2),abs(diff.eta)) 

b.hat = b.est

lambda1.hat = lambda1.est
lambda2.hat = lambda2.est
eta.hat = eta.est

loops = loops+1


}

######### judge end #########



beta1[r,] = b.hat
b.hat1 = b.hat

eta1[r] = eta.hat
eta.hat1 = eta.hat


###########  variance 
#######  bootstrap
data <- array(cbind(U1,U2,t1,t2,x11,x12,x22,V),c(n,8),dimnames=list(1:n, c("U1","U2","t1","t2","x11","x12","x22","V")))


xxx <- foreach(bs = 1:n.bs, .combine = cbind, 
.packages = c("MultiGHQuad","survival","pracma",
"doRNG")) %dorng%{

diff.theta  = 100
loops = 0

my.data<-data[sample(1:dim(data)[1], size=n,replace=TRUE),]

U1 = my.data[ ,"U1"]
U2 = my.data[ ,"U2"]
t1 = my.data[ ,"t1"]
t2 = my.data[ ,"t2"]
x11 = my.data[ ,"x11"]
x12 = my.data[ ,"x12"]
x22 = my.data[ ,"x22"]
V = my.data[ ,"V"]

tt1 = pmax(pmin(U2,t1),U1) ######  times for analysis
tt2 = pmax(pmin(U2,t2),U1)

d11 = 1*(t1<U1)
d12 = (t1>=U1)*(t1<U2)
d13 = 1*(t1>=U2)

d21 = 1*(t2<U1)
d22 = (t2>=U1)*(t2<U2)
d23 = 1*(t2>=U2)

c11 = tt1*(1-d13)
c1 = c11[c11!=0]

c22 = tt2*(1-d23)
c2 = c22[c22!=0]

order.c1 <- sort(unique(c1))

order.c2 <- sort(unique(c2))

m1 = length(order.c1)

m2 = length(order.c2)

Ind.c1 = matrix(rep(order.c1,each=n), n, m1) <= matrix(rep(tt1,m1), n, m1)

Ind.c2 = matrix(rep(order.c2,each=n), n, m2) <= matrix(rep(tt2,m2), n, m2)

Ind.d21 = matrix(rep(order.c1,each=n), n, m1) == matrix(rep(tt1,m1), n, m1)

Ind.d22 = matrix(rep(order.c2,each=n), n, m2) == matrix(rep(tt2,m2), n, m2)

Ind.V1 = matrix(rep(order.c1,each =n),n,m1) <= matrix(rep(V,m1),n,m1)
Ind.V2 = matrix(rep(order.c2,each =n),n,m2) <= matrix(rep(V,m2),n,m2)


#####covariates

x1 = x2 = list() #########  covariates list

x1[[1]] = matrix(rep(x11,m1),n,m1)*Ind.V1 + matrix(rep(x12,m1),n,m1)*(1-Ind.V1) ### The first component of x1
x1[[2]] = matrix(rep(x22,m1),n,m1) ### The second component of x1

x2[[1]] = matrix(rep(x11,m2),n,m2)*Ind.V2 + matrix(rep(x12,m2),n,m2)*(1-Ind.V2)
x2[[2]] = matrix(rep(x22,m2),n,m2)

####### initial values ############



eta.hat <- eta.ini

b.ini = rep(0,p)

lambda1.ini = rep(1/n,m1)

lambda2.ini = rep(1/n,m2)

######### we have obtained all initial values so far.

b.hat = b.ini

lambda1.hat = lambda1.ini
lambda2.hat = lambda2.ini
eta.hat = eta.ini


############ judge start ##############

while(diff.theta >= tol && loops < max.loops){

grid <- init.quad(Q  =  1,  prior  =  list(mu  =  0,  Sigma  = 1))

########E-step

Expec.value = 
Expec.fun(b.hat,lambda1.hat,lambda2.hat,eta.hat,x1,x2,Ind.c1,Ind.c2,dG1.fun,dG2.fun,G1.fun, G2.fun)

E.mu1.exp.b = Expec.value$E.mu1.exp.b  ###n by 1
E.mu2.exp.b = Expec.value$E.mu2.exp.b

E.mu1 = E.mu1.exp.b 
E.mu2 = E.mu2.exp.b 

E.b = Expec.value$E.b
E.logb = Expec.value$E.logb


Expx1beta = exp(as.matrix(x1[[1]])*b.hat[1] + as.matrix(x1[[2]])*b.hat[2])
Expx2beta = exp(as.matrix(x2[[1]])*b.hat[1] + as.matrix(x2[[2]])*b.hat[2])

E.z_i1k = matrix(rep(d11,m1),n,m1)*matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
Expec.value$E.z_i1*Ind.c1 + matrix(rep(d12,m1),n,m1)*Ind.d21 +
matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
matrix(rep(E.mu1,m1),n,m1)*(1-Ind.c1) ###n by m1

E.z_i2k = matrix(rep(d21,m2),n,m2)*matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
Expec.value$E.z_i2*Ind.c2+ matrix(rep(d22,m2),n,m2)*Ind.d22 +
matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
matrix(rep(E.mu2,m2),n,m2)*(1-Ind.c2)  ###n by m2


########M-step


#####  beta is 2 by 1
####  k = 1

num1 = rbind(colSums(x1[[1]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta),
colSums(x1[[2]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta)) #### 2 by m1 

denom1 = colSums(matrix(rep(E.mu1,m1),n,m1)*Expx1beta)   #####  1 by m1


####  k = 2

num2 = rbind(colSums(x2[[1]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta),
colSums(x2[[2]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta)) #### 2 by m2 

denom2 = colSums(matrix(rep(E.mu2,m2),n,m2)*Expx2beta)   #####  1 by m2

################################

U.11 = sum(E.z_i1k*x1[[1]]) - sum(colSums(E.z_i1k)*((num1/denom1)[1,]))+
sum(E.z_i2k*x2[[1]]) - sum(colSums(E.z_i2k)*((num2/denom2)[1,]))  ####  the first component

U.12 = sum(E.z_i1k*x1[[2]]) - sum(colSums(E.z_i1k)*((num1/denom1)[2,]))+
sum(E.z_i2k*x2[[2]]) - sum(colSums(E.z_i2k)*((num2/denom2)[2,]))

U.1 = c(U.11,U.12)

################################################################################

I.11 = sum(-colSums(E.z_i1k)*(colSums(x1[[1]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1[[1]])*
denom1 - num1[1,]*num1[1,])/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2[[1]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2[[1]])*
denom2 - num2[1,]*num2[1,])/denom2^2)

I.22 = sum(-colSums(E.z_i1k)*(colSums(x1[[2]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1[[2]])*
denom1 - num1[2,]*num1[2,])/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2[[2]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2[[2]])*
denom2 - num2[2,]*num2[2,])/denom2^2) 

I.12 = sum(-colSums(E.z_i1k)*(colSums(x1[[1]]*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1[[2]])*
denom1 - num1[1,]*num1[2,])/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2[[1]]*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2[[2]])*
denom2 - num2[1,]*num2[2,])/denom2^2)

I.1 = matrix(c(I.11,I.12,I.12,I.22),2,2)



b.est = b.hat - solve(I.1)%*%(U.1)
if(any(is.na(b.est))) b.est = beta0

Expx1beta = exp(as.matrix(x1[[1]])*b.est[1] + as.matrix(x1[[2]])*b.est[2])
Expx2beta = exp(as.matrix(x2[[1]])*b.est[1] + as.matrix(x2[[2]])*b.est[2])


##### lambda_1 and lambda_2

lambda1.est = apply(E.z_i1k,2,sum)/apply(matrix(rep(E.mu1,m1),n,m1)*Expx1beta,2,sum)
if(any(is.na(lambda1.est))) lambda1.est = lambda1.ini

lambda2.est = apply(E.z_i2k,2,sum)/apply(matrix(rep(E.mu2,m2),n,m2)*Expx2beta,2,sum)
if(any(is.na(lambda2.est))) lambda2.est = lambda2.ini



#####obtain the estimator of eta#####################

v.hat = log(eta.hat^(-1))

U.v = n*(exp(v.hat)+v.hat*exp(v.hat)) + exp(v.hat)*sum(E.logb-E.b) - n*digamma(exp(v.hat))*exp(v.hat)

I.v = n*(2*exp(v.hat)+v.hat*exp(v.hat)) + exp(v.hat)*sum(E.logb-E.b) -
      n*(trigamma(exp(v.hat))*exp(v.hat)+digamma(exp(v.hat)))*exp(v.hat)
v.est = v.hat - solve(I.v)*U.v

if(any(is.na(v.est))) v.est = log(eta.ini^(-1))

eta.est = as.vector(exp(-v.est))

diff.eta = eta.est - eta.hat

diff.beta = b.est - b.hat

diff.lambda1 = lambda1.est - lambda1.hat
diff.lambda2 = lambda2.est - lambda2.hat

diff.theta = max(abs(diff.beta),abs(diff.lambda1), abs(diff.lambda2),abs(diff.eta)) 

b.hat = b.est

lambda1.hat = lambda1.est
lambda2.hat = lambda2.est
eta.hat = eta.est

loops = loops+1


}

######### judge end #########

return( c(b.hat,eta.hat) )

}


sd = apply(xxx,1,sd)
sd.b = sd[1:p]
sd.eta = sd[(p+1)]


##############################################

##############################################

std.b[r,] = sd.b
std.eta[r] = sd.eta

}


stopCluster(ccl)

biasb <- apply(beta1,2,mean)-beta0
se.b <- apply(beta1,2,sd)
c1b<-apply(beta1,2,mean)-1.96*se.b
c2b<-apply(beta1,2,mean)+1.96*se.b
cphb<-apply((beta1>=matrix(rep(c1b,each=mm),mm,2))&(beta1<=matrix(rep(c2b,each=mm),mm,2)),2,mean)
see.b <- apply(std.b,2,mean)



bias.eta<-mean(eta1)-eta0
se.eta <- sd(eta1)
c1e<-mean(eta1)-1.96*se.eta
c2e<-mean(eta1)+1.96*se.eta
cphe<-mean((eta1>=c1e)&(eta1<=c2e))

see.eta <- mean(std.eta)


print(c('r1=',r1))
print(c('r2=',r2))
print(c('n=',n))

print(c('b=',beta0))
print(c('biasb=',biasb))
print(c('se.b=',se.b))
print(c('see.b=',see.b))
print(c('cp.beta=',cphb))


print(c('bias.eta=',bias.eta))
print(c('se.eta=',se.eta))
print(c('see.eta=',see.eta))
print(c('cp.eta=',cphe))



time2 = date()

print(rbind(time1,time2))

