
#####  gamma frailty


setwd("D:/wd")

r1 = 0
r2 = 0

n.cores = 4

n.bs = 100

max.loops = 500

##### load necessary function

loglik.b_n <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2){

Expx1betab = exp(as.matrix(x1)*matrix(beta,n,m1)+b)#### k = 1
Expx2betab = exp(as.matrix(x2)*matrix(beta,n,m2)+b)#### k = 2

L1 = matrix(rep(lambda1, each=n), n, m1)*Expx1betab 
#### n by m1

L2 = matrix(rep(lambda2, each=n), n, m2)*Expx2betab  
#### n by m2

s1 = rep(0,n)
s2 = rep(0,n)

s1 = exp(-G1(rowSums(L1*Ind.c1)))
s2 = exp(-G2(rowSums(L2*Ind.c2)))

f1 = rowSums(matrix(rep(lambda1, each=n),n, m1)*Expx1betab*Ind.d21)*dG1(rowSums(L1*Ind.c1))*s1
f2 = rowSums(matrix(rep(lambda2, each=n),n, m2)*Expx2betab*Ind.d22)*dG2(rowSums(L2*Ind.c2))*s2

f1[f1<=0] = 10
f2[f2<=0] = 10

results = d11*log(((1-s1)<=0)*10^(-3)+((1-s1)>0)*(1-s1)) + 
d12*log(f1) + d13*log(s1) +
d21*log(((1-s2)<=0)*10^(-3)+((1-s2)>0)*(1-s2)) + 
d22*log(f2) + d23*log(s2)

return(results) ## n by 1

}


E.Z1.b.d <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2){

Expx1betab = exp(as.matrix(x1)*matrix(beta,n,m1)+b) #### k = 1

L1 = matrix(rep(lambda1, each=n), n, m1)*Expx1betab

W1 = rep(0,n)
W1 = rowSums(L1*Ind.c1)

results = d11*exp(b)*(1-exp(-G1(W1)))^(-1)

return(results)

### n by 1
}

E.Z2.b.d <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2){  #### k = 2

Expx2betab = exp(as.matrix(x2)*matrix(beta,n,m2)+b)

L2 = matrix(rep(lambda2, each=n), n, m2)*Expx2betab
#### n by m2

W2 = rep(0,n)

W2 = rowSums(L2*Ind.c2)

results = d21*exp(b)*(1-exp(-G2(W2)))^(-1)

return(results)
### n by 1



}


E.mu1.b <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2){ #### k = 1

Expx1betab = exp(as.matrix(x1)*matrix(beta,n,m1)+b)

L1 = matrix(rep(lambda1, each=n),n,m1)*Expx1betab
#### n by m1

W1 = rep(0,n)

W1 = rowSums(L1*Ind.c1)

if(r1>0){

results = exp(b)*(d11*(1-(r1*W1+1)^(-r1^(-1)-1))/(1-exp(-G1(W1)))+d12*(1+r1)/(r1*W1+1)+
d13*(r1*W1+1)^(-r1^(-1)-1)/exp(-G1(W1)))

} else results = exp(b)

return(results)### n by 1

}


E.mu2.b <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2){

Expx2betab = exp(as.matrix(x2)*matrix(beta,n,m2)+b)

L2 = matrix(rep(lambda2, each=n), n, m2)*Expx2betab
#### n by m2

W2 = rep(0,n)

W2 = rowSums(L2*Ind.c2)

if(r2>0){

results = exp(b)*(d21*(1-(r2*W2+1)^(-r2^(-1)-1))/(1-exp(-G2(W2)))+d22*(1+r2)/(r2*W2+1)+
d23*(r2*W2+1)^(-r2^(-1)-1)/exp(-G2(W2)))

} else results = exp(b)

return(results)### n by 1

}



########### sigma

E.b.fun <- function(b,beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1,G2){

results = b^2

return(results)##### n by 1

}





Expec.fun<-function(beta, lambda1, lambda2, sigma, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1, G2){


E.mu1.exp.b = eval.h(loglik.b_n, E.mu1.b, grid, X = NULL, W = NULL,beta, lambda1, lambda2, sigma, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

E.mu2.exp.b = eval.h(loglik.b_n, E.mu2.b, grid, X = NULL, W = NULL,beta, lambda1, lambda2, sigma, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)

E.z_i1 = eval.h(loglik.b_n, E.Z1.b.d, grid, X = NULL, W = NULL,beta, lambda1, lambda2, sigma, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

E.z_i2 = eval.h(loglik.b_n, E.Z2.b.d, grid, X = NULL, W = NULL,beta, lambda1, lambda2, sigma, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 2

E.b = eval.h(loglik.b_n, E.b.fun, grid, X = NULL, W = NULL,beta, lambda1, lambda2, sigma, x1,x2, Ind.c1, Ind.c2,dG1,dG2,G1,G2)###n by 1

return(list(E.mu1.exp.b = E.mu1.exp.b, E.mu2.exp.b = E.mu2.exp.b, 
E.z_i1 = E.z_i1, E.z_i2 = E.z_i2, E.b = E.b))

}



#################################################################
G1.fun <- function(u){#### 
      if(r1 > 0){
      results = log(((1+r1*u)<=0)*10^(-3)+(1+r1*u>0)*(1+r1*u))/r1
      } else results = u
      return(results)
}


G1.inv <- function(u){
   if (r1 > 0) {
      results = (exp(u*r1)-1)/r1
      } else results = u
      return(results)
}

G2.fun <- function(u){#### 
      if(r2 > 0){ 
      results = log(((1+r2*u)<=0)*10^(-3)+(1+r2*u>0)*(1+r2*u))/r2
      } else results = u
      return(results)
}


G2.inv <- function(u){
      if(r2 > 0){ 
      results = (exp(u*r2)-1)/r2
      } else results = u
      return(results)
}


dG1.fun <- function(u){#### 
      if(r1 > 0){
      results = 1/(1+r1*u)
      } else results = 1
      return(results)
}


dG2.fun <- function(u){#### 
      if(r2 > 0){
      results = 1/(1+r2*u)
      } else results = 1
      return(results)
}



##############################################################






####exp(W) weight function  
###FUN=loglik.b_n
###(b,beta.hat,lambda1.hat,lambda2.hat,z,Ind.c1,Ind.c2,G1.fun,G2.fun)  
###X=grid.

eval.h <- function (FUN,h.fun,grid,X = NULL,W = NULL,beta,lambda1,lambda2,sigma,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1.fun,G2.fun) 
{
    grid <- init.quad(Q  =  1,  prior  =  list(mu  =  0,  Sigma  =  sigma^2),ip=10)

    if (is.list(grid)) {
        W <- grid$W
        X <- grid$X
    }
    if (is.null(X) | is.null(W)) 
        stop("Quadrature points and weights are required. See init.gauss.", 
            call. = F)
    FUN <- match.fun(FUN)
    h.fun <- match.fun(h.fun)
    Q <- ncol(X)
    ipq <- length(W)
    f <- matrix(1,n,ipq)
    h <- matrix(1,n,ipq)
 
    for (i in 1:ipq) {  
f[,i] <- FUN(X[i],beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1.fun,G2.fun)+
W[i]
    }

    for (i in 1:ipq) {
h[,i] <- h.fun(X[i],beta,lambda1,lambda2,x1,x2,Ind.c1,Ind.c2,dG1,dG2,G1.fun,G2.fun)
    }
    m <- 700 - max(f)
    f <- f + m
    f <- exp(f)
    p1 <- rowSums(f)
    estimate <- rowSums(f * h)/p1 #### dim(estimate) = n by 1
    return(estimate)
}

##########################################################################

time1= date()

library(MultiGHQuad)

library(survival)

library(pracma)

library(doParallel)

library(doRNG)

ccl <- makeCluster(n.cores)

registerDoParallel(ccl)

###################################################################

loops = 0

diff.theta = 100

tol = 0.001

setwd("D:/wd")

data <- read.table("SM18-AK242_data1.txt")


rna <- data[,1]

cd4 <- data[,2]

x11 <- data[,3]

L <- data[,4]

R <-data[,5]

n <- length(rna)

p =1

data.boot =  cbind(rna, L, R,cd4,x11) ##### for bootstrap

####  covariate group indicator

d11 = rep(0,n)
d12 = rep(1,n)
d13 = rep(0,n)

d21 = as.numeric(rna < L)
d22 = as.numeric(rna >= L)*as.numeric(rna <= R)
d23 = as.numeric(rna > R)

tt1 = cd4

tt2 = pmax(L, pmin(R,rna))

##tt1 and tt2 are  times for analysis


V <- rep(10^5,n)

c11 = tt1*(1-d13)
c1 = c11[c11!=0]

c22 = tt2*(1-d23)
c2 = c22[c22!=0]


order.c1 <- sort(unique(c1))

order.c2 <- sort(unique(c2))

m1 = length(order.c1)

m2 = length(order.c2)

Ind.c1 = matrix(rep(order.c1,each=n), n, m1) <= matrix(rep(tt1,m1), n, m1)

Ind.c2 = matrix(rep(order.c2,each=n), n, m2) <= matrix(rep(tt2,m2), n, m2)

Ind.d21 = matrix(rep(order.c1,each=n), n, m1) == matrix(rep(tt1,m1), n, m1)

Ind.d22 = matrix(rep(order.c2,each=n), n, m2) == matrix(rep(tt2,m2), n, m2)

Ind.V1 = matrix(rep(order.c1,each =n),n,m1) <= matrix(rep(V,m1),n,m1)
Ind.V2 = matrix(rep(order.c2,each =n),n,m2) <= matrix(rep(V,m2),n,m2)

#####covariates for the two events

x1= matrix(rep(x11,m1),n,m1)

x2 = matrix(rep(x11,m2),n,m2)

####### initial values ############


Sigma.ini = 0.5

b.ini = rep(-1,p)

lambda1.ini = rep(1/n,m1)

lambda2.ini = rep(1/n,m2)

######### we have obtained all initial values so far.

b.hat = b.ini

lambda1.hat = lambda1.ini
lambda2.hat = lambda2.ini
Sigma.hat = Sigma.ini


############ judge start ##############

while(diff.theta >= tol && loops < max.loops){

########E-step

Expec.value = 
Expec.fun(b.hat,lambda1.hat,lambda2.hat,Sigma.hat,x1,x2,Ind.c1,Ind.c2,dG1.fun,dG2.fun,G1.fun, G2.fun)

E.mu1.exp.b = Expec.value$E.mu1.exp.b  ###n by 1
E.mu2.exp.b = Expec.value$E.mu2.exp.b


E.mu1 = E.mu1.exp.b
E.mu2 = E.mu2.exp.b 


Expx1beta = exp(as.matrix(x1)*matrix(b.hat,n,m1))
Expx2beta = exp(as.matrix(x2)*matrix(b.hat,n,m2))

E.z_i1k = matrix(rep(d11,m1),n,m1)*matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
Expec.value$E.z_i1*Ind.c1 + matrix(rep(d12,m1),n,m1)*Ind.d21 +
matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
matrix(rep(E.mu1,m1),n,m1)*(1-Ind.c1) ###n by m1

E.z_i2k = matrix(rep(d21,m2),n,m2)*matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
Expec.value$E.z_i2*Ind.c2+ matrix(rep(d22,m2),n,m2)*Ind.d22 +
matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
matrix(rep(E.mu2,m2),n,m2)*(1-Ind.c2)  ###n by m2


########M-step

####  k = 1

num1 = colSums(x1*matrix(rep(E.mu1,m1),n,m1)*Expx1beta) #### 1 by m1 

denom1 = colSums(matrix(rep(E.mu1,m1),n,m1)*Expx1beta)   #####  1 by m1

####  k = 2

num2 = colSums(x2*matrix(rep(E.mu2,m2),n,m2)*Expx2beta) #### 1 by m2 

denom2 = colSums(matrix(rep(E.mu2,m2),n,m2)*Expx2beta)   #####  1 by m2

################################

U.1 = sum(E.z_i1k*x1) - sum(colSums(E.z_i1k)*((num1/denom1)))+
sum(E.z_i2k*x2) - sum(colSums(E.z_i2k)*((num2/denom2)))  

################################################################################

I.1 = sum(-colSums(E.z_i1k)*(colSums(x1*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1)*
denom1 - num1*num1)/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2)*
denom2 - num2*num2)/denom2^2)

b.est = b.hat - solve(I.1)*(U.1)


Expx1beta = exp(as.matrix(x1)*matrix(b.est,n,m1))
Expx2beta = exp(as.matrix(x2)*matrix(b.est,n,m2))

##### lambda_1 and lambda_2

lambda1.est = apply(E.z_i1k,2,sum)/apply(matrix(rep(E.mu1,m1),n,m1)*Expx1beta,2,sum)


lambda2.est = apply(E.z_i2k,2,sum)/apply(matrix(rep(E.mu2,m2),n,m2)*Expx2beta,2,sum)


Sigma11 <- Expec.value$E.b

#####Sigma11.est = mean(na.omit(Sigma11))

Sigma11[is.nan(Sigma11)]=Sigma.hat

Sigma.est = sqrt(mean(Sigma11))
if(any(is.na(Sigma.est))) Sigma.est = Sigma0


diff.Sigma = Sigma.est - Sigma.hat

diff.beta = b.est - b.hat

diff.lambda1 = lambda1.est - lambda1.hat
diff.lambda2 = lambda2.est - lambda2.hat

diff.theta = max(abs(diff.beta),abs(diff.Sigma)) 

b.hat = b.est

lambda1.hat = lambda1.est
lambda2.hat = lambda2.est
Sigma.hat = Sigma.est

loops = loops+1

}

######### judge end #########

beta.hat = b.hat

S.hat = Sigma.hat

lam1.hat = lambda1.hat

lam2.hat = lambda2.hat

xx1 = x1

xx2 = x2

###########  variance 

##### data.boot

xxx <- foreach(bs = 1:n.bs, .combine = cbind, 
.packages = c("MultiGHQuad","survival","pracma",
"doRNG")) %dorng%{

diff.theta  = 100
loops = 0

my.data<-data.boot[sample(1:dim(data.boot)[1], size=n,replace=TRUE),]

rna = my.data[ ,"rna"]
L = my.data[ ,"L"]
R = my.data[ ,"R"]
cd4 = my.data[ ,"cd4"]
x11 = my.data[ ,"x11"]

####  covariate group indicator

d11 = rep(0,n)
d12 = rep(1,n)
d13 = rep(0,n)

d21 = as.numeric(rna < L)
d22 = as.numeric(rna >= L)*as.numeric(rna <= R)
d23 = as.numeric(rna > R)

tt1 = cd4

tt2 = pmax(L, pmin(R,rna))

##tt1 and tt2 are  times for analysis


V <- rep(10^5,n)

c11 = tt1*(1-d13)
c1 = c11[c11!=0]

c22 = tt2*(1-d23)
c2 = c22[c22!=0]


order.c1 <- sort(unique(c1))

order.c2 <- sort(unique(c2))

m1 = length(order.c1)

m2 = length(order.c2)

Ind.c1 = matrix(rep(order.c1,each=n), n, m1) <= matrix(rep(tt1,m1), n, m1)

Ind.c2 = matrix(rep(order.c2,each=n), n, m2) <= matrix(rep(tt2,m2), n, m2)

Ind.d21 = matrix(rep(order.c1,each=n), n, m1) == matrix(rep(tt1,m1), n, m1)

Ind.d22 = matrix(rep(order.c2,each=n), n, m2) == matrix(rep(tt2,m2), n, m2)

Ind.V1 = matrix(rep(order.c1,each =n),n,m1) <= matrix(rep(V,m1),n,m1)
Ind.V2 = matrix(rep(order.c2,each =n),n,m2) <= matrix(rep(V,m2),n,m2)

#####covariates for the two events

x1= matrix(rep(x11,m1),n,m1)

x2 = matrix(rep(x11,m2),n,m2)

####### initial values ############

Sigma.ini = 0.5

b.ini = rep(-1,p)

lambda1.ini = rep(1/n,m1)

lambda2.ini = rep(1/n,m2)

######### we have obtained all initial values so far.

b.hat = b.ini

lambda1.hat = lambda1.ini
lambda2.hat = lambda2.ini
Sigma.hat = Sigma.ini


############ judge start ##############

while(diff.theta >= tol && loops < max.loops){

########E-step

Expec.value = 
Expec.fun(b.hat,lambda1.hat,lambda2.hat,Sigma.hat,x1,x2,Ind.c1,Ind.c2,dG1.fun,dG2.fun,G1.fun, G2.fun)

E.mu1.exp.b = Expec.value$E.mu1.exp.b  ###n by 1
E.mu2.exp.b = Expec.value$E.mu2.exp.b


E.mu1 = E.mu1.exp.b
E.mu2 = E.mu2.exp.b 


Expx1beta = exp(as.matrix(x1)*matrix(b.hat,n,m1))
Expx2beta = exp(as.matrix(x2)*matrix(b.hat,n,m2))

E.z_i1k = matrix(rep(d11,m1),n,m1)*matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
Expec.value$E.z_i1*Ind.c1 + matrix(rep(d12,m1),n,m1)*Ind.d21 +
matrix(rep(lambda1.hat, each=n),n,m1)*Expx1beta*
matrix(rep(E.mu1,m1),n,m1)*(1-Ind.c1) ###n by m1

E.z_i2k = matrix(rep(d21,m2),n,m2)*matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
Expec.value$E.z_i2*Ind.c2+ matrix(rep(d22,m2),n,m2)*Ind.d22 +
matrix(rep(lambda2.hat, each=n),n,m2)*Expx2beta*
matrix(rep(E.mu2,m2),n,m2)*(1-Ind.c2)  ###n by m2


########M-step

####  k = 1

num1 = colSums(x1*matrix(rep(E.mu1,m1),n,m1)*Expx1beta) #### 1 by m1 

denom1 = colSums(matrix(rep(E.mu1,m1),n,m1)*Expx1beta)   #####  1 by m1

####  k = 2

num2 = colSums(x2*matrix(rep(E.mu2,m2),n,m2)*Expx2beta) #### 1 by m2 

denom2 = colSums(matrix(rep(E.mu2,m2),n,m2)*Expx2beta)   #####  1 by m2

################################

U.1 = sum(E.z_i1k*x1) - sum(colSums(E.z_i1k)*((num1/denom1)))+
sum(E.z_i2k*x2) - sum(colSums(E.z_i2k)*((num2/denom2)))  

################################################################################

I.1 = sum(-colSums(E.z_i1k)*(colSums(x1*matrix(rep(E.mu1,m1),n,m1)*Expx1beta*x1)*
denom1 - num1*num1)/denom1^2) +
sum(-colSums(E.z_i2k)*(colSums(x2*matrix(rep(E.mu2,m2),n,m2)*Expx2beta*x2)*
denom2 - num2*num2)/denom2^2)

b.est = b.hat - solve(I.1)*(U.1)


Expx1beta = exp(as.matrix(x1)*matrix(b.est,n,m1))
Expx2beta = exp(as.matrix(x2)*matrix(b.est,n,m2))

##### lambda_1 and lambda_2

lambda1.est = apply(E.z_i1k,2,sum)/apply(matrix(rep(E.mu1,m1),n,m1)*Expx1beta,2,sum)


lambda2.est = apply(E.z_i2k,2,sum)/apply(matrix(rep(E.mu2,m2),n,m2)*Expx2beta,2,sum)


Sigma11 <- Expec.value$E.b

#####Sigma11.est = mean(na.omit(Sigma11))

Sigma11[is.nan(Sigma11)]=Sigma.hat

Sigma.est = sqrt(mean(Sigma11))
if(any(is.na(Sigma.est))) Sigma.est = Sigma0


diff.Sigma = Sigma.est - Sigma.hat

diff.beta = b.est - b.hat

diff.lambda1 = lambda1.est - lambda1.hat
diff.lambda2 = lambda2.est - lambda2.hat

diff.theta = max(abs(diff.beta),abs(diff.Sigma)) 

b.hat = b.est

lambda1.hat = lambda1.est
lambda2.hat = lambda2.est
Sigma.hat = Sigma.est

loops = loops+1

}

######### judge end #########

return( c(b.hat,Sigma.hat) )

}


sd = apply(xxx,1,sd)
sd.b = sd[1:p]
sd.Sigma = sd[(p+1)]

p.value = 2*(1 - pnorm(abs(beta.hat), 0, sd.b))

p.Sigma = 2*(1 - pnorm(abs(Sigma.hat), 0, sd.Sigma))

################################################

cat("r1=", r1,"\n",
    "r2=", r2,"\n",
    "loops=", loops,"\n",
    "b.est=", beta.hat, "\n",
    "sd.b=",sd.b,"\n",
     "p=",p.value,"\n",
     "Sigma.est=",S.hat,"\n",
         "sd.Sigma=",sd.Sigma,"\n",
      "p=",p.Sigma,"\n") 

time2 = date()

print(rbind(time1,time2))

stopCluster(ccl)







