library("MASS")
library("msm")
library("MCMCpack")
library("condMVNorm")
library("mvtnorm")
library("cSFM")
data=read.csv("sample_data.csv")    #data location
y_s=data$y
#Covariate Imputation
#Age calculation
for(i in 2:15432){
  if(data$w[i]!=1)
    data$A[i]=data$A[i-1]+2
}
#BMI Imputation
s1=0;s2=0;s3=0;s4=0;s5=0
c1=numeric(15432);c2=numeric(15432);c3=numeric(15432);c4=numeric(15432);c5=numeric(15432)
sum(is.na(data$A))
for(i in 1:15432){
  if(data$A[i]<=54)
  {s1=s1+1
  c1[i]=i}
  if(data$A[i]>=55 && data$A[i]<=59)
  {s2=s2+1
  c2[i]=i}
  if(data$A[i]>=60 && data$A[i]<=64)
  {s3=s3+1
  c3[i]=i}
  if(data$A[i]>=65 && data$A[i]<=69)
  {s4=s4+1
  c4[i]=i}
  if(data$A[i]>=70)
  {s5=s5+1
  c5[i]=i}
}
s1;s2;s3;s4;s5  #No. of persons in a particular age group
m1=mean(data$O1[c1],na.rm=T);s01=sd(data$O1[c1],na.rm=T)
m2=mean(data$O1[c1],na.rm=T);s02=sd(data$O1[c2],na.rm=T)
m3=mean(data$O1[c3],na.rm=T);s03=sd(data$O1[c3],na.rm=T)
m4=mean(data$O1[c4],na.rm=T);s04=sd(data$O1[c4],na.rm=T)
m5=mean(data$O1[c5],na.rm=T);s05=sd(data$O1[c5],na.rm=T)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O1)[i]==1)
    data$O1[i]=rnorm(1,m1,s01)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O1)[i]==1)
    data$O1[i]=rnorm(1,m2,s02)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O1)[i]==1)
    data$O1[i]=rnorm(1,m3,s03)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O1)[i]==1)
    data$O1[i]=rnorm(1,m4,s04)
  if(data$A[i]>=70 && is.na(data$O1)[i]==1)
    data$O1[i]=rnorm(1,m2,s02)
}
#Disease status imputation
f03=function(c)
  return(mean(data$O3[c]==0,na.rm = T))
r031=f03(c1);r032=f03(c2);r033=f03(c3);r034=f03(c4);r035=f03(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O3)[i]==1)
    data$O3[i]=rbinom(1,1,1-r031)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O3)[i]==1)
    data$O3[i]=rbinom(1,1,1-r032)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O3)[i]==1)
    data$O3[i]=rbinom(1,1,1-r033)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O3)[i]==1)
    data$O3[i]=rbinom(1,1,1-r034)
  if(data$A[i]>=70 && is.na(data$O3)[i]==1)
    data$O3[i]=rbinom(1,1,1-r035)
}
f04=function(c)
  return(mean(data$O4[c]==0,na.rm = T))
r041=f04(c1);r042=f04(c2);r043=f04(c3);r044=f04(c4);r045=f04(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O4)[i]==1)
    data$O4[i]=rbinom(1,1,1-r041)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O4)[i]==1)
    data$O4[i]=rbinom(1,1,1-r042)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O4)[i]==1)
    data$O4[i]=rbinom(1,1,1-r043)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O4)[i]==1)
    data$O4[i]=rbinom(1,1,1-r044)
  if(data$A[i]>=70 && is.na(data$O4)[i]==1)
    data$O4[i]=rbinom(1,1,1-r045)
}
f05=function(c)
  return(mean(data$O5[c]==0,na.rm = T))
r051=f05(c1);r052=f05(c2);r053=f05(c3);r054=f05(c4);r055=f05(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O5)[i]==1)
    data$O5[i]=rbinom(1,1,1-r051)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O5)[i]==1)
    data$O5[i]=rbinom(1,1,1-r052)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O5)[i]==1)
    data$O5[i]=rbinom(1,1,1-r053)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O5)[i]==1)
    data$O5[i]=rbinom(1,1,1-r054)
  if(data$A[i]>=70 && is.na(data$O5)[i]==1)
    data$O5[i]=rbinom(1,1,1-r055)
}
f06=function(c)
  return(mean(data$O6[c]==0,na.rm = T))
r061=f06(c1);r062=f06(c2);r063=f06(c3);r064=f06(c4);r065=f06(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O6)[i]==1)
    data$O6[i]=rbinom(1,1,1-r061)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O6)[i]==1)
    data$O6[i]=rbinom(1,1,1-r062)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O6)[i]==1)
    data$O6[i]=rbinom(1,1,1-r063)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O6)[i]==1)
    data$O6[i]=rbinom(1,1,1-r064)
  if(data$A[i]>=70 && is.na(data$O6)[i]==1)
    data$O6[i]=rbinom(1,1,1-r065)
}
f07=function(c)
  return(mean(data$O7[c]==0,na.rm = T))
r071=f07(c1);r072=f07(c2);r073=f07(c3);r074=f07(c4);r075=f07(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O7)[i]==1)
    data$O7[i]=rbinom(1,1,1-r071)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O7)[i]==1)
    data$O7[i]=rbinom(1,1,1-r072)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O7)[i]==1)
    data$O7[i]=rbinom(1,1,1-r073)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O7)[i]==1)
    data$O7[i]=rbinom(1,1,1-r074)
  if(data$A[i]>=70 && is.na(data$O7)[i]==1)
    data$O7[i]=rbinom(1,1,1-r075)
}
f08=function(c)
  return(mean(data$O8[c]==0,na.rm = T))
r081=f08(c1);r082=f08(c2);r083=f08(c3);r084=f08(c4);r085=f08(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O8)[i]==1)
    data$O8[i]=rbinom(1,1,1-r081)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O8)[i]==1)
    data$O8[i]=rbinom(1,1,1-r082)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O8)[i]==1)
    data$O8[i]=rbinom(1,1,1-r083)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O8)[i]==1)
    data$O8[i]=rbinom(1,1,1-r084)
  if(data$A[i]>=70 && is.na(data$O8)[i]==1)
    data$O8[i]=rbinom(1,1,1-r085)
}
f09=function(c)
  return(mean(data$O9[c]==0,na.rm = T))
r091=f09(c1);r092=f09(c2);r093=f09(c3);r094=f09(c4);r095=f09(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O9)[i]==1)
    data$O9[i]=rbinom(1,1,1-r091)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O9)[i]==1)
    data$O9[i]=rbinom(1,1,1-r092)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O9)[i]==1)
    data$O9[i]=rbinom(1,1,1-r093)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O9)[i]==1)
    data$O9[i]=rbinom(1,1,1-r094)
  if(data$A[i]>=70 && is.na(data$O9)[i]==1)
    data$O9[i]=rbinom(1,1,1-r095)
}
f010=function(c)
  return(mean(data$O10[c]==0,na.rm = T))
r0101=f010(c1);r0102=f010(c2);r0103=f010(c3);r0104=f010(c4);r0105=f010(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$O10)[i]==1)
    data$O10[i]=rbinom(1,1,1-r0101)
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$O10)[i]==1)
    data$O10[i]=rbinom(1,1,1-r0102)
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$O10)[i]==1)
    data$O10[i]=rbinom(1,1,1-r0103)
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$O10)[i]==1)
    data$O10[i]=rbinom(1,1,1-r0104)
  if(data$A[i]>=70 && is.na(data$O10)[i]==1)
    data$O10[i]=rbinom(1,1,1-r0105)
}
#Insurance Group Imputation
fi1=function(c)
  return(mean(data$I1[c]==1,na.rm = T))
fi2=function(c)
  return(mean(data$I2[c]==1,na.rm = T))
fi3=function(c)
  return(mean(data$I3[c]==1,na.rm = T))
fi4=function(c)
  return(mean(data$I4[c]==1,na.rm = T))
r11=fi1(c1);r12=fi1(c2);r13=fi1(c3);r14=fi1(c4);r15=fi1(c5)
r21=fi2(c1);r22=fi2(c2);r23=fi2(c3);r24=fi2(c4);r25=fi2(c5)
r31=fi3(c1);r32=fi3(c2);r33=fi3(c3);r34=fi3(c4);r35=fi3(c5)
r41=fi4(c1);r42=fi4(c2);r43=fi4(c3);r44=fi4(c4);r45=fi4(c5)
for(i in 1:15432){
  if(data$A[i]<=54 && is.na(data$I1)[i]==1)
  {b=integer(4)
  b[sample(1:4,1,replace = T,prob = c(r11,r21,r31,r41))]=1
  data$I1[i]=b[1];data$I2[i]=b[2];data$I3[i]=b[3];data$I4[i]=b[4]}
  if(data$A[i]>=55 && data$A[i]<=59 && is.na(data$I1)[i]==1)
  {b=integer(4)
  b[sample(1:4,1,replace = T,prob = c(r12,r22,r32,r42))]=1
  data$I1[i]=b[1];data$I2[i]=b[2];data$I3[i]=b[3];data$I4[i]=b[4]}
  if(data$A[i]>=60 && data$A[i]<=64 && is.na(data$I1)[i]==1)
  {b=integer(4)
  b[sample(1:4,1,replace = T,prob = c(r13,r23,r33,r43))]=1
  data$I1[i]=b[1];data$I2[i]=b[2];data$I3[i]=b[3];data$I4[i]=b[4]}
  if(data$A[i]>=65 && data$A[i]<=69 && is.na(data$I1)[i]==1)
  {b=integer(4)
  b[sample(1:4,1,replace = T,prob = c(r14,r24,r34,r44))]=1
  data$I1[i]=b[1];data$I2[i]=b[2];data$I3[i]=b[3];data$I4[i]=b[4]}
  if(data$A[i]>=70 && is.na(data$I1)[i]==1)
  {b=integer(4)
  b[sample(1:4,1,replace = T,prob = c(r15,r25,r35,r45))]=1
  data$I1[i]=b[1];data$I2[i]=b[2];data$I3[i]=b[3];data$I4[i]=b[4]}
}
#Incomplete data analysis (Excluding Missing value)
le=100  ; d=seq(50,le,10)
#basic parameters of 1st model
r0=3  # 2nd degree legendre polynomial
mu_eta=rep(0,5*length(r0));sigma_eta=1
mu_beta=rep(0,8);sigma_beta=1
#basic parameters of 2nd model
r1=2  #1st degree legendre polynomial
mu_eta1=rep(0,5*length(r1));sigma_eta1=1
mu_delta=rep(0,8);sigma_delta=1
alpha_e=1;beta_e=3
#Some basic parameters for different waves
eta=matrix(0,5*r0,8)  ; eta1=matrix(0,5*r1,8)
beta=matrix(0,8,8)    ; delta=matrix(0,8,8)
sig_e=numeric(8)      ; sig_bc=numeric(8)
sig_b=numeric(8)      ; sig_c=numeric(8)
#1st and 2nd dynamic model estimating parameters upto 8th wave
kproduct=function(x,y){
  lx=length(x);ly=length(y)
  M=matrix(0,ly,lx)
  for(i in 1:lx)
    M[,i]=x[i]*y
  return(c(M))
}
f1=function(t,k){  #t is time point and k is the degree of legendre polynomials
  x=rep(NA,k)
  for(i in 1:k)
    x[i]=legendre.polynomials((t-1)/7,i-1,F)
  return(x)
} # it returns a legendre polynomial vectors
f2=function(m,n){
  return(c(A[m,n],B[m,n],I2[m,n],I3[m,n],I4[m,n]))
}
f3=function(m,n){
  return(c(O3[m,n],O4[m,n],O5[m,n],O6[m,n],O7[m,n],O8[m,n],O9[m,n],O10[m,n]))
}
Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==8 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 && is.na(data$y)[i-2]!=1 &&
     is.na(data$y)[i-3]!=1 && is.na(data$y)[i-4]!=1 && is.na(data$y)[i-5]!=1 && is.na(data$y)[i-6]!=1 
     && is.na(data$y)[i-7]!=1){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1];Y1[i-2]=data$y[i-2];Y1[i-3]=data$y[i-3]
    Y1[i-4]=data$y[i-4];Y1[i-5]=data$y[i-5];Y1[i-6]=data$y[i-6];Y1[i-7]=data$y[i-7]
    q[i]=i;q[i-1]=i-1;q[i-2]=i-2;q[i-3]=i-3
    q[i-4]=i-4;q[i-5]=i-5;q[i-6]=i-6;q[i-7]=i-7
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,8,length(Y1)/8); Y=matrix(Y1,8,length(Y1)/8)
A=matrix(data$A[q],8,length(Y1)/8);B=matrix(data$O1[q],8,length(Y1)/8)
I2=matrix(data$I2[q],8,length(Y1)/8);I3=matrix(data$I3[q],8,length(Y1)/8)
I4=matrix(data$I4[q],8,length(Y1)/8)   #set of time varying covariates
O3=matrix(data$O3[q],8,length(Y1)/8);O4=matrix(data$O4[q],8,length(Y1)/8)
O5=matrix(data$O5[q],8,length(Y1)/8);O6=matrix(data$O6[q],8,length(Y1)/8)
O7=matrix(data$O7[q],8,length(Y1)/8);O8=matrix(data$O8[q],8,length(Y1)/8)
O9=matrix(data$O9[q],8,length(Y1)/8);O10=matrix(data$O10[q],8,length(Y1)/8)
Tm=matrix(data$w[q],8,length(Y1)/8)
for(i in 1:(length(Y1)/8)){
  for(j in 1:8){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/8)
for(i in 1:(length(Y1)/8))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,8,length(Y1)/8)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/8)){
    s3=0 ; s03=0
    for(j in 1:8){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(8+InvS[1,1]),sqrt((8+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/8)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,8]=rowMeans(meta[,d])  ; beta[,8]=rowMeans(mbeta[,d])
eta1[,8]=rowMeans(meta1[,d]); delta[,8]=rowMeans(mdelta[,d])
sig_e[8]=mean(s_e[d])       ; sig_bc[8]=mean(g12[d])
sig_b[8]=mean(g1[d])        ; sig_c[8]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 7th wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==7 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 && is.na(data$y)[i-2]!=1 &&
     is.na(data$y)[i-3]!=1 && is.na(data$y)[i-4]!=1 && is.na(data$y)[i-5]!=1 && is.na(data$y)[i-6]!=1 ){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1];Y1[i-2]=data$y[i-2];Y1[i-3]=data$y[i-3]
    Y1[i-4]=data$y[i-4];Y1[i-5]=data$y[i-5];Y1[i-6]=data$y[i-6]
    q[i]=i;q[i-1]=i-1;q[i-2]=i-2;q[i-3]=i-3
    q[i-4]=i-4;q[i-5]=i-5;q[i-6]=i-6
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,7,length(Y1)/7); Y=matrix(Y1,7,length(Y1)/7)
A=matrix(data$A[q],7,length(Y1)/7);B=matrix(data$O1[q],7,length(Y1)/7)
I2=matrix(data$I2[q],7,length(Y1)/7);I3=matrix(data$I3[q],7,length(Y1)/7)
I4=matrix(data$I4[q],7,length(Y1)/7)   #set of time varying covariates
O3=matrix(data$O3[q],7,length(Y1)/7);O4=matrix(data$O4[q],7,length(Y1)/7)
O5=matrix(data$O5[q],7,length(Y1)/7);O6=matrix(data$O6[q],7,length(Y1)/7)
O7=matrix(data$O7[q],7,length(Y1)/7);O8=matrix(data$O8[q],7,length(Y1)/7)
O9=matrix(data$O9[q],7,length(Y1)/7);O10=matrix(data$O10[q],7,length(Y1)/7)
Tm=matrix(data$w[q],7,length(Y1)/7)
for(i in 1:(length(Y1)/7)){
  for(j in 1:7){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/7)
for(i in 1:(length(Y1)/7))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,7,length(Y1)/7)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/7)){
    s3=0 ; s03=0
    for(j in 1:7){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(7+InvS[1,1]),sqrt((7+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/7)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,7]=rowMeans(meta[,d])  ; beta[,7]=rowMeans(mbeta[,d])
eta1[,7]=rowMeans(meta1[,d]); delta[,7]=rowMeans(mdelta[,d])
sig_e[7]=mean(s_e[d])       ; sig_bc[7]=mean(g12[d])
sig_b[7]=mean(g1[d])        ; sig_c[7]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 6th wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==6 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 && is.na(data$y)[i-2]!=1 &&
     is.na(data$y)[i-3]!=1 && is.na(data$y)[i-4]!=1 && is.na(data$y)[i-5]!=1 ){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1];Y1[i-2]=data$y[i-2];Y1[i-3]=data$y[i-3]
    Y1[i-4]=data$y[i-4];Y1[i-5]=data$y[i-5]
    q[i]=i;q[i-1]=i-1;q[i-2]=i-2;q[i-3]=i-3
    q[i-4]=i-4;q[i-5]=i-5
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,6,length(Y1)/6); Y=matrix(Y1,6,length(Y1)/6)
A=matrix(data$A[q],6,length(Y1)/6);B=matrix(data$O1[q],6,length(Y1)/6)
I2=matrix(data$I2[q],6,length(Y1)/6);I3=matrix(data$I3[q],6,length(Y1)/6)
I4=matrix(data$I4[q],6,length(Y1)/6)   #set of time varying covariates
O3=matrix(data$O3[q],6,length(Y1)/6);O4=matrix(data$O4[q],6,length(Y1)/6)
O5=matrix(data$O5[q],6,length(Y1)/6);O6=matrix(data$O6[q],6,length(Y1)/6)
O7=matrix(data$O7[q],6,length(Y1)/6);O8=matrix(data$O8[q],6,length(Y1)/6)
O9=matrix(data$O9[q],6,length(Y1)/6);O10=matrix(data$O10[q],6,length(Y1)/6)
Tm=matrix(data$w[q],6,length(Y1)/6)
for(i in 1:(length(Y1)/6)){
  for(j in 1:6){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/6)
for(i in 1:(length(Y1)/6))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,6,length(Y1)/6)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/6)){
    s3=0 ; s03=0
    for(j in 1:6){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(6+InvS[1,1]),sqrt((6+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/6)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,6]=rowMeans(meta[,d])  ; beta[,6]=rowMeans(mbeta[,d])
eta1[,6]=rowMeans(meta1[,d]); delta[,6]=rowMeans(mdelta[,d])
sig_e[6]=mean(s_e[d])       ; sig_bc[6]=mean(g12[d])
sig_b[6]=mean(g1[d])        ; sig_c[6]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 5th wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==5 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 && is.na(data$y)[i-2]!=1 &&
     is.na(data$y)[i-3]!=1 && is.na(data$y)[i-4]!=1 ){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1];Y1[i-2]=data$y[i-2];Y1[i-3]=data$y[i-3]
    Y1[i-4]=data$y[i-4]
    q[i]=i;q[i-1]=i-1;q[i-2]=i-2;q[i-3]=i-3
    q[i-4]=i-4
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,5,length(Y1)/5); Y=matrix(Y1,5,length(Y1)/5)
A=matrix(data$A[q],5,length(Y1)/5);B=matrix(data$O1[q],5,length(Y1)/5)
I2=matrix(data$I2[q],5,length(Y1)/5);I3=matrix(data$I3[q],5,length(Y1)/5)
I4=matrix(data$I4[q],5,length(Y1)/5)   #set of time varying covariates
O3=matrix(data$O3[q],5,length(Y1)/5);O4=matrix(data$O4[q],5,length(Y1)/5)
O5=matrix(data$O5[q],5,length(Y1)/5);O6=matrix(data$O6[q],5,length(Y1)/5)
O7=matrix(data$O7[q],5,length(Y1)/5);O8=matrix(data$O8[q],5,length(Y1)/5)
O9=matrix(data$O9[q],5,length(Y1)/5);O10=matrix(data$O10[q],5,length(Y1)/5)
Tm=matrix(data$w[q],5,length(Y1)/5)
for(i in 1:(length(Y1)/5)){
  for(j in 1:5){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/5)
for(i in 1:(length(Y1)/5))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,5,length(Y1)/5)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/5)){
    s3=0 ; s03=0
    for(j in 1:5){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(5+InvS[1,1]),sqrt((5+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/5)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,5]=rowMeans(meta[,d])  ; beta[,5]=rowMeans(mbeta[,d])
eta1[,5]=rowMeans(meta1[,d]); delta[,5]=rowMeans(mdelta[,d])
sig_e[5]=mean(s_e[d])       ; sig_bc[5]=mean(g12[d])
sig_b[5]=mean(g1[d])        ; sig_c[5]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 4th wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==4 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 && is.na(data$y)[i-2]!=1 &&
     is.na(data$y)[i-3]!=1 ){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1];Y1[i-2]=data$y[i-2];Y1[i-3]=data$y[i-3]
    q[i]=i;q[i-1]=i-1;q[i-2]=i-2;q[i-3]=i-3
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,4,length(Y1)/4); Y=matrix(Y1,4,length(Y1)/4)
A=matrix(data$A[q],4,length(Y1)/4);B=matrix(data$O1[q],4,length(Y1)/4)
I2=matrix(data$I2[q],4,length(Y1)/4);I3=matrix(data$I3[q],4,length(Y1)/4)
I4=matrix(data$I4[q],4,length(Y1)/4)   #set of time varying covariates
O3=matrix(data$O3[q],4,length(Y1)/4);O4=matrix(data$O4[q],4,length(Y1)/4)
O5=matrix(data$O5[q],4,length(Y1)/4);O6=matrix(data$O6[q],4,length(Y1)/4)
O7=matrix(data$O7[q],4,length(Y1)/4);O8=matrix(data$O8[q],4,length(Y1)/4)
O9=matrix(data$O9[q],4,length(Y1)/4);O10=matrix(data$O10[q],4,length(Y1)/4)
Tm=matrix(data$w[q],4,length(Y1)/4)
for(i in 1:(length(Y1)/4)){
  for(j in 1:4){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/4)
for(i in 1:(length(Y1)/4))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,4,length(Y1)/4)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/4)){
    s3=0 ; s03=0
    for(j in 1:4){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(4+InvS[1,1]),sqrt((4+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/4)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,4]=rowMeans(meta[,d])  ; beta[,4]=rowMeans(mbeta[,d])
eta1[,4]=rowMeans(meta1[,d]); delta[,4]=rowMeans(mdelta[,d])
sig_e[4]=mean(s_e[d])       ; sig_bc[4]=mean(g12[d])
sig_b[4]=mean(g1[d])        ; sig_c[4]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 3rd wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==3 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 && is.na(data$y)[i-2]!=1 ){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1];Y1[i-2]=data$y[i-2]
    q[i]=i;q[i-1]=i-1;q[i-2]=i-2
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,3,length(Y1)/3); Y=matrix(Y1,3,length(Y1)/3)
A=matrix(data$A[q],3,length(Y1)/3);B=matrix(data$O1[q],3,length(Y1)/3)
I2=matrix(data$I2[q],3,length(Y1)/3);I3=matrix(data$I3[q],3,length(Y1)/3)
I4=matrix(data$I4[q],3,length(Y1)/3)   #set of time varying covariates
O3=matrix(data$O3[q],3,length(Y1)/3);O4=matrix(data$O4[q],3,length(Y1)/3)
O5=matrix(data$O5[q],3,length(Y1)/3);O6=matrix(data$O6[q],3,length(Y1)/3)
O7=matrix(data$O7[q],3,length(Y1)/3);O8=matrix(data$O8[q],3,length(Y1)/3)
O9=matrix(data$O9[q],3,length(Y1)/3);O10=matrix(data$O10[q],3,length(Y1)/3)
Tm=matrix(data$w[q],3,length(Y1)/3)
for(i in 1:(length(Y1)/3)){
  for(j in 1:3){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/3)
for(i in 1:(length(Y1)/3))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,3,length(Y1)/3)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/3)){
    s3=0 ; s03=0
    for(j in 1:3){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(3+InvS[1,1]),sqrt((3+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/3)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,3]=rowMeans(meta[,d])  ; beta[,3]=rowMeans(mbeta[,d])
eta1[,3]=rowMeans(meta1[,d]); delta[,3]=rowMeans(mdelta[,d])
sig_e[3]=mean(s_e[d])       ; sig_bc[3]=mean(g12[d])
sig_b[3]=mean(g1[d])        ; sig_c[3]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 2nd wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==2 && is.na(data$y)[i]!=1 && is.na(data$y)[i-1]!=1 ){
    Y1[i]=data$y[i];Y1[i-1]=data$y[i-1]
    q[i]=i;q[i-1]=i-1
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,2,length(Y1)/2); Y=matrix(Y1,2,length(Y1)/2)
A=matrix(data$A[q],2,length(Y1)/2);B=matrix(data$O1[q],2,length(Y1)/2)
I2=matrix(data$I2[q],2,length(Y1)/2);I3=matrix(data$I3[q],2,length(Y1)/2)
I4=matrix(data$I4[q],2,length(Y1)/2)   #set of time varying covariates
O3=matrix(data$O3[q],2,length(Y1)/2);O4=matrix(data$O4[q],2,length(Y1)/2)
O5=matrix(data$O5[q],2,length(Y1)/2);O6=matrix(data$O6[q],2,length(Y1)/2)
O7=matrix(data$O7[q],2,length(Y1)/2);O8=matrix(data$O8[q],2,length(Y1)/2)
O9=matrix(data$O9[q],2,length(Y1)/2);O10=matrix(data$O10[q],2,length(Y1)/2)
Tm=matrix(data$w[q],2,length(Y1)/2)
for(i in 1:(length(Y1)/2)){
  for(j in 1:2){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/2)
for(i in 1:(length(Y1)/2))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,2,length(Y1)/2)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/2)){
    s3=0 ; s03=0
    for(j in 1:2){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(2+InvS[1,1]),sqrt((2+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/2)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,2]=rowMeans(meta[,d])  ; beta[,2]=rowMeans(mbeta[,d])
eta1[,2]=rowMeans(meta1[,d]); delta[,2]=rowMeans(mdelta[,d])
sig_e[2]=mean(s_e[d])       ; sig_bc[2]=mean(g12[d])
sig_b[2]=mean(g1[d])        ; sig_c[2]=mean(g2[d])

#1st and 2nd dynamic model estimating parameters upto 1st wave

Y1=rep(NA,15432); q=rep(0,15432)
for(i in 1:15432){
  if(data$w[i]==1 && is.na(data$y)[i]!=1 ){
    Y1[i]=data$y[i]
    q[i]=i
  } 
}
Y1=Y1[!is.na(Y1)]  #remove all NA from the vector Y1
E=matrix(0,1,length(Y1)/1); Y=matrix(Y1,1,length(Y1)/1)
A=matrix(data$A[q],1,length(Y1)/1);B=matrix(data$O1[q],1,length(Y1)/1)
I2=matrix(data$I2[q],1,length(Y1)/1);I3=matrix(data$I3[q],1,length(Y1)/1)
I4=matrix(data$I4[q],1,length(Y1)/1)   #set of time varying covariates
O3=matrix(data$O3[q],1,length(Y1)/1);O4=matrix(data$O4[q],1,length(Y1)/1)
O5=matrix(data$O5[q],1,length(Y1)/1);O6=matrix(data$O6[q],1,length(Y1)/1)
O7=matrix(data$O7[q],1,length(Y1)/1);O8=matrix(data$O8[q],1,length(Y1)/1)
O9=matrix(data$O9[q],1,length(Y1)/1);O10=matrix(data$O10[q],1,length(Y1)/1)
Tm=matrix(data$w[q],1,length(Y1)/1)
for(i in 1:(length(Y1)/1)){
  for(j in 1:1){
    if(Y[j,i]!=0){
      E[j,i]=1
      Y[j,i]=log(Y[j,i])
    }
  }
}
meta=matrix(0,5*r0,le); meta1=matrix(0,5*r1,le)
mbeta=matrix(0,8,le);  mdelta=matrix(0,8,le)
s_e=numeric(le); s_e[1]=mean(rinvgamma(le,alpha_e,beta_e))
g1=numeric(le);g2=numeric(le);g12=numeric(le)
g1[1]=1;g2[1]=1
S=matrix(c(g1[1],g12[1]*g1[1]*g2[1],g12[1]*g1[1]*g2[1],g2[1]),2,2)
mbc=matrix(0,2,length(Y1)/1)
for(i in 1:(length(Y1)/1))
  mbc[,i]=rmvnorm(1,c(0,0))


for(l in 2:le){
  r01=matrix(0,1,length(Y1)/1)
  s1=numeric(5*r0); s11=matrix(0,5*r0,5*r0)
  s2=numeric(8)   ; s22=matrix(0,8,8)
  s01=numeric(5*r1); s011=matrix(0,5*r1,5*r1)
  s02=numeric(8)   ; s022=matrix(0,8,8)
  s04=0;  S05=matrix(0,2,2)
  InvS=solve(S)
  for(i in 1:(length(Y1)/1)){
    s3=0 ; s03=0
    for(j in 1:1){
      if(E[j,i]){
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        lower = 0)
        s01=s01+s_e[l-1]^-1*(Y[j,i]-f3(j,i)%*%mdelta[,l-1]-mbc[2,i])*kproduct(f2(j,i),f1(Tm[j,i],r1))
        s011=s011+s_e[l-1]^-1*(kproduct(f2(j,i),f1(Tm[j,i],r1)))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r1)))
        s02=s02+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-mbc[2,i])*f3(j,i)
        s022=s022+s_e[l-1]^-1*(f3(j,i))%*%t(f3(j,i))
        s03=s03+s_e[l-1]^-1*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                               f3(j,i)%*%mdelta[,l-1])
        s04=s04+0.5*(Y[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r1))%*%meta1[,l-1]-
                       f3(j,i)%*%mdelta[,l-1]-mbc[2,i])^2
      }else{
        r01[j,i]=rtnorm(1,kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]+f3(j,i)%*%mbeta[,l-1]+mbc[1,i],1,
                        upper = 0)
      }
      s1=s1+(r01[j,i]-f3(j,i)%*%mbeta[,l-1]-mbc[1,i])*kproduct(f2(j,i),f1(Tm[j,i],r0))
      s11=s11+kproduct(f2(j,i),f1(Tm[j,i],r0))%*%t(kproduct(f2(j,i),f1(Tm[j,i],r0)))
      s2=s2+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-mbc[1,i])*f3(j,i)
      s22=s22+f3(j,i)%*%t(f3(j,i))
      s3=s3+(r01[j,i]-kproduct(f2(j,i),f1(Tm[j,i],r0))%*%meta[,l-1]-f3(j,i)%*%mbeta[,l-1])
    }
    mbc[1,i]=rnorm(1,(s3-InvS[1,2]*mbc[2,i])/(1+InvS[1,1]),sqrt((1+InvS[1,1])^-1))
    mbc[2,i]=rnorm(1,s03/(sum(E[,i])/s_e[l-1]+InvS[2,2]),sqrt((sum(E[,i])/s_e[l-1]+InvS[2,2])^-1))
    S05=S05+mbc[,i]%*%t(mbc[,i])
  }
  meta[,l]=rmvnorm(1,solve(s11+sigma_eta^-1*diag(5*r0))%*%(s1+sigma_eta^-1*mu_eta),
                   solve(s11+sigma_eta^-1*diag(5*r0)))
  mbeta[,l]=rmvnorm(1,solve(s22+sigma_beta^-1*diag(8))%*%(s2+sigma_beta^-1*mu_beta),
                    solve(s22+sigma_beta^-1*diag(8)))
  meta1[,l]=rmvnorm(1,solve(s011+sigma_eta1^-1*diag(5*r1))%*%(s01+sigma_eta1^-1*mu_eta1),
                    solve(s011+sigma_eta1^-1*diag(5*r1)))
  mdelta[,l]=rmvnorm(1,solve(s022+sigma_delta^-1*diag(8))%*%(s02+sigma_delta^-1*mu_delta),
                     solve(s022+sigma_delta^-1*diag(8)))
  s_e[l]=rinvgamma(1,0.5*sum(E)+alpha_e,s04+beta_e)
  S=riwish((length(Y1)/1)+2,S05+diag(2))
  g1[l]=S[1,1]  ; g2[l]=S[2,2]  ; g12[l]=S[1,2]
  print(l)
}

eta[,1]=rowMeans(meta[,d])  ; beta[,1]=rowMeans(mbeta[,d])
eta1[,1]=rowMeans(meta1[,d]); delta[,1]=rowMeans(mdelta[,d])
sig_e[1]=mean(s_e[d])       ; sig_bc[1]=mean(g12[d])
sig_b[1]=mean(g1[d])        ; sig_c[1]=mean(g2[d])


#====================================#
f4=function(k){
  return(c(data$A[k],data$O1[k],data$I2[k],data$I3[k],data$I4[k]))
}
f5=function(k){
  return(c(data$O3[k],data$O4[k],data$O5[k],data$O6[k],data$O7[k],data$O8[k],data$O9[k],data$O10[k]))
}

#ACMV imputation
n_im=3 # Total number of imputation
i_m=matrix(0,15432,n_im) #Imputation matrix
for(j2 in 1:n_im){
  #2nd wave imputation
  alpha=c(1826,1757,1587,1487,1358,1295,1227)/1929
  for(i in 1:15432){
    if(data$w[i]==2 && is.na(data$y)[i]==1){
      y1=data$y[i-1];omega=numeric(7)
      for(j in 1:7){
        if(y1==0){
          omega[j]=alpha[j]*pnorm(kproduct(f4(i-1),f1(data$w[i-1],r0))%*%eta[,j+1]+
                                    f5(i-1)%*%beta[,j+1]+mean(rnorm(1000,0,sig_b[j+1])))
        }else{
          omega[j]=alpha[j]*dnorm(log(y1),kproduct(f4(i-1),f1(data$w[i-1],r1))%*%eta1[,j+1]+
                                    f5(i-1)%*%delta[,j+1],sig_e[j+1]+sig_c[j+1])
        }
        if(omega[j]==0 || is.finite(omega[j])==0){omega[j]=alpha[j]}
      }
      omega=omega/sum(omega);U=runif(1)
      if(U < omega[1]){
        p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,2]+
                   f5(i)%*%beta[,2]+mean(rnorm(1000,0,sig_b[2])))
        if(is.finite(p1)){
          e1=rbinom(1,1,p1)
        }else{e1=rbinom(1,1,0.5)}
        if(e1==0){data$y[i]=0}else{
          if(y1==0){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,2]+
                                          f5(i-1)%*%delta[,2],sig_e[2]+sig_c[2]))
          }else{
            M=sig_e[2]*diag(2)+sig_c[2]*(rep(1,2)%*%t(rep(1,2)))
            data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,2]+
                                  f5(i-1)%*%delta[,2]+M[2,1]*M[1,1]^(-1)*
                                  (log(y1)-kproduct(f4(i-1),f1(data$w[i-1],r1))%*%eta1[,2]+
                                     f5(i-1)%*%delta[,1]),M[2,2]-M[2,1]*M[1,1]^(-1)*M[1,2]))
          }
          if(is.finite(data$y[i])==0)
            data$y[i]=exp(rnorm(1,0,10))
        }
      }
      for(j in 2:7){
        if(cumsum(omega)[j-1]<=U && cumsum(omega)[j]>U){
          p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,j+1]+
                     f5(i)%*%beta[,j+1]+mean(rnorm(1000,0,sig_b[j+1])))
          if(is.finite(p1)){
            e1=rbinom(1,1,p1)
          }else{e1=rbinom(1,1,0.5)}
          if(e1==0){data$y[i]=0}else{
            if(y1==0){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+1]+
                                            f5(i)%*%delta[,j+1],sig_e[j+1]+sig_c[j+1]))
            }else{
              M=sig_e[j+1]*diag(2)+sig_c[j+1]*(rep(1,2)%*%t(rep(1,2)))
              data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+1]+
                                    f5(i)%*%delta[,j+1]+M[2,1]*M[1,1]^(-1)*
                                    (log(y1)-kproduct(f4(i-1),f1(data$w[i-1],r1))%*%eta1[,1]+
                                       f5(i-1)%*%delta[,1]),M[2,2]-M[2,1]*M[1,1]^(-1)*M[1,2]))
            }
            if(is.finite(data$y[i])==0)
              data$y[i]=exp(rnorm(1,0,10))
          }
        }
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #3rd wave imputation
  alpha=c(1757,1650,1536,1391,1320,1252)/1929
  for(i in 1:15432){
    if(data$w[i]==3 && is.na(data$y)[i]==1){
      y1=c(data$y[i-2],data$y[i-1]);omega=numeric(6);l=sum(y1!=0)
      for(j in 1:6){
        s1=1;s2=numeric(2)
        for(k in 1:2){
          if(y1[k]==0){
            s1=s1*alpha[j]*pnorm(kproduct(f4(i-3+k),f1(data$w[i-3+k],r0))%*%eta[,j+2]+
                                   f5(i-3+k)%*%beta[,j+2]+mean(rnorm(1000,0,sig_b[j+2])))
          }else{
            s2[k]=kproduct(f4(i-3+k),f1(data$w[i-3+k],r1))%*%eta1[,j+2]+
              f5(i-3+k)%*%delta[,j+2]
          }
        }
        if(l>0){
          omega[j]=s1*(alpha[j]*dmvnorm(log(y1[y1!=0]),s2[s2!=0],
                                        sig_e[j+2]*diag(l)+sig_c[j+2]*(rep(1,l)%*%t(rep(1,l)))))
        }else{omega[j]=s1}
        if(omega[j]==0 || is.finite(omega[j])==0){omega[j]=alpha[j]}
      }
      omega=omega/sum(omega);U=runif(1)
      if(U<omega[1]){
        p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,3]+
                   f5(i)%*%beta[,3]+mean(rnorm(1000,0,sig_b[3])))
        if(is.finite(p1)){
          e1=rbinom(1,1,p1)
        }else{e1=rbinom(1,1,0.5)}
        if(e1==0){data$y[i]=0}else{
          if(identical(y1,rep(0,2))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,3]+
                                                           f5(i)%*%delta[,3],sig_e[3]+sig_c[3]))
          }else{if(l>0){
            M=sig_e[3]*diag(l+1)+sig_c[3]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(3)
            s3[3]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,3]+
              f5(i)%*%delta[,3]
            for(k in 1:2){
              if(y1[k]!=0)
                s3[k]=kproduct(f4(i-3+k),f1(data$w[i-3+k],r1))%*%eta1[,3]+
                  f5(i-3+k)%*%delta[,3]
            }
            data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
          }
          }
          if(is.finite(data$y[i])==0)
            data$y[i]=exp(rnorm(1,0,10))
        }
      }
      for(j in 2:6){
        if(cumsum(omega)[j-1]<=U && cumsum(omega)[j]>U){
          p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,j+2]+
                     f5(i)%*%beta[,j+2]+mean(rnorm(1000,0,sig_b[j+2])))
          if(is.finite(p1)){
            e1=rbinom(1,1,p1)
          }else{e1=rbinom(1,1,0.5)}
          if(e1==0){data$y[i]=0}else{
            if(identical(y1,rep(0,2))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+2]+
                                                             f5(i)%*%delta[,j+2],sig_e[j+2]+sig_c[j+2]))
            }else{if(l>0){
              M=sig_e[j+2]*diag(l+1)+sig_c[j+2]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(3)
              s3[3]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+2]+
                f5(i)%*%delta[,j+2]
              for(k in 1:2){
                if(y1[k]!=0)
                  s3[k]=kproduct(f4(i-3+k),f1(data$w[i-3+k],r1))%*%eta1[,j+2]+
                    f5(i-3+k)%*%delta[,j+2]
              }
              data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
            }
            }
            if(is.finite(data$y[i])==0)
              data$y[i]=exp(rnorm(1,0,10))
          }
        }
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #4th wave imputation
  alpha=c(1697,1570,1420,1345,1273)/1929
  for(i in 1:15432){
    if(data$w[i]==4 && is.na(data$y)[i]==1){
      y1=c(data$y[i-3],data$y[i-2],data$y[i-1]);omega=numeric(5);l=sum(y1!=0)
      for(j in 1:5){
        s1=1;s2=numeric(3)
        for(k in 1:3){
          if(y1[k]==0){
            s1=s1*alpha[j]*pnorm(kproduct(f4(i-4+k),f1(data$w[i-4+k],r0))%*%eta[,j+3]+
                                   f5(i-4+k)%*%beta[,j+3]+mean(rnorm(1000,0,sig_b[j+3])))
          }else{
            s2[k]=kproduct(f4(i-4+k),f1(data$w[i-4+k],r1))%*%eta1[,j+3]+
              f5(i-4+k)%*%delta[,j+3]
          }
        }
        if(l>0){
          omega[j]=s1*(alpha[j]*dmvnorm(log(y1[y1!=0]),s2[s2!=0],
                                        sig_e[j+3]*diag(l)+sig_c[j+3]*(rep(1,l)%*%t(rep(1,l)))))
        }else{omega[j]=s1}
        if(omega[j]==0 || is.finite(omega[j])==0){omega[j]=alpha[j]}
      }
      omega=omega/sum(omega);U=runif(1)
      if(U<omega[1]){
        p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,4]+
                   f5(i)%*%beta[,4]+mean(rnorm(1000,0,sig_b[4])))
        if(is.finite(p1)){
          e1=rbinom(1,1,p1)
        }else{e1=rbinom(1,1,0.5)}
        if(e1==0){data$y[i]=0}else{
          if(identical(y1,rep(0,3))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,4]+
                                                           f5(i)%*%delta[,4],sig_e[4]+sig_c[4]))
          }else{if(l>0){
            M=sig_e[4]*diag(l+1)+sig_c[4]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(4)
            s3[4]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,4]+f5(i)%*%delta[,4]
            for(k in 1:3){
              if(y1[k]!=0)
                s3[k]=kproduct(f4(i-4+k),f1(data$w[i-4+k],r1))%*%eta1[,4]+
                  f5(i-4+k)%*%delta[,4]
            }
            data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
          }
          }
          if(is.finite(data$y[i])==0)
            data$y[i]=exp(rnorm(1,0,10))
        }
      }
      for(j in 2:5){
        if(cumsum(omega)[j-1]<=U && cumsum(omega)[j]>U){
          p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,j+3]+
                     f5(i)%*%beta[,j+3]+mean(rnorm(1000,0,sig_b[j+3])))
          if(is.finite(p1)){
            e1=rbinom(1,1,p1)
          }else{e1=rbinom(1,1,0.5)}
          if(e1==0){data$y[i]=0}else{
            if(identical(y1,rep(0,3))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+3]+
                                                             f5(i)%*%delta[,j+3],sig_e[j+3]+sig_c[j+3]))
            }else{if(l>0){
              M=sig_e[j+3]*diag(l+1)+sig_c[j+3]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(4)
              s3[4]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+3]+f5(i)%*%delta[,j+3]
              for(k in 1:3){
                if(y1[k]!=0)
                  s3[k]=kproduct(f4(i-4+k),f1(data$w[i-4+k],r1))%*%eta1[,j+3]+
                    f5(i-4+k)%*%delta[,j+3]
              }
              data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
            }
            }
            if(is.finite(data$y[i])==0)
              data$y[i]=exp(rnorm(1,0,10))
          }
        }
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #5th wave imputation
  alpha=c(1621,1456,1377,1300)/1929
  for(i in 1:15432){
    if(data$w[i]==5 && is.na(data$y)[i]==1){
      y1=c(data$y[i-4],data$y[i-3],data$y[i-2],data$y[i-1]);omega=numeric(4);l=sum(y1!=0)
      for(j in 1:4){
        s1=1;s2=numeric(4)
        for(k in 1:4){
          if(y1[k]==0){
            s1=s1*alpha[j]*pnorm(kproduct(f4(i-5+k),f1(data$w[i-5+k],r0))%*%eta[,j+4]+
                                   f5(i-5+k)%*%beta[,j+4]+mean(rnorm(1000,0,sig_b[j+4])))
          }else{
            s2[k]=kproduct(f4(i-5+k),f1(data$w[i-5+k],r1))%*%eta1[,j+4]+
              f5(i-5+k)%*%delta[,j+4]
          }
        }
        if(l>0){
          omega[j]=s1*(alpha[j]*dmvnorm(log(y1[y1!=0]),s2[s2!=0],
                                        sig_e[j+4]*diag(l)+sig_c[j+4]*(rep(1,l)%*%t(rep(1,l)))))
        }else{omega[j]=s1}
        if(omega[j]==0 || is.finite(omega[j])==0){omega[j]=alpha[j]}
      }
      omega=omega/sum(omega);U=runif(1)
      if(U<omega[1]){
        p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,5]+
                   f5(i)%*%beta[,5]+mean(rnorm(1000,0,sig_b[5])))
        if(is.finite(p1)){
          e1=rbinom(1,1,p1)
        }else{e1=rbinom(1,1,0.5)}
        if(e1==0){data$y[i]=0}else{
          if(identical(y1,rep(0,4))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,5]+
                                                           f5(i)%*%delta[,5],sig_e[5]+sig_c[5]))
          }else{if(l>0){
            M=sig_e[5]*diag(l+1)+sig_c[5]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(5)
            s3[5]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,5]+f5(i)%*%delta[,5]
            for(k in 1:4){
              if(y1[k]!=0)
                s3[k]=kproduct(f4(i-5+k),f1(data$w[i-5+k],r1))%*%eta1[,5]+
                  f5(i-5+k)%*%delta[,5]
            }
            data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
          }
          }
          if(is.finite(data$y[i])==0)
            data$y[i]=exp(rnorm(1,0,10))
        }
      }
      for(j in 2:4){
        if(cumsum(omega)[j-1]<=U && cumsum(omega)[j]>U){
          p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,j+4]+
                     f5(i)%*%beta[,j+4]+mean(rnorm(1000,0,sig_b[j+4])))
          e1=rbinom(1,1,p1)
          if(e1==0){data$y[i]=0}else{
            if(identical(y1,rep(0,4))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+4]+
                                                             f5(i)%*%delta[,j+4],sig_e[j+4]+sig_c[j+4]))
            }else{if(l>0){
              M=sig_e[j+4]*diag(l+1)+sig_c[j+4]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(5)
              s3[5]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+4]+f5(i)%*%delta[,j+4]
              for(k in 1:4){
                if(y1[k]!=0)
                  s3[k]=kproduct(f4(i-5+k),f1(data$w[i-5+k],r1))%*%eta1[,j+4]+
                    f5(i)%*%delta[,j+4]
              }
              data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
            }
            }
            if(is.finite(data$y[i])==0)
              data$y[i]=exp(rnorm(1,0,10))
          }
        }
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #6th wave imputation
  alpha=c(1528,1431,1341)/1929
  for(i in 1:15432){
    if(data$w[i]==6 && is.na(data$y)[i]==1){
      y1=c(data$y[i-5],data$y[i-4],data$y[i-3],data$y[i-2],data$y[i-1]);omega=numeric(3);l=sum(y1!=0)
      for(j in 1:3){
        s1=1;s2=numeric(5)
        for(k in 1:5){
          if(y1[k]==0){
            s1=s1*alpha[j]*pnorm(kproduct(f4(i-6+k),f1(data$w[i-6+k],r0))%*%eta[,j+5]+
                                   f5(i-6+k)%*%beta[,j+5]+mean(rnorm(1000,0,sig_b[j+5])))
          }else{
            s2[k]=kproduct(f4(i-6+k),f1(data$w[i-6+k],r1))%*%eta1[,j+5]+
              f5(i-6+k)%*%delta[,j+5]
          }
        }
        if(l>0){
          omega[j]=s1*(alpha[j]*dmvnorm(log(y1[y1!=0]),s2[s2!=0],
                                        sig_e[j+5]*diag(l)+sig_c[j+5]*(rep(1,l)%*%t(rep(1,l)))))
        }else{omega[j]=s1}
        if(omega[j]==0 || is.finite(omega[j])==0){omega[j]=alpha[j]}
      }
      omega=omega/sum(omega);U=runif(1)
      if(U<omega[1]){
        p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,6]+
                   f5(i)%*%beta[,6]+mean(rnorm(1000,0,sig_b[6])))
        if(is.finite(p1)){
          e1=rbinom(1,1,p1)
        }else{e1=rbinom(1,1,0.5)}
        if(e1==0){data$y[i]=0}else{
          if(identical(y1,rep(0,5))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,6]+
                                                           f5(i)%*%delta[,6],sig_e[6]+sig_c[6]))
          }else{if(l>0){
            M=sig_e[6]*diag(l+1)+sig_c[6]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(6)
            s3[6]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,6]+f5(i)%*%delta[,6]
            for(k in 1:5){
              if(y1[k]!=0)
                s3[k]=kproduct(f4(i-6+k),f1(data$w[i-6+k],r1))%*%eta1[,6]+
                  f5(i-6+k)%*%delta[,6]
            }
            data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
          }
          }
          if(is.finite(data$y[i])==0)
            data$y[i]=exp(rnorm(1,0,10))
        }
      }
      for(j in 2:3){
        if(cumsum(omega)[j-1]<=U && cumsum(omega)[j]>U){
          p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,j+5]+
                     f5(i)%*%beta[,j+5]+mean(rnorm(1000,0,sig_b[j+5])))
          if(is.finite(p1)){
            e1=rbinom(1,1,p1)
          }else{e1=rbinom(1,1,0.5)}
          if(e1==0){data$y[i]=0}else{
            if(identical(y1,rep(0,5))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+5]+
                                                             f5(i)%*%delta[,j+5],sig_e[j+5]+sig_c[j+5]))
            }else{if(l>0){
              M=sig_e[j+5]*diag(l+1)+sig_c[j+5]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(6)
              s3[6]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+5]+f5(i)%*%delta[,j+5]
              for(k in 1:5){
                if(y1[k]!=0)
                  s3[k]=kproduct(f4(i-6+k),f1(data$w[i-6+k],r1))%*%eta1[,j+5]+
                    f5(i-6+k)%*%delta[,k]
              }
              data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
            }
            }
            if(is.finite(data$y[i])==0)
              data$y[i]=exp(rnorm(1,0,10))
          }
        }
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #7th wave imputation
  alpha=c(1471,1373)/1929
  for(i in 1:15432){
    if(data$w[i]==7 && is.na(data$y)[i]==1){
      y1=c(data$y[i-6],data$y[i-5],data$y[i-4],data$y[i-3],data$y[i-2],data$y[i-1]);omega=numeric(2);l=sum(y1!=0)
      for(j in 1:2){
        s1=1;s2=numeric(6)
        for(k in 1:6){
          if(y1[k]==0){
            s1=s1*alpha[j]*pnorm(kproduct(f4(i-7+k),f1(data$w[i-7+k],r0))%*%eta[,j+6]+
                                   f5(i-7+k)%*%beta[,j+6]+mean(rnorm(1000,0,sig_b[j+6])))
          }else{
            s2[k]=kproduct(f4(i-7+k),f1(data$w[i-7+k],r1))%*%eta1[,j+6]+
              f5(i-7+k)%*%delta[,j+6]
          }
        }
        if(l>0){
          omega[j]=s1*(alpha[j]*dmvnorm(log(y1[y1!=0]),s2[s2!=0],
                                        sig_e[j+6]*diag(l)+sig_c[j+6]*(rep(1,l)%*%t(rep(1,l)))))
        }else{omega[j]=s1}
        if(omega[j]==0 || is.finite(omega[j])==0){omega[j]=alpha[j]}
      }
      omega=omega/sum(omega);U=runif(1)
      if(U<omega[1]){
        p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,7]+
                   f5(i)%*%beta[,7]+mean(rnorm(1000,0,sig_b[7])))
        if(is.finite(p1)){
          e1=rbinom(1,1,p1)
        }else{e1=rbinom(1,1,0.5)}
        if(e1==0){data$y[i]=0}else{
          if(identical(y1,rep(0,6))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,7]+
                                                           f5(i)%*%delta[,7],sig_e[7]+sig_c[7]))
          }else{if(l>0){
            M=sig_e[7]*diag(l+1)+sig_c[7]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(7)
            s3[7]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,7]+f5(i)%*%delta[,7]
            for(k in 1:6){
              if(y1[k]!=0)
                s3[k]=kproduct(f4(i-7+k),f1(data$w[i-7+k],r1))%*%eta1[,7]+
                  f5(i-7+k)%*%delta[,7]
            }
            data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
          }
          }
          if(is.finite(data$y[i])==0)
            data$y[i]=exp(rnorm(1,0,10))
        }
      }
      for(j in 2:2){
        if(cumsum(omega)[j-1]<=U && cumsum(omega)[j]>U){
          p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,j+6]+
                     f5(i)%*%beta[,j+6]+mean(rnorm(1000,0,sig_b[j+6])))
          if(is.finite(p1)){
            e1=rbinom(1,1,p1)
          }else{e1=rbinom(1,1,0.5)}
          if(e1==0){data$y[i]=0}else{
            if(identical(y1,rep(0,6))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+6]+
                                                             f5(i)%*%delta[,j+6],sig_e[j+6]+sig_c[j+6]))
            }else{if(l>0){
              M=sig_e[j+6]*diag(l+1)+sig_c[j+6]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(7)
              s3[7]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,j+6]+f5(i)%*%delta[,j+6]
              for(k in 1:6){
                if(y1[k]!=0)
                  s3[k]=kproduct(f4(i-7+k),f1(data$w[i-7+k],r1))%*%eta1[,j+6]+
                    f5(i-7+k)%*%delta[,j+6]
              }
              data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
            }
            }
            if(is.finite(data$y[i])==0)
              data$y[i]=exp(rnorm(1,0,10))
          }
        }
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #8th wave imputation
  for(i in 1:15432){
    if(data$w[i]==8 && is.na(data$y)[i]==1){
      y1=c(data$y[i-7],data$y[i-6],data$y[i-5],data$y[i-4],data$y[i-3],data$y[i-2],data$y[i-1]);l=sum(y1!=0)
      p1=pnorm(kproduct(f4(i),f1(data$w[i],r0))%*%eta[,8]+
                 f5(i)%*%beta[,8]+mean(rnorm(1000,0,sig_b[8])))
      if(is.finite(p1)){
        e1=rbinom(1,1,p1)
      }else{e1=rbinom(1,1,0.5)}
      if(e1==0){data$y[i]=0}else{
        if(identical(y1,rep(0,7))){data$y[i]=exp(rnorm(1,kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,8]+
                                                         f5(i)%*%delta[,8],sig_e[8]+sig_c[8]))
        }else{if(l>0){
          M=sig_e[8]*diag(l+1)+sig_c[8]*(rep(1,l+1)%*%t(rep(1,l+1)));s3=numeric(8)
          s3[8]=kproduct(f4(i),f1(data$w[i],r1))%*%eta1[,8]+f5(i)%*%delta[,8]
          for(k in 1:7){
            if(y1[k]!=0)
              s3[k]=kproduct(f4(i-8+k),f1(data$w[i-8+k],r1))%*%eta1[,8]+
                f5(i-8+k)%*%delta[,8]
          }
          data$y[i]=exp(rcmvnorm(1,s3[s3!=0],M,l+1,1:l,log(y1[y1!=0])))
        }
        }
        if(is.finite(data$y[i])==0)
          data$y[i]=exp(rnorm(1,0,10))
      }
      i_m[i,j2]=data$y[i]
    }
  }
  #data$y=y_s
}
