clear
clc

addpath('../');

yPRED = cell(1, 3);
MCE = zeros(1, 3);
COMTIME = zeros(1, 3);
load wind_direction_texas_split
[n,m] = size(x);
nt = size(xTEST, 1);
%sorting
[Bb,Ib] = sort(x);
x = x(Ib);
y = y(Ib);

mx = mean(x);
Sx = std(x);

x = (x - repmat(mx, n, 1))./repmat(Sx, n, 1);
xTEST = (xTEST - repmat(mx, nt, 1))./repmat(Sx, nt, 1);

% test
q = 1;
IDX = ones(n, 1);
IDX(y > 2) = 2;
[yPRED{q,1}, MCE(q,1), COMTIME(q,1)] = agmm2019_cluster(x, y, xTEST, yTEST, 3, 150, IDX);

%display
load wind_direction_texas_split
[n,m] = size(x);
nt = size(xTEST, 1);
%sorting
[Bb,Ib] = sort(x);
x = x(Ib);
y = y(Ib);

subplot(3,1,1);
scatter(x(x<=xt(292))/1.25, y(x<=xt(292)),'k.'); hold on;
scatter(xTEST(xTEST<=xt(292))/1.25,yTEST(xTEST<=xt(292)), 80, 'b*'); hold on;
plot_angular(xt(1:292)/1.25, TPhi(1:292,:) * Best,'r-',2);
legend('Training Data', 'Test Data', 'Estimated Mean');
xlabel('time (hours)');
ylabel('wind direction');
hold off;

subplot(3,1,2);
scatter(x(x>xt(292) & x<=xt(584))/1.25, y(x>xt(292) & x<=xt(584)),'k.');hold on;
scatter(xTEST(xTEST>xt(292) & xTEST<=xt(584))/1.25,yTEST(xTEST>xt(292) & xTEST<=xt(584)), 80, 'b*');
plot_angular(xt(293:584)/1.25, TPhi(293:584,:) * Best,'r-',2);
legend('Training Data', 'Test Data', 'Estimated Mean','Location','NorthWest');
xlabel('time (hours)');
ylabel('wind direction');
hold off;

subplot(3,1,3);
scatter(x(x>xt(584))/1.25, y(x>xt(584)),'k.');hold on;
scatter(xTEST(xTEST>xt(584))/1.25,yTEST(xTEST>xt(584)), 80, 'b*');
plot_angular(xt(585:end)/1.25, TPhi(585:end,:) * Best,'r-',2);
scatter(x(x>xt(584))/1.25, y(x>xt(584)),'k.');
legend('Training Data', 'Test Data', 'Estimated Mean','Location','NorthWest');
xlabel('time (hours)');
ylabel('wind direction');
hold off;

disp(strcat('test with realdata was completed. The result is being saved.'));
