function [yPRED, MCE, COMTIME, gibbs] = agmm2019_cluster(x, y, xTEST, yTEST, DegFr, Nc, IDX)

%B-spline basis degree of freedom
%DegFr = 3; %B-spline basis degree of freedom
%Nc    = 2; %# of control points B-spline basis degree of freedom

tic;
n = size(x, 1);

%sorting
[~,Ib] = sort(x);
x = x(Ib);
y = y(Ib);

%sorting the data
xc      = [repmat(min(x), 1,DegFr-1), min(x):range(x)/(Nc-1):max(x), repmat(max(x), 1,DegFr-1)];

%DBscan
X1 = [x,y];

% Run DBSCAN Clustering Algorithm
if nargin < 7
    epsilon=0.3;
    MinPts=10;
    IDX=DBSCAN(X1,epsilon,MinPts);

    % IDX == 0 implies 'undetermined';
    while sum(IDX == 0) / length(IDX) > 0.3
        epsilon=epsilon+0.1;
        IDX=DBSCAN(X1,epsilon,MinPts); 
    end
end

M = max(IDX); c(1) = 0; y2 = y + pi; 
%scatter(x, y); hold on; text(x(IDX==1), y(IDX==1), num2str(1));
for m = 2:M
    IDX1 = IDX(IDX < m & IDX > 0);
    dst = pdist2(x(IDX < m & IDX > 0), x(IDX==m));
    %[~, mid] = min(dst);
    %[~, mid] = min(dst(:)); [mid1, mid2] = ind2sub(size(dst), mid);
    dv   = quantile(min(dst, [], 2), 0.05);
    mid1 = find(sum(dst < dv, 2) > 0);
    q = median(IDX1(mid1));
    mid1 = mid1(IDX1(mid1)==q);
    [~, mid2] = min(dst(mid1, :), [], 2);
    
    y1 = y(IDX < m & IDX > 0); ym = y(IDX==m);
    c(m) =  c(q) + round(mean(y1(mid1) - ym(mid2))/(2*pi));
    y2(IDX==m) = y2(IDX==m) + 2*pi*c(m);
    %text(x(IDX==m), y(IDX==m), num2str(m));
end

% ERROR FIX FOR CASE IDX = 0 %%%%%%%
IDX1 = IDX(IDX > 0)';
dst = pdist2(x(IDX > 0), x(IDX==0));
[~, mid1] = min(dst); mid2 = 1:size(dst, 2);
y1 = y(IDX > 0)'; ym = y(IDX==0)';
c_add =  c(IDX1(mid1)) + round((y1(mid1) - ym(mid2))/(2*pi));
addl  = setdiff(unique(c_add), c);
c = [c addl]; 
y2(IDX==0) = y2(IDX==0) + 2*pi*c_add';
id0 = find(IDX == 0);
for k = 1:length(addl)
    IDX(id0(c_add==addl(k))) = M+1;
    M = M + 1;
    %text(x(IDX==M), y(IDX==M), num2str(M));
end

%scatter(x, y, 'ro'); hold on;
%text(x, y, num2str(round((y2 - y)/(2*pi))));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 


X        = bspline_basismatrix(DegFr,xc,x);
X1       = bspline_basismatrix(DegFr,xc,x(IDX > 0));
B        = (X1'*X1 + 0.1*eye(size(X1,2))) \ X1' * y2(IDX > 0); 

% look at the initial solution first!
%scatter(x, y); hold on;
%plot(x, mod(X * B,2*pi)-pi, 'r.');
%hold off;

r = zeros(1,M);
for m = 1:M
    r(m) = sum(IDX==m)/sum(IDX>=0); 
end

%%%%%%%%%%%%%%%%%%%%%%%
% hyperparameters 
Sigma        = eye(size(B,1));
% Hyper-prior parameters
alpha2       = 0.1;
lambda2      = 0.1;
%alpha (inverse gamma dist. shape parameter)
alpha        = 0.1; 
%lambda (inverse gamma dist. scale parameter)
lambda       = 0.1;
%Dirichlet distribution parameter
gamma        = (1/(M))*ones(1,M);

sigma2       = 1;

%history
nIter               = 10000;
zHist               = zeros(n,nIter);
BHist               = zeros(size(B,1),nIter);
sigma2Hist          = zeros(1,nIter);
%SigmaTildeHist not recorded
MuTildeHist         = zeros(size(B,1),nIter);
SigmaHist           = zeros(nIter,size(B,1));
gammaHist           = zeros(M,nIter);
for counter = 1:nIter
    
    for m = 1:M
        rr(:, m) = r(m)*exp((-(1./(2*sigma2)))*((y-X*B + 2*pi*c(m)+pi)).^2);
    end
    rr(sum(rr,2)==0, :) = 1;
    rr = rr ./ repmat(sum(rr, 2), 1, M); 
    z  = mnrnd(1, rr);

    ytilde            = y+(2*pi*z*c')+(ones(n,1)*pi);
    
    % sampling sigma2
    alphaTilde        = alpha + n/2;
    lambdaTilde       = lambda + ((ytilde-(X*B))'*(ytilde-(X*B)))/2; 
    sigma2            = 1./gamrnd(alphaTilde,1/lambdaTilde);

    %%Sampling from Sigma
    alpha2Tilde       = alpha2 + max(size(B))/2;
    lambda2Tilde      = lambda2 + B'*B; 
    sigma22           = 1./gamrnd(alpha2Tilde,1/lambda2Tilde);
    Sigma             = eye(max(size(B))) * sigma22;
    
    %%sampling from B posterior distribution
    tmp               = sigma2 * eye(n) + X * Sigma * X' ;
    L                 = chol(tmp, 'lower');  
    tmp               = L \ X * Sigma;
    SigmaTilde        = Sigma - tmp' * tmp;
    MuTilde           = SigmaTilde * X' * ytilde / sigma2;
    B                 = mvnrnd(MuTilde',SigmaTilde)';
    BHist(:, counter) = B;
    %%sampling from r posterior distribution 
    gammaTilde        = gamma + sum(z);
    r                 = gamrnd(gammaTilde , 1);
    r                 = r./sum(r);
    
    zHist(:,counter)               = z*c';
    BHist(:, counter)              = B;
    sigma2Hist(:,counter)          = sigma2;
    MuTildeHist(:,counter)         = MuTilde; 
    SigmaHist(counter,:)           = diag(Sigma);
    gammaHist(:,counter)           = gammaTilde';
    %plot(1:counter, sum(zHist(:, 1:counter)));
end

gibbs.zHist = zHist;
gibbs.BHist = BHist;
gibbs.sigma2Hist = sigma2Hist;
gibbs.MuTildeHist = MuTildeHist;
gibbs.SigmaHist = SigmaHist;
gibbs.gammaHist = gammaHist;
gibbs.counter   = counter;
gibbs.M         = M;
gibbs.xc        = xc;
gibbs.DegFr     = DegFr;
% Best        = BHist(:, counter);
% TPhi        = bspline_basismatrix(DegFr,xc,xTEST);
% yPRED       = mod(TPhi * Best, 2*pi) - pi; 
% plot(xTEST, yPRED,'k--'); hold on;
% scatter(x, y,'k.');
% hold off;
%     
%%%Prediction
%Best        = mean(BHist(:, round(0.8*nIter):end), 2);
%TPhi        = bspline_basismatrix(DegFr,xc,xTEST);
%plot(xt, TPhi * Best,'k--');hold on;
%scatter(x, y,'k.');
%yPRED       = mod(TPhi * Best, 2*pi) - pi; 
%MCE = mean(abs(sin((yTEST-yPRED)/2)));

TPhi_tr = bspline_basismatrix(DegFr,xc,x);
EE      = mod(TPhi_tr * BHist, 2*pi) - pi;
v       = mean(abs(sin((EE-repmat(y,1, size(EE, 2)))/2)));
v       = v / sum(v);

qv      = quantile(v, 0.01);
%Best    = (BHist * r')/sum(r);
Best    = mean(BHist(:, v < qv), 2);
TPhi    = bspline_basismatrix(DegFr,xc,xTEST);
yPRED   = mod(TPhi * Best, 2*pi) - pi; 
MCE = mean(abs(sin((yTEST-yPRED)/2)));

%hold off;
COMTIME = toc;
