#include <R.h>
#include <Rmath.h>
#include <R_ext/BLAS.h>

void F77_SUB(rndstart)(void) { GetRNGstate(); }
void F77_SUB(rndend)(void) { PutRNGstate(); }
double F77_SUB(normrnd)(void) { return norm_rand(); }

void F77_SUB(poisrnd)(double *res, double *lambda) { *res = rpois(*lambda); }

void F77_SUB(betarnd)(double* px, double* pa, double* pb)
{
        *px = rbeta(*pa, *pb);
}

void F77_SUB(normcdf)(double *res, double *x, double *mu, double *sigma) 
{
  int *lowtail, *givelog ;
  *lowtail = 1 ; *givelog = 1 ;
  *res = exp(pnorm(*x, *mu, *sigma, *lowtail, *givelog)); 
}

void F77_SUB(gammarnd)(double* px, double* a, double* b)
{
        *px = rgamma(*a, *b);
}

void F77_SUB(gammadens)(double* x, double* a, double* b, int* givelog, double* dx)
{
  *dx = dgamma(*x, *a, *b, *givelog);
}


void F77_SUB(gammacdf)(double* x, double* a, double* b, int* lowertail, int* givelog, double* dx)
{
  *dx = pgamma(*x, *a, *b, *lowertail, *givelog);
}

void F77_SUB(gammaquant)(double* x, double* a, double* b, int* lowertail, int* givelog, double* dx)
{
  *dx = qgamma(*x, *a, *b, *lowertail, *givelog);
}
