##################################################################################################################
#
# Nonparametric double additive cure survival models: an application to the estimation of the nonlinear 
# effect of age at first parenthood on fertility progression.
# 
# Statistical Modelling - 2018
#
# Code writen by V.Bremhorst (Universite catholique de Louvain - Belgium)
#
# Joint work with : * Michaela Kreyenfeld - Hertie School of Governance Berlin (Germany) 					 			 
#                   * Philippe Lambert - Universite de Liege and Universite catholique de Louvain (Belgium) 
#
# Corresponding author : vincent.bremhorst@uclouvain.be 
#
#
#    	 ****************************************
#	   	 * 	Main file : Example - Third birth 	*
#		   ****************************************
#
# The data used in this paper are available (only for liscenced SOEP-users) at : 
# https://www.diw.de/de/diw_01.c.361286.de/archiv.html
#
####################################################################################################################

set.seed(1) 

# Clean the workspace
remove(list = ls())

# Define the working directory
# Example : setwd("/home/my_name/Desktop/my_work")

# Load all needed packages
# For the installation : install.packages("package_name")
library(coda) 
library(Rlab)
library(compiler) 
library(alabama) 
library(bayesSurv)

# Load the library with all the fortran routines
#dyn.load("SM_BremhorstetAl2017.so") # linux user
dyn.load("SM_BremhorstetAl2017.dll") # Windows user

# Load all needed R functions
source("Functions/mainFunction.R")
source("Functions/log_post.R")
source("Functions/Estimation.R")
source("Functions/convergenceIssues.R")
source("Functions/Results.R")
source("Functions/PosteriorProbabilities.R")

# Read the data
data <- read.table(file = "ThirdBirth.csv", header = TRUE, sep = ",")
data$EDU02 <- relevel(data$EDU02, ref = "Vocational degree") # Define the reference
data$PEDU02 <- relevel(data$PEDU02, ref = "Vocational degree") # Define the reference

Res <- SM_BremhorstetAl2017_mainFunction( 

    study.name = "Third birth", 

    obstime = data$END,

    Event = data$EVENT,  

    Cure = list(Categorical = list(EDU02 = data$EDU02, PEDU02 = data$PEDU02), Continuous = list(AGEKID1 = data$AGEKID1,  PAGE = data$PAGE_L, SPACE = data$SPACE_C)), 
    labels_Cure = list(Categorical = list("Mother's education level", "Partner's education level"), Continuous = list("Mother's age at first birth", "Partner's age at first birth", "Time elapsed between first and second births")),

    Cox = list(Categorical = list(EDU02 = data$EDU02, PEDU02 = data$PEDU02), Continuous = list(AGEKID1 = data$AGEKID1, PAGE = data$PAGE_L, SPACE = data$SPACE_C)),
    labels_Cox = list(Categorical = list("Mother's education level", "Partner's education level"), Continuous = list("Mother's age at first birth", "Partner's age at first birth","Time elapsed between first and second births")),

    iteration = 150000,
    burnin = 50000

    )


dev.new()
Post.proba( X = c(1,0,0,0,0), 
            continuous.variables = list(data$AGEKID1, data$PAGE_L, data$SPACE_C),
            cont.ref = list(median(data$PAGE_L), median(data$SPACE_C) ), 
            alpha = Res$PostChains[["alphaPost"]], 
            phi = Res$PostChains[["AGEKID1-phi_Proba"]], 
            phi_others = list(Res$PostChains[["PAGE-phi_Proba"]], Res$PostChains[["SPACE-phi_Proba"]]), 
            ylab = "Probability of having a 3rd child", 
            xlab = "Mother's age at first birth",
            main = "Evolution of the probability of having a third child" 
          )

dev.new()
Post.proba( X = c(1,0,0,0,0), 
            continuous.variables = list(data$PAGE_L, data$AGEKID1, data$SPACE_C),
            cont.ref = list(median(data$AGEKID1), median(data$SPACE_C)), 
            alpha = Res$PostChains[["alphaPost"]], 
            phi = Res$PostChains[["PAGE-phi_Proba"]], 
            phi_others = list(Res$PostChains[["AGEKID1-phi_Proba"]], Res$PostChains[["SPACE-phi_Proba"]]), 
            ylab = "Probability of having a 3rd child", 
            xlab = "Partner's age at first birth",
            main = "Evolution of the probability of having a third child" 
          )

dev.new()
Post.proba( X = c(1,0,0,0,0), 
            continuous.variables = list(data$SPACE_C, data$AGEKID1, data$PAGE_L),
            cont.ref = list(median(data$AGEKID1), median(data$PAGE_L)), 
            alpha = Res$PostChains[["alphaPost"]], 
            phi = Res$PostChains[["SPACE-phi_Proba"]], 
            phi_others = list(Res$PostChains[["AGEKID1-phi_Proba"]], Res$PostChains[["PAGE-phi_Proba"]]), 
            ylab = "Probability of having a 3rd child", 
            xlab = "Time elapsed between first and second births",
            main = "Evolution of the probability of having a third child" 
          )

