##################################################################################################################
#
# Nonparametric double additive cure survival models: an application to the estimation of the nonlinear 
# effect of age at first parenthood on fertility progression.
# 
# Statistical Modelling - 2018
#
# Code writen by V.Bremhorst (Universite catholique de Louvain - Belgium)
#
# Joint work with : * Michaela Kreyenfeld - Hertie School of Governance Berlin (Germany) 					 			 
#                   * Philippe Lambert - Universite de Liege and Universite catholique de Louvain (Belgium) 
#
# Corresponding author: vincent.bremhorst@uclouvain.be 
#
#
#
#	*********************************************************************
# 	* Computation of the logarithm of the joint posterior distribution. *
#	* 		!!!!! NOT TO MODIFIED !!!!!			    *
#	*********************************************************************
#
#
####################################################################################################################


log.post <- function( param,

                      index_phi_BD, 
                      index_pen_BD, 
                      n_splines_BD, 
                      n_splines_estimate_BD, 
  		      Bobs, 
                      Bmiddle,
                      penalty_BD,
                      rank_penalty, 

                      width, 
                      upto, 

                      index_phi_Cure, 
                      index_pen_Cure, 

                      index_phi_Cox, 
                      index_pen_Cox, 

		      n_splines_Cov, 
                      n_cov_cont_Cure, 
                      n_cov_cont_Cox, 
                      BcovCure, 
                      BcovCox, 
                      penalty_Cov,

                      index_alpha,
                      X, 

		      index_beta,
                      W, 
                      
	              sd_Cov = 10 ,
                      aPen = 1,
                      bPen = 1, 
 
                      Event
                    )
                  
{ 

# Model parameters
  
   phi_BD <- c( param[index_phi_BD], rep(10, n_splines_BD - n_splines_estimate_BD) )
   pen_BD <- exp(param[index_pen_BD])

   phi_Cure <- param[index_phi_Cure]
   pen_Cure <- exp(param[index_pen_Cure])

   phi_Cox <- param[index_phi_Cox]
   pen_Cox <- exp(param[index_pen_Cox])

   alpha <- param[index_alpha]

   beta <- param[index_beta]
   

# Latent hazard function

   h <- exp( Bobs%*%phi_BD ) * exp( W%*%beta + BcovCox %*% phi_Cox )  


# Latent cumulative hazard function

   temp <- exp( Bmiddle%*%phi_BD ) * width
   tempcum <- cumsum(temp)
   Hcum <- tempcum[upto]
   Hcum <- Hcum * exp( W%*%beta + BcovCox %*% phi_Cox )


# Latent survival function

   S <- exp(-Hcum) 


# Latent CDF function

   F <- 1-S


# Latent density function

   f <- h*S
   f[ which(f < 0.0000001) ] <- 0.0000001 # Avoid numerical issues


# Mean number of latent factors

   theta <- exp(X%*%alpha + BcovCure %*% phi_Cure)


# Contribution to the log likelihood

   t1 = sum(-theta*F)
   t2 = sum(Event*log(theta))
   t3 = sum(Event*log(f))


# Prior distribution of the spline parameters (Baseline distribution)

   t4 =  rank_penalty * log(pen_BD) / 2
   t5 = -pen_BD * phi_BD[ 1:rank_penalty ]%*%penalty_BD%*%phi_BD[ 1:rank_penalty ] / 2

   t6 = (aPen - 1) * log(pen_BD)
   t7 = -bPen * pen_BD


# Prior distribution of the spline parameters (Additive models for continuous covariate effects)

   t8 = 0
   for( i in 1:n_cov_cont_Cure) { 

      t8 = t8 + (n_splines_Cov) * log(pen_Cure[i]) / 2
      t8 = t8 + -pen_Cure[i] * phi_Cure[ (1 + n_splines_Cov * (i-1) ) : ( n_splines_Cov * (i) )  ] %*% penalty_Cov %*% phi_Cure[ (1 + n_splines_Cov * (i-1) ) : ( n_splines_Cov * (i) ) ] / 2

      t8 = t8 + (aPen - 1) * log(pen_Cure[i])
      t8 = t8 + -bPen * pen_Cure[i] 

   }

   for( i in 1:n_cov_cont_Cox) { 

      t8 = t8 + (n_splines_Cov) * log(pen_Cox[i]) / 2
      t8 = t8 - pen_Cox[i] * phi_Cox[ (1 + n_splines_Cov * (i-1) ) : ( n_splines_Cov * (i) )  ] %*% penalty_Cov %*% phi_Cox[ (1 + n_splines_Cov * (i-1) ) : ( n_splines_Cov * (i) ) ] / 2

      t8 = t8 + (aPen - 1) * log(pen_Cox[i])
      t8 = t8 - bPen * pen_Cox[i] 

   }


# Prior distribution of the regression parameters (Proba & Timing)

   for(i in 1:length(index_alpha)) {
      t8 = t8 - alpha[i]**2 / (2*sd_Cov**2)
   }

   for(i in 1:length(index_beta)) {
      t8 = t8 - beta[i]**2 / (2*sd_Cov**2)
   }

   res <- t1 + t2 + t3 + t4 + t5 + t6 + t7 + t8

   return(-res)

}

# Transformation of the log-posterior function into binary toolsbox
# ==> Speed the convergence time

log.post.c <- cmpfun(log.post)

#-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

# Definition of the linear constraints 
# cf. splines parameters of the additive models in (2.3).

heq <- function( par,

                 index_phi_BD, 
                 index_pen_BD, 
                 n_splines_BD, 
                 n_splines_estimate_BD, 
  	         Bobs, 
                 Bmiddle,
                 penalty_BD,
                 rank_penalty, 

                 width, 
                 upto, 

                 index_phi_Cure, 
                 index_pen_Cure, 

                 index_phi_Cox, 
                 index_pen_Cox, 

	         n_splines_Cov, 
                 n_cov_cont_Cure, 
                 n_cov_cont_Cox, 
                 BcovCure, 
                 BcovCox, 
                 penalty_Cov,

                 index_alpha,
                 X,  

	         index_beta,
                 W, 
                     
                 Event 
              )
{ 

   res <- c() 

   for( i in 1:n_cov_cont_Cure ) {

      res[i] <- sum( par[ index_phi_Cure[ ( (i-1) * n_splines_Cov + 1 ) : ( i * n_splines_Cov ) ] ] ) 

   }

   for( i in 1:n_cov_cont_Cox ) {

      res[n_cov_cont_Cure + i] <- sum( par[ index_phi_Cox[ ( (i-1) * n_splines_Cov + 1 ) : ( i * n_splines_Cov ) ] ] ) 

   }

   return(res)

}


