##################################################################################################################
#
# Nonparametric double additive cure survival models: an application to the estimation of the nonlinear 
# effect of age at first parenthood on fertility progression.
# 
# Statistical Modelling - 2018
#
# Code writen by V.Bremhorst (Universite catholique de Louvain - Belgium)
#
# Joint work with : * Michaela Kreyenfeld - Hertie School of Governance Berlin (Germany) 					 			 
#                   * Philippe Lambert - Universite de Liege and Universite catholique de Louvain (Belgium) 
#
# Corresponding author: vincent.bremhorst@uclouvain.be 
#
#
#
#	     ****************************************************************************
#            * Create a folder named "Study_name-Convergence checks" containing all the * 
#	     * information for checking the convergence of the MCMC algorithm.          *
#	     ****************************************************************************
#
#
####################################################################################################################


Convergence.issues <- function( alpha, 
                                beta, 
                                 
                                phi_BD, 
                                pen_BD, 
                                delta_BD,
 
				n_splines_estimate_BD, 

                                phi_Cure, 
                                pen_Cure, 
                                delta_Cure,

                                phi_Cox, 
                                pen_Cox, 
                                delta_Cox,

				n_cov_cont_Cure,
			  	n_cov_cont_Cox, 
				n_splines_Cov,

                                nalpha, 
                                nbeta,

                                accept, 
	   		        newDirectory
                              ) 
{

   filename <- "acceptanceRate.txt" 
   sink(paste(newDirectory, filename, sep = "/")) 
   print( round(apply(accept, 1, mean), 3) ) 
   sink() 

   geweke <- c() 
   geweke <- c( geweke, geweke.diag( t ( phi_BD[1:n_splines_estimate_BD,] ) )$z )
   geweke <- c(geweke, geweke.diag(pen_BD)$z)
   geweke <- c(geweke, geweke.diag(delta_BD)$z)

   geweke <- c(geweke, geweke.diag(t(phi_Cure))$z)
   geweke <- c(geweke, geweke.diag(t(pen_Cure))$z)
   geweke <- c(geweke, geweke.diag(t(delta_Cure))$z)

   geweke <- c(geweke, geweke.diag(t(phi_Cox))$z)
   geweke <- c(geweke, geweke.diag(t(pen_Cox))$z)
   geweke <- c(geweke, geweke.diag(t(delta_Cox))$z)

   geweke <- c(geweke, geweke.diag(t(alpha))$z)
   geweke <- c(geweke, geweke.diag(t(beta))$z)


   filename <- "Geweke_zscore.png"
   png(file = paste(newDirectory, filename, sep = "/"))
   plot(geweke, ylim = c(min(geweke), max(geweke)), main = "z-score of the Geweke convergence diagnostic", xlab = " ", ylab = "z-score") 
   abline(h = 1.96, col = "red", lwd = 2)
   abline(h = -1.96, col = "red", lwd = 2)
   dev.off()

   filename <- paste("tau_BD", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"))
   plot(pen_BD, type = "l", xlab = " iteration", ylab = " " , main = expression(tau))
   dev.off()

   filename <- paste("delta_BD", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"))
   plot(delta_BD, type = "l", ylab = "", xlab = "iteration", main = expression(delta))
   dev.off()

   filename <- paste("phi_BD", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)
   par(mfrow = c(5,4)) 
   for(i in 1:n_splines_estimate_BD) {
       plot(phi_BD[i,], type = "l", ylab = i ) 
   }
   dev.off()

   for(NC in 1:n_cov_cont_Cure) {

      filename <- paste(paste("tau_Cure", NC, sep = "-"), "png", sep = ".") 
      png(file = paste(newDirectory, filename, sep = "/"))
      plot(pen_Cure[NC,], type = "l", xlab = " iteration", ylab = " " , main = expression(tau))
      dev.off()

      filename <- paste(paste("delta_Cure", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"))
      plot(delta_Cure[NC,], type = "l", ylab = "", xlab = "iteration", main = expression(delta))
      dev.off()

      filename <- paste(paste("phi_Cure", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)
      par(mfrow = c(4,3)) 
      for(i in 1:n_splines_Cov) {
          plot(phi_Cure[(NC-1) * n_splines_Cov + i,], type = "l", ylab = i ) 
      }
      dev.off()
   }


   for(NC in 1:n_cov_cont_Cox) {

      filename <- paste(paste("tau_Cox", NC, sep = "-"), "png", sep = ".") 
      png(file = paste(newDirectory, filename, sep = "/"))
      plot(pen_Cox[NC,], type = "l", xlab = " iteration", ylab = " " , main = expression(tau))
      dev.off()

      filename <- paste(paste("delta_Cox", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"))
      plot(delta_Cox[NC,], type = "l", ylab = "", xlab = "iteration", main = expression(delta))
      dev.off()

      filename <- paste(paste("phi_Cox", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)
      par(mfrow = c(4,3)) 
      for(i in 1:n_splines_Cov) {
          plot(phi_Cox[(NC-1) * n_splines_Cov + i,], type = "l", ylab = i ) 
      }
      dev.off()
   }

   filename <- paste("Regression_parameters_alpha", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)

   if (nalpha <= 4) {
      par(mfrow = c(2,2)) 
   }

   else if (nalpha <= 6) {
      par(mfrow = c(3,2)) 
   }


   else if (nalpha <= 9) {
      par(mfrow = c(3,3)) 
   }

   else if (nalpha <= 12){
      par(mfrow = c(4,3)) 
   }

   else if (nalpha <= 16){
      par(mfrow = c(4,4)) 
   }

   else if (nalpha <= 20){
      par(mfrow = c(5,4)) 
   }

   for(i in 1:nalpha) {
      plot(alpha[i,], type = "l", main = expression(alpha) )   
   }

   dev.off() 


   filename <- paste("Regression_parameters_beta", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)

   if (nbeta <= 4) {
      par(mfrow = c(2,2)) 
   }

   else if (nbeta <= 6) {
      par(mfrow = c(3,2)) 
   }


   else if (nbeta <= 9) {
      par(mfrow = c(3,3)) 
   }

   else if (nbeta <= 12){
      par(mfrow = c(4,3)) 
   }

   else if (nbeta <= 16){
      par(mfrow = c(4,4)) 
   }

   else if (nbeta <= 20){
      par(mfrow = c(5,4)) 
   }


   for(i in 1:nbeta) {
      plot(beta[i,], type = "l", main = expression(beta) )   
   }
   dev.off() 

#------------------------------------------------------------------------------------------------------------------------------

   filename <- paste("ACF_tau_BD", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"))
   acf(pen_BD, main = expression(tau))
   dev.off()

   filename <- paste("ACF_delta_BD", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"))
   acf(delta_BD, main = expression(delta))
   dev.off()

   filename <- paste("ACF_phi_BD", "png", sep = ".") 

   png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)
   par(mfrow = c(5,4)) 
   for(i in 1:n_splines_estimate_BD) {
       acf(phi_BD[i,], main = " ") 
   }
   dev.off()

   for(NC in 1:n_cov_cont_Cure) {

      filename <- paste(paste("ACF_tau_Cure", NC, sep = "-"), "png", sep = ".") 
      png(file = paste(newDirectory, filename, sep = "/"))
      acf(pen_Cure[NC,], main = expression(tau))
      dev.off()

      filename <- paste(paste("ACF_delta_Cure", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"))
      acf(delta_Cure[NC,], main = expression(delta))
      dev.off()

      filename <- paste(paste("ACF_phi_Cure", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)
      par(mfrow = c(4,3)) 
      for(i in 1:n_splines_Cov) {
          acf(phi_Cure[(NC-1) * n_splines_Cov + i,], main = " " ) 
      }
      dev.off()
   }


   for(NC in 1:n_cov_cont_Cox) {

      filename <- paste(paste("ACF_tau_Cox", NC, sep = "-"), "png", sep = ".") 
      png(file = paste(newDirectory, filename, sep = "/"))
      acf(pen_Cox[NC,] , main = expression(tau))
      dev.off()

      filename <- paste(paste("ACF_delta_Cox", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"))
      acf(delta_Cox[NC,], main = expression(delta))
      dev.off()

      filename <- paste(paste("ACF_phi_Cox", NC, sep = "-"), "png", sep = ".") 

      png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)
      par(mfrow = c(4,3)) 
      for(i in 1:n_splines_Cov) {
          acf(phi_Cox[(NC-1) * n_splines_Cov + i,], main = " " ) 
      }
      dev.off()
   }

   filename <- paste("ACF_Regression_parameters_alpha", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)

   if (nalpha <= 4) {
      par(mfrow = c(2,2)) 
   }

   else if (nalpha <= 6) {
      par(mfrow = c(3,2)) 
   }


   else if (nalpha <= 9) {
      par(mfrow = c(3,3)) 
   }

   else if (nalpha <= 12){
      par(mfrow = c(4,3)) 
   }

   else if (nalpha <= 16){
      par(mfrow = c(4,4)) 
   }

   else if (nalpha <= 20){
      par(mfrow = c(5,4)) 
   }


   for(i in 1:nalpha) {
      acf(alpha[i,], main = " ")   
   }

   dev.off() 


   filename <- paste("ACF_Regression_parameters_beta", "png", sep = ".") 
   png(file = paste(newDirectory, filename, sep = "/"), width = 2*480, height = 2*480)

   if (nbeta <= 4) {
      par(mfrow = c(2,2)) 
   }

   else if (nbeta <= 6) {
      par(mfrow = c(3,2)) 
   }


   else if (nbeta <= 9) {
      par(mfrow = c(3,3)) 
   }

   else if (nbeta <= 12){
      par(mfrow = c(4,3)) 
   }

   else if (nbeta <= 16){
      par(mfrow = c(4,4)) 
   }

   else if (nbeta <= 20){
      par(mfrow = c(5,4)) 
   }

   for(i in 1:nbeta) {
      acf(beta[i,], main = " ")   
   }
   dev.off() 

}

