##################################################################################################################
#
# Nonparametric double additive cure survival models: an application to the estimation of the nonlinear 
# effect of age at first parenthood on fertility progression.
# 
# Statistical Modelling - 2018
#
# Code writen by V.Bremhorst (Universite catholique de Louvain - Belgium)
# Joint work with : * Michaela Kreyenfeld - Hertie School of Governance Berlin 					 			 
#                   * Philippe Lambert - Universite de Liege and Universite catholique de Louvain (Beligum) 
#
# Corresponding author: vincent.bremhorst@uclouvain.be 
#
#
#
#   ***************************************************************************
#   * Create the graph of the evolution of the probability to have the event  *
#   * for the given value of the other covariates.  			      *
#   ***************************************************************************
#
#
####################################################################################################################


Post.proba <- function ( X,
                         continuous.variables,  
                         cont.ref = NULL, 
                         alpha, 
                         phi,
                         phi_others = NULL, 
                         conf.int = 0.95, 
                         nknots_Cov = 7, 
                         degree_Cov = 3, 
                         ylab, 
                         xlab, 
                         main
                       )
                             
{

# Check input 
if( dim(alpha)[1] != length(X) ) {
   cat("'alpha' and 'X' : lengths differ \n ")
}
else if (length(phi_others) != (length(continuous.variables) - 1) ) {
   cat("'phi_others' and 'continuous.variables' : lengths differ \n ")
}
else if (length(phi_others) != length(cont.ref) ) {
   cat("'phi_others' and 'cont.ref' : lengths differ \n ")
}
else if (length(cont.ref) != (length(continuous.variables) - 1) ) {
      cat("'cont.ref' and 'continuous.variables' : length error \n ")
}

else {

# end 
   n_splines_Cov = nknots_Cov + degree_Cov

   XXcov <- seq(-1, 1, by = 0.01)

   BcovXX <- matrix(.Fortran("cubicBsplines", 
                     x = as.double(XXcov), 
                     nx = as.integer(length(XXcov)), 
                     xl = as.double(-1), 
                     xr = as.double(1),
                     ndx = as.integer(nknots_Cov), 
                     B = as.double(matrix(0, nrow = length(XXcov), ncol = n_splines_Cov)))$B, ncol = n_splines_Cov)
 

   tools = BcovXX %*% phi
   tools_alpha = X %*% alpha
   
   to_add <- 0
   if( length(cont.ref) > 0) {

      for( i in 1:length(phi_others) ) {
 
         tools_NUM <- ( max(continuous.variables[[i+1]]) + min(continuous.variables[[i+1]]) ) / 2 
         tools_DENOM <- ( max(continuous.variables[[i+1]]) - min(continuous.variables[[i+1]]) ) / 2 
       
         tools_XXcov <- ( cont.ref[[i]] - tools_NUM ) / tools_DENOM
         
         tools_BcovXX <- matrix(.Fortran("cubicBsplines", 
                                x = as.double(tools_XXcov), 
                                nx = as.integer(length(tools_XXcov)), 
                                xl = as.double(-1), 
                                xr = as.double(1),
                                ndx = as.integer(nknots_Cov), 
                                B = as.double(matrix(0, nrow = length(tools_XXcov), ncol = n_splines_Cov)))$B, ncol = n_splines_Cov)

 
         to_add = to_add + tools_BcovXX %*% phi_others[[i]]

      }
   }
 
   Proba <- NULL
   for(i in 1:dim(tools)[1]) { 

      Proba <- rbind(Proba, 1 - exp( - exp( tools[i,] + to_add + tools_alpha[1,] ) ) )
 
   }

   Proba95 <- credible.region(t(Proba), probs = conf.int)

   tools_NUM <- ( max(continuous.variables[[1]]) + min(continuous.variables[[1]]) ) / 2 
   tools_DENOM <- ( max(continuous.variables[[1]]) - min(continuous.variables[[1]]) ) / 2 
   abscisse <- XXcov * tools_DENOM +  tools_NUM

   Q025 <- quantile(continuous.variables[[1]], p = 0.025) 
   Q975 <- quantile(continuous.variables[[1]], p = 0.975) 
   keep <- (Q025 <= abscisse) & (Q975 >= abscisse) 

 
   plot(abscisse[keep], apply(Proba, 1, median)[keep], type = "n", ylab = ylab, ylim = c(0,1), xlab = xlab, main = main)
   polygon(c(abscisse[keep], rev(abscisse[keep])), c(Proba95[[1]][1,keep], rev(Proba95[[1]][2,keep])), border = F, col = "grey")
   lines(abscisse[keep], apply(Proba, 1, median)[keep], col = 1, lty = 1, lwd = 2)

}
}
