##################################################################################################################
#
# Nonparametric double additive cure survival models: an application to the estimation of the nonlinear 
# effect of age at first parenthood on fertility progression.
# 
# Statistical Modelling - 2018
#
# Code writen by V.Bremhorst (Universite catholique de Louvain - Belgium)
#
# Joint work with : * Michaela Kreyenfeld - Hertie School of Governance Berlin (Germany) 					 			 
#                   * Philippe Lambert - Universite de Liege and Universite catholique de Louvain (Belgium) 
#
# Corresponding author : vincent.bremhorst@uclouvain.be 
#
#
#    	 ********************************************
#	   	 * 	Main file : Example - Simulated dataset *
#		   ********************************************
#
#
####################################################################################################################

set.seed(1) 

# Clean the workspace
remove(list = ls())

# Define the working directory
# Example : setwd("/home/my_name/Desktop/my_work")

# Load all needed packages
# For the installation : install.packages("package_name")
library(coda) 
library(Rlab)
library(compiler) 
library(alabama) 
library(bayesSurv)

# Load the library with all the fortran routines
#dyn.load("SM_BremhorstetAl2017.so") # linux user
dyn.load("SM_BremhorstetAl2017.dll") # Windows user

# Load all needed R functions
source("Functions/mainFunction.R")
source("Functions/log_post.R")
source("Functions/Estimation.R")
source("Functions/convergenceIssues.R")
source("Functions/Results.R")
source("Functions/PosteriorProbabilities.R")

# Read the data
load(file = "ExampleData.Rdata")

Res <- SM_BremhorstetAl2017_mainFunction( 

    study.name = "Simulated data", 

    obstime = data$END,

    Event = data$EVENT,  

    Cure = list(Categorical = list(Binary1 = data$Bin1, Binary2 = data$Bin2), Continuous = list(Continuous1 = data$Cont1,  Continuous2 = data$Cont2)), 
    labels_Cure = list(Categorical = list("Binary1", "Binary2"), Continuous = list("Continuous1", "Continuous2")),

    Cox = list(Categorical = list(Binary1 = data$Bin1, Binary2 = data$Bin2), Continuous = list(Continuous1 = data$Cont1,  Continuous2 = data$Cont2)), 
    labels_Cox = list(Categorical = list("Binary1", "Binary2"), Continuous = list("Continuous1", "Continuous2")),
    
    iteration = 150000,
    burnin = 50000

    )


dev.new()
Post.proba( X = c(1,0,0), 
            continuous.variables = list(data$Cont1, data$Cont2),
            cont.ref = list(median(data$Cont2)), 
            alpha = Res$PostChains[["alphaPost"]], 
            phi = Res$PostChains[["Continuous1-phi_Proba"]], 
            phi_others = list(Res$PostChains[["Continuous2-phi_Proba"]]), 
            ylab = "Probability of ... ", 
            xlab = "Simulated data",
            main = "Simulated data" 
          )
