# Copyright 2018  Rosaria Simone

######### script mihg


library(CUB)

probmihg<-function(m,pai,theta1,theta2){
  
  pr1<-probihg(m,theta1); pr2<-probihg(m,theta2)
  
  return( pai*pr1 + (1-pai)*pr2)
  
}



sim_mihg<-function(n,m,pai,theta1,theta2){
  
  dico<-runif(n)<pai;
  
  ord1<-unclass(simihg(n,m,theta1));
  ord2<-unclass(simihg(n,m,theta2));
  
  vett<-dico*ord1+(1-dico)*ord2
  
  return(vett)
  
}

#########


loglikmihg<-function(freq,m,pai,theta1,theta2){
  
  prob<-probmihg(m,pai,theta1,theta2)
  return(sum(freq*log(prob)))
  
}

########################
#### for EM algo


ttau1<-function(pai,theta1,theta2,m){
  
  num<-pai*probihg(m,theta1)
  den<-probmihg(m,pai,theta1,theta2)
  return(num/den)
}


Qihg<-function(theta1,ordinal,tau1){
  
  freq<-tabulate(ordinal,nbins=m)
  
  s1<-sum(freq*tau1)
  
  vett1<-(1:m)-1
  aa<- vett1*freq
  s2<-sum(aa*tau1)
  
  
  vett2<-cc<-rep(0,m); vett2[1]<-m-1
  for (j in 2:m){ vett2[j]<-vett2[j-1] + theta1 -1}
  
  for (r in 1:m){
    cc[r]<-sum(log(vett2[1:r]))
    
  }
  
  bb<-cc*freq
  s3<-sum(bb*tau1)
  
  out<- (log(theta1))*s1 + (log(1-theta1))*s2 - s3
  
  return(-out)
  
}






mihgest<-function(ordinal,m,maxiter=500,toler=1e-6){
  
  freq<-tabulate(ordinal,nbins=m)
  finalest<-rep(0,3)
  n<-length(ordinal)
  
  theta1<-runif(1,0.01,1/m)
  theta2<-runif(1,1/m,0.99)
  
  pai<-runif(1)
  
  loglik<-loglikmihg(freq,m,pai,theta1,theta2)
  
  loglikini<-loglik
  
  nniter<-1
  while(nniter<=maxiter){
    likold<-loglik
    
    tau1<-ttau1(pai,theta1,theta2,m)
    
    
    aa<-sum(freq*tau1)
    pai<-aa/n
    
  
    
    
    update1<-optim(par=theta1,fn=Qihg,ordinal=ordinal,tau1=tau1,method = "Brent",hessian=TRUE,lower=0.01, upper=1/m)
    theta1<-update1$par
    
    tau2<-1-tau1
    
    update2<-optim(par=theta2,fn=Qihg,ordinal=ordinal,tau1=tau2,method = "Brent",hessian=TRUE,lower=1/m, upper=0.99)
    theta2<-update2$par
    
    
    logliknew<-loglikmihg(freq,m,pai,theta1,theta2)
    
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  finalest<-c(pai,theta1,theta2)
  
  
  #############################################
  ### to find a numeric hessian of all estimates
  
  elle<-function(param,freq){
    m<-length(freq)
    pai<-param[1]
    theta1<-param[2]
    theta2<-param[3]
    return(-loglikmihg(freq,m,pai,theta1,theta2))
  }
  
  stimahess<-optim(par=finalest,fn=elle,freq=freq,method="L-BFGS-B",hessian=TRUE,lower=c(0.01,0.01,1/m),upper=c(0.99,1/m,1))
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}
###################


###################################################################################################
###################################################################################################
###################################################################################################

############## with covariates


probihg1covn <-
  function(m,ordinal,U,nu){
    n<-length(ordinal)
    vett<-rep(NA,n)
    thetavett<-logis(U,nu)/m
    for (i in 1:n){
      prob<-probihg(m,thetavett[i])
      vett[i]<-prob[ordinal[i]]
    }
    return(vett)
  }



loglikihg1cov <-
  function(m,ordinal,U,nu){
    sum(log(probihg1covn(m,ordinal,U,nu)))
  }


effeihg1cov <-
  function(nu,ordinal,U,m){
    -loglikihg1cov(m,ordinal,U,nu)
  }


probihg2covn <-
  function(m,ordinal,U,nu){
    n<-length(ordinal)
    vett<-rep(NA,n)
    thetavett<-1- (m-1)*logis(U,nu)/m
    for (i in 1:n){
      prob<-probihg(m,thetavett[i])
      vett[i]<-prob[ordinal[i]]
    }
    return(vett)
  }




loglikihg2cov <-
  function(m,ordinal,U,nu){
    sum(log(probihg2covn(m,ordinal,U,nu)))
  }


effeihg2cov <-
  function(nu,ordinal,U,m){
    -loglikihg2cov(m,ordinal,U,nu)
  }




effepai<-function(betk,tau1,Y){
  
  
  pais<-logis(Y,betk)
  tau2<-1-tau1
  
  val<-sum(tau1*log(pais))  + sum(tau2*log(1-pais))
  
  return(-val)
  
}




Qihgcov1<-function(omegas,Y,ordinal,tau1){
  
  
  pri<-probihg1covn(m,ordinal,Y,omegas)
  
  out<-sum(tau1*log(pri))
  
  return(-out)
  
}


Qihgcov2<-function(omegas,Y,ordinal,tau1){
  
  
  pri<-probihg2covn(m,ordinal,Y,omegas)
  
  out<-sum(tau1*log(pri))
  
  return(-out)
  
}

Qihgcov0<-function(theta,ordinal,tau1){
  

  
  pri<-probihg(m,theta)[ordinal]
  
  out<-sum(tau1*log(pri))
  
  return(-out)
  
}


ttau1cov<-function(ordinal,Y,bet,omegas1,U1,omegas2,U2,m){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  prmix<-pais*pr1 + (1-pais)*pr2
  
  num<-pais*pr1
  
  taui<-num/prmix
  
  
 
  return(taui)
  
}




ttau1cov110<-function(ordinal,Y,bet,omegas1,U1,theta2,m){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg(m,theta2)[ordinal]
  
  prmix<-pais*pr1 + (1-pais)*pr2
  
  num<-pais*pr1
  
  taui<-num/prmix
  
  
  
  return(taui)
  
}



ttau1cov010<-function(ordinal,pai,omegas1,U1,theta2,m){
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg(m,theta2)[ordinal]
  
  prmix<-pai*pr1 + (1-pai)*pr2
  
  num<-pai*pr1
  
  taui<-num/prmix
  
  
  
  return(taui)
  
}




ttau1cov110<-function(ordinal,Y,bet,omegas1,U1,theta2,m){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg(m,theta2)[ordinal]
  
  prmix<-pais*pr1 + (1-pais)*pr2
  
  num<-pais*pr1
  
  taui<-num/prmix
  
  
 
  return(taui)
  
}

ttau1cov101<-function(ordinal,Y,bet,theta1,omegas2,U2,m){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg(m,theta1)[ordinal]
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  prmix<-pais*pr1 + (1-pais)*pr2
  
  num<-pais*pr1
  
  taui<-num/prmix
  
  
  
  return(taui)
  
}



ttau1cov001<-function(ordinal,pai,theta1,omegas2,U2,m){
  

  pr1<-probihg(m,theta1)[ordinal]
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  prmix<-pai*pr1 + (1-pai)*pr2
  
  num<-pai*pr1
  
  taui<-num/prmix
  
  
 
  return(taui)
  
}


ttau1cov011<-function(ordinal,pai,omegas1,U1,omegas2,U2,m){
  
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  prmix<-pai*pr1 + (1-pai)*pr2
  
  num<-pai*pr1
  
  taui<-num/prmix
  

  return(taui)
  
}





loglikmihgcov<-function(ordinal,Y,m,bet,omegas1,U1,omegas2,U2){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  probi<-pais*pr1 + (1-pais)*pr2
  
 
  
  return(sum(log(probi)))
  
}


loglikmihgcov110<-function(ordinal,Y,m,bet,omegas1,U1,theta2){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg(m,theta2)[ordinal]
  
  probi<-pais*pr1 + (1-pais)*pr2
  
 
  
  return(sum(log(probi)))
  
}


loglikmihgcov010<-function(ordinal,m,pai,omegas1,U1,theta2){
  

  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg(m,theta2)[ordinal]
  
  probi<-pai*pr1 + (1-pai)*pr2
  
  
  
  return(sum(log(probi)))
  
}

loglikmihgcov011<-function(ordinal,m,pai,omegas1,U1,omegas2,U2){
  
  
  
  pr1<-probihg1covn(m,ordinal,U1,omegas1)
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  probi<-pai*pr1 + (1-pai)*pr2
  
  
  
  return(sum(log(probi)))
  
  
  
}




loglikmihgcov101<-function(ordinal,Y,m,bet,theta1,omegas2,U2){
  
  pais<-logis(Y,bet)
  
  pr1<-probihg(m,theta1)[ordinal]
  
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  probi<-pais*pr1 + (1-pais)*pr2
  
 
  
  return(sum(log(probi)))
  
}


loglikmihgcov001<-function(ordinal,m,pai,theta1,omegas2,U2){
  

  pr1<-probihg(m,theta1)[ordinal]
  
  pr2<-probihg2covn(m,ordinal,U2,omegas2)
  
  probi<-pai*pr1 + (1-pai)*pr2
  
 
  
  return(sum(log(probi)))
  
}



mihgestcov<-function(ordinal,Y,U1,U2,m,maxiter=500,toler=1e-6){
  
  
  n<-length(ordinal)
  
  theta1ini<-max(0.01,1/m - 0.05)
  theta2ini<-min(1/m + 0.05,0.99)
  
  betas<-runif(NCOL(Y)+1,-3,3)
  
  omegas1<-c(log(theta1ini/(1-theta1ini)),rep(0,NCOL(U1)))
  omegas2<-c(log(theta2ini/(1-theta2ini)),rep(0,NCOL(U2)))
  
  loglik<-loglikmihgcov(ordinal,Y,m,betas,omegas1,U1,omegas2,U2)  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    
    tau1<-ttau1cov(ordinal,Y,betas,omegas1,U1,omegas2,U2,m)   
    
    
    updatebeta<-optim(par=betas,fn=effepai,tau1=tau1,Y=Y,method="L-BFGS-B")
    betas<-updatebeta$par  

    update1<-optim(par=omegas1,fn=Qihgcov1,ordinal=ordinal,Y=U1,tau1=tau1,hessian=TRUE)
    omegas1<-update1$par

    tau2<-1-tau1
    
    
    update2<-optim(par=omegas2,fn=Qihgcov2,ordinal=ordinal,Y=U2,tau1=tau2,hessian=TRUE)
    omegas2<-update2$par
    
    
    logliknew<-loglikmihgcov(ordinal,Y,m,betas,omegas1,U1,omegas2,U2)   
    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(betas,omegas1,omegas2)
  
  
  #############################################
  ###
  
  elle<-function(param,ordinal,Y,U1,U2,m){
    p<-NCOL(Y); v<-NCOL(U1); z<-NCOL(U2)
    betas<-param[1:(p+1)]
    omegas1<-param[(p+2):(p+v+2)]
    omegas2<-param[(p+v+3):(p+v+z + 3)]
    return(-loglikmihgcov(ordinal,Y,m,betas,omegas1,U1,omegas2,U2)  )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,Y=Y,U1=U1,U2=U2,m=m,hessian=TRUE)
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}





mihgestcov011<-function(ordinal,U1,U2,m,maxiter=maxiter,toler=toler){

  n<-length(ordinal)
  
  theta1ini<-max(0.01,1/m - 0.05)
  theta2ini<-min(1/m + 0.05,0.99)
  
  pai<-runif(1)
  
  omegas1<-c(log(theta1ini/(1-theta1ini)),rep(0,NCOL(U1)))
  omegas2<-c(log(theta2ini/(1-theta2ini)),rep(0,NCOL(U2)))
  
  
  
  loglik<-loglikmihgcov011(ordinal,m,pai,omegas1,U1,omegas2,U2) 
  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    tau1<-ttau1cov011(ordinal,pai,omegas1,U1,omegas2,U2,m)
    
    
    aa<-sum(tau1)
    pai<-aa/n
    
    
    
    update1<-optim(par=omegas1,fn=Qihgcov1,ordinal=ordinal,Y=U1,tau1=tau1,hessian=TRUE)
    omegas1<-update1$par

    tau2<-1-tau1
    
    
    update2<-optim(par=omegas2,fn=Qihgcov1,ordinal=ordinal,Y=U2,tau1=tau2,hessian=TRUE)
    omegas2<-update2$par

    logliknew<-  loglikmihgcov011(ordinal,m,pai,omegas1,U1,omegas2,U2)

    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(pai,omegas1,omegas2)
  
  
  #############################################

  elle<-function(param,ordinal,U1,U2,m){
    v<-NCOL(U1); z<-NCOL(U2)
    pai<-param[1]
    omegas1<-param[(2):(v+2)]
    
    omegas2<-param[(v+3):(v+z+3)]
    return(-loglikmihgcov011(ordinal,m,pai,omegas1,U1,omegas2,U2)   )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,U1=U1,U2=U2,m=m,hessian=TRUE)
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
  
  
  
  
}


mihgestcov010<-function(ordinal,U1,m,maxiter=500,toler=1e-6){
  
   freq<-tabulate(ordinal,nbins=m)
  n<-length(ordinal)
  
  theta1ini<-max(0.01,1/m - 0.05)
  theta2<-min(1/m + 0.05,0.99)
  
  pai<-runif(1)
  
  omegas1<-c(log(theta1ini/(1-theta1ini)),rep(0,NCOL(U1)))

  loglik<-loglikmihgcov010(ordinal,m,pai,omegas1,U1,theta2)  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    tau1<-ttau1cov010(ordinal,pai,omegas1,U1,theta2,m)
    
    
    aa<-sum(tau1)
    pai<-aa/n
    

    
    update1<-optim(par=omegas1,fn=Qihgcov1,ordinal=ordinal,Y=U1,tau1=tau1,hessian=TRUE)
    omegas1<-update1$par

    tau2<-1-tau1
    
    
    update2<-optim(par=theta2,fn=Qihgcov0,ordinal=ordinal,tau1=tau2,method = "Brent",hessian=TRUE,lower=1/m, upper=0.99)
    theta2<-update2$par
   
    
    logliknew<-loglikmihgcov010(ordinal,m,pai,omegas1,U1,theta2)   
    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(pai,omegas1,theta2)
  
  

  
  elle<-function(param,ordinal,U1,m){
    v<-NCOL(U1)
    pai<-param[1]
    omegas1<-param[(2):(v+2)]
    theta2<-param[v+3]
    return(-loglikmihgcov010(ordinal,m,pai,omegas1,U1,theta2)   )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,U1=U1,m=m,hessian=TRUE)
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}




mihgestcov001<-function(ordinal,U2,m,maxiter=500,toler=1e-6){
  
  freq<-tabulate(ordinal,nbins=m)
  n<-length(ordinal)
  
  theta1<-max(0.01,1/m - 0.05)
  theta2ini<-min(1/m + 0.05,0.99)
  
  pai<-runif(1)
  
  omegas2<-c(log(theta2ini/(1-theta2ini)),rep(0,NCOL(U2)))
  
  loglik<-loglikmihgcov001(ordinal,m,pai,theta1,omegas2,U2)  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    tau1<-ttau1cov001(ordinal,pai,theta1,omegas2,U2,m)
    
    
    aa<-sum(tau1)
    pai<-aa/n
    
    
    update1<-optim(par=theta1,fn=Qihgcov0,ordinal=ordinal,tau1=tau1,method = "Brent",hessian=TRUE,lower=0, upper=1/m-0.01)
    theta1<-update1$par
    
    tau2<-1-tau1
    
    update2<-optim(par=omegas2,fn=Qihgcov2,ordinal=ordinal,Y=U2,tau1=tau2,hessian=TRUE)
    omegas2<-update2$par

    
    
    logliknew<-loglikmihgcov001(ordinal,m,pai,theta1,omegas2,U2)   
    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(pai,theta1,omegas2)
  
  
  #############################################

  elle<-function(param,ordinal,U2,m){
    v<-NCOL(U2)
    pai<-param[1]
    theta1<-param[2]
    
    omegas2<-param[(3):(v+3)]
    return(-loglikmihgcov001(ordinal,m,pai,theta1,omegas2,U2)   )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,U2=U2,m=m,hessian=TRUE)
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}







#################################



mihgestcov110<-function(ordinal,Y,U1,m,maxiter=500,toler=1e-6){
  

  n<-length(ordinal)
  
  theta1ini<-max(0.01,1/m - 0.05)
  theta2<-min(1/m + 0.05,0.99)
  
  betas<-runif(NCOL(Y)+1,-3,3)
  
  omegas1<-c(log(theta1ini/(1-theta1ini)),rep(0,NCOL(U1)))
  
  loglik<-loglikmihgcov110(ordinal,Y,m,betas,omegas1,U1,theta2)  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    
    tau1<-ttau1cov110(ordinal,Y,betas,omegas1,U1,theta2,m)   
    
    
    updatebeta<-optim(par=betas,fn=effepai,tau1=tau1,Y=Y,method="L-BFGS-B")
    betas<-updatebeta$par  
    #print(betas)
    
    update1<-optim(par=omegas1,fn=Qihgcov1,ordinal=ordinal,Y=U1,tau1=tau1,hessian=TRUE)
    omegas1<-update1$par
    #  print(omegas1)
    
    tau2<-1-tau1
    
    
    update2<-optim(par=theta2,fn=Qihg100,ordinal=ordinal,tau1=tau2,m=m,method = "Brent",hessian=TRUE,lower=1/m+0.01, upper=0.99)
   theta2<-update2$par

    
    logliknew<-loglikmihgcov110(ordinal,Y,m,betas,omegas1,U1,theta2)  
    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(betas,omegas1,theta2)
  
  
  #############################################

  elle<-function(param,ordinal,Y,U1,m){
    p<-NCOL(Y); v<-NCOL(U1); 
    betas<-param[1:(p+1)]
    omegas1<-param[(p+2):(p+v+2)]
    theta2<-param[length(param)]
    return(-loglikmihgcov110(ordinal,Y,m,betas,omegas1,U1,theta2)  )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,Y=Y,U1=U1,m=m,hessian=TRUE)
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}









mihgestcov101<-function(ordinal,Y,U2,m,maxiter=500,toler=1e-6){
  
 
  n<-length(ordinal)
  
  theta1<-max(0.01,1/m - 0.05)
  theta2ini<-min(1/m + 0.05,0.99)
  
  betas<-runif(NCOL(Y)+1,-3,3)
  
  omegas2<-c(log(theta2ini/(1-theta2ini)),rep(0,NCOL(U2)))
  
  loglik<-loglikmihgcov101(ordinal,Y,m,betas,theta1,omegas2,U2)  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    
    tau1<-ttau1cov101(ordinal,Y,betas,theta1,omegas2,U2,m)   
    
    
    updatebeta<-optim(par=betas,fn=effepai,tau1=tau1,Y=Y,method="L-BFGS-B")
    betas<-updatebeta$par  

    update1<-optim(par=theta1,fn=Qihg100,ordinal=ordinal,tau1=tau1,m=m,method = "Brent",hessian=TRUE,lower=0.01, upper=1/m-0.01)
    theta1<-update1$par
    
    tau2<-1-tau1
    
    update2<-optim(par=omegas2,fn=Qihgcov2,ordinal=ordinal,Y=U2,tau1=tau2,hessian=TRUE)
    omegas2<-update2$par

    
    

    
    logliknew<-loglikmihgcov101(ordinal,Y,m,betas,theta1,omegas2,U2)  
    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(betas,theta1,omegas2)
  
  
  #############################################

  elle<-function(param,ordinal,Y,U2,m){
    p<-NCOL(Y); v<-NCOL(U2); 
    betas<-param[1:(p+1)]
    
    omegas2<-param[(p+3):(p+v+3)]
    theta1<-param[(p+2)]
    return(-loglikmihgcov101(ordinal,Y,m,betas,theta1,omegas2,U2)  )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,Y=Y,U2=U2,m=m,hessian=TRUE)
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  loglikfin<-loglik
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}



effepai<-function(betk,tau1,Y){
  
  
  pais<-logis(Y,betk)
  tau2<-1-tau1
  
  val<-sum(tau1*log(pais))  + sum(tau2*log(1-pais))
  
  return(-val)
  
}



Qihg<-function(theta1,ordinal,tau1){
  
  freq<-tabulate(ordinal,nbins=m)
  
  s1<-sum(freq*tau1)
  
  vett1<-(1:m)-1
  aa<- vett1*freq
  s2<-sum(aa*tau1)
  
  
  vett2<-cc<-rep(0,m); vett2[1]<-m-1
  for (j in 2:m){ vett2[j]<-vett2[j-1] + theta1 -1}
  
  for (r in 1:m){
    cc[r]<-sum(log(vett2[1:r]))
    
  }
  
  bb<-cc*freq
  s3<-sum(bb*tau1)
  
  out<- (log(theta1))*s1 + (log(1-theta1))*s2 - s3
  
  return(-out)
  
}



Qihg100<-function(theta1,ordinal,tau1,m){
  

  probi<-probihg(m,theta1)[ordinal]
  
  out<-sum(tau1*log(probi))
  
  return(-out)
  
}



ttau1cov2<-function(ordinal,Y,bet,theta1,theta2,m){
  
  pais<-logis(Y,bet)
  taui<-c()
  for (i in 1:length(ordinal)){
    
    num<-pais[i]*probihg(m,theta1)[ordinal[i]]
    den<-probmihg(m,pais[i],theta1,theta2)[ordinal[i]]
    taui[i]<-num/den
    
  }
  return(taui)
  
}



loglikmihgcov2<-function(ordinal,Y,m,bet,theta1,theta2){
  
  pais<-logis(Y,bet)
  probi<-c()
  for (i in 1:length(ordinal)){
    
    prob<-probmihg(m,pais[i],theta1,theta2)
    probi[i]<-prob[ordinal[i]]
    
  }
  
  return(sum(log(probi)))
  
}


mihgestcov100<-function(ordinal,Y,m,maxiter=500,toler=1e-6){
  

  n<-length(ordinal)
  
  theta1<-runif(1,0,1/m)
  theta2<-runif(1,1/m,1)
  
  betas<-runif(NCOL(Y)+1,-3,3)
  
  
  loglik<-loglikmihgcov2(ordinal,Y,m,betas,theta1,theta2)  
  loglikini<-loglik
  
  nniter<-1
  flag<-0
  
  while(nniter<=maxiter){
    likold<-loglik
    
    tau1<-ttau1cov2(ordinal,Y,betas,theta1,theta2,m)   
    
    
    updatebeta<-optim(par=betas,fn=effepai,tau1=tau1,Y=Y,method="L-BFGS-B")
    betas<-updatebeta$par  

    
    update1<-optim(par=theta1,fn=Qihg100,ordinal=ordinal,tau1=tau1,m=m,method = "Brent",hessian=TRUE,lower=0.01, upper=1/m-0.01)
    theta1<-update1$par

    tau2<-1-tau1
    
    
    update2<-optim(par=theta2,fn=Qihg100,ordinal=ordinal,tau1=tau2,m=m,method = "Brent",hessian=TRUE,lower=1/m+0.01, upper=0.99)
    theta2<-update2$par

    
    logliknew<-loglikmihgcov2(ordinal,Y,m,betas,theta1,theta2)  
    
    loglik<-logliknew
    testll<-abs(logliknew-likold) 
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      
    }
  }
  
  
  
  finalest<-c(betas,theta1,theta2)
  
  loglikfin<-loglik
  
  #############################################

  elle<-function(param,ordinal,Y,m){
    p<-NCOL(Y)
    betas<-param[1:(NCOL(Y)+1)]
    theta1<-param[p+2]
    theta2<-param[p+3]
    return(-loglikmihgcov2(ordinal,Y,m,betas,theta1,theta2)  )
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,Y=Y,m=m,method="L-BFGS-B",hessian=TRUE,lower=c(rep(-3,NCOL(Y)+1),0.01,1/m),upper=c(rep(3,NCOL(Y)+1),1/m,0.99))
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  ##################################################
  
  
  return(list("finalest"=finalest,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin))
}








#########################################
############## main call


mihgfit<-function(ordinal,m,Y=NULL,U1=NULL,U2=NULL,maxiter=500,toler=1e-4){
  
  
  
  if (is.null(Y)){
    
    if (!is.null(U1) & is.null(U2)){
      
      fit<-mihgestcov010(ordinal,U1,m,maxiter=maxiter,toler=toler)
    } 
    if (!is.null(U2) & is.null(U1)){
      
      fit<-mihgestcov001(ordinal,U2,m,maxiter=maxiter,toler=toler)
    } 
    if (!is.null(U2) & !is.null(U1)){
      
      fit<-mihgestcov011(ordinal,U1,U2,m,maxiter=maxiter,toler=toler)
    } 
    
  }
  
  if (is.null(Y) & is.null(U1) & is.null(U2)){
    
    fit<-mihgest(ordinal,m,maxiter,toler)
    
  } else {
    
    if (!is.null(Y)){
      
      if (!is.null(U1)){
        
        
        if (!is.null(U2)){
          fit<- mihgestcov(ordinal,Y=Y,U1=U1,U2=U2,m,maxiter,toler)
        } else {
          fit<- mihgestcov110(ordinal,Y=Y,U1=U1,m,maxiter,toler)
          
        }
        
      } else {
        if (!is.null(U2)){
          fit<- mihgestcov101(ordinal,Y=Y,U2=U2,m,maxiter,toler)
        } else {
          fit<- mihgestcov100(ordinal,Y=Y,m,maxiter,toler)
          
        }
      }
      
    }
    
    
  }
  return(fit)
  
}





############### for delta method



der1beta0<-function(beta0,beta1,x){
  
  exp(-beta0-beta1*x)/(1+ exp(-beta0-beta1*x))^2
  
}

der1beta1<-function(beta0,beta1,x){
  
  x*exp(-beta0-beta1*x)/(1+ exp(-beta0-beta1*x))^2
  
}



sepai<-function(beta0,beta1,varmat){
  
  grad0<-c(der1beta0(beta0,beta1,0),der1beta1(beta0,beta1,0))
  varpai0<-t(grad0)%*%varmat%*%grad0
  stdpai0<-sqrt(varpai0) 
  
  grad1<-c(der1beta0(beta0,beta1,1),der1beta1(beta0,beta1,1))
  
  varpai1<-t(grad1)%*%varmat%*%grad1
  stdpai1<-sqrt(varpai1) # 
  
  
  return(list('stdpai0'=stdpai0,'stdpai1'=stdpai1))
  
}


setheta1<-function(beta0,beta1,varmat,m){
  
  grad0<-c(der1beta0(beta0,beta1,0)/m,der1beta1(beta0,beta1,0)/m)
  varpai0<-t(grad0)%*%varmat%*%grad0
  stdpai0<-sqrt(varpai0) 
  
  grad1<-c(der1beta0(beta0,beta1,1)/m,der1beta1(beta0,beta1,1)/m)
  
  varpai1<-t(grad1)%*%varmat%*%grad1
  stdpai1<-sqrt(varpai1) # 
  
  
  return(list('stdpai0'=stdpai0,'stdpai1'=stdpai1))
  
}


setheta2<-function(beta0,beta1,varmat,m){
  
  
  const<- -(m-1)/m
  grad0<-const*c(der1beta0(beta0,beta1,0),der1beta1(beta0,beta1,0))
  varpai0<-t(grad0)%*%varmat%*%grad0
  stdpai0<-sqrt(varpai0) 
  
  grad1<-const*c(der1beta0(beta0,beta1,1),der1beta1(beta0,beta1,1))
  
  varpai1<-t(grad1)%*%varmat%*%grad1
  stdpai1<-sqrt(varpai1) # 
  
  
  return(list('stdpai0'=stdpai0,'stdpai1'=stdpai1))
  
}








