

dati<-read.table('data_IllustrativeExample',header=TRUE)

ordinal<-dati$As
names(dati)


m<-5

plot(table(ordinal))


source('script_mihg_all.R')



fit00<-mihgfit(ordinal,m)

# $finalest
# [1] 0.8460660 0.1197123 0.8093204
# 
# $varmat
# [,1]         [,2]         [,3]
# [1,] 0.0007314405 1.229238e-04 0.0016817595
# [2,] 0.0001229238 4.302037e-05 0.0003041853
# [3,] 0.0016817595 3.041853e-04 0.0069690764
# 
# $niter
# [1] 40
# 
# $loglikfin
# [1] -2203.617





eta<-2017-dati$Anno
dichoeta<-ifelse(eta<=23,0,1)


Y<-cbind(dichoeta)
fit<-mihgfit(ordinal,Y=Y,m=m,maxiter=10000)
fit$finalest/sqrt(diag(fit$varmat))

fit
# $finalest
# [1] 1.4457717 0.8268891 0.1187038 0.7900167
# 
# $varmat
# [,1]          [,2]         [,3]         [,4]
# [1,]  0.0409483381 -0.0111050641 0.0008328451 0.0114923832
# [2,] -0.0111050641  0.1136939071 0.0003381817 0.0011789730
# [3,]  0.0008328451  0.0003381817 0.0000420571 0.0002758915
# [4,]  0.0114923832  0.0011789730 0.0002758915 0.0063308286
# 
# $niter
# [1] 77
# 
# $loglikfin
# [1] -2199.397


param<-fit$finalest
betas<-param[1:2]; theta1<-param[3]; theta2<-param[4]
pai0<-logis(0,betas)
pai1<-logis(1,betas)


###################
############### delta method


# Copyright  Rosaria Simone

der1beta0<-function(beta0,beta1,x){
  
  exp(-beta0-beta1*x)/(1+ exp(-beta0-beta1*x))^2
  
}

der1beta1<-function(beta0,beta1,x){
  
  x*exp(-beta0-beta1*x)/(1+ exp(-beta0-beta1*x))^2
  
}


# Copyright  Rosaria Simone


secomp<-function(beta0,beta1,varmat){
  
  grad0<-c(der1beta0(beta0,beta1,0),der1beta1(beta0,beta1,0))
  
  varpai0<-t(grad0)%*%varmat%*%grad0
  stdpai0<-sqrt(varpai0) 
  
  grad1<-c(der1beta0(beta0,beta1,1),der1beta1(beta0,beta1,1))
  
  varpai1<-t(grad1)%*%varmat%*%grad1
  stdpai1<-sqrt(varpai1) # 
  
  
  return(list('stdpai0'=stdpai0,'stdpai1'=stdpai1))
  
}


varmatbeta<-fit$varmat[1:2,1:2]

beta0<-fit$finalest[1]; beta1<-fit$finalest[2]

secomp(beta0,beta1,varmatbeta)





