# Copyright 2018  Rosaria Simone

disbetaprob<-function(m,alfa,bet){
  
  disbeta<-c()
  for (j in 1:m){
    
    disbeta[j]<- pbeta(j/m,alfa,bet) - pbeta((j-1)/m,alfa,bet)
    
  }
  return(disbeta)
}


#######################  discretized Beta

disbeta2<-function(m,alfa){
  
  return(disbetaprob(m,alfa,alfa))
  
}


loglikdisbeta<-function(freq,m,alfa,bet){
  
  prob<-disbetaprob(m,alfa,bet)
  
  return(sum(freq*log(prob)))
  
}


loglikdisbeta2<-function(freq,m,alfa){
  
  prob<-disbeta2(m,alfa)
  
  return(sum(freq*log(prob)))
  
}



# to be optmimized
lldbeta<-function(param,freq){
  
  ll<-loglikdisbeta(freq,m,param[1],param[2])
  return(-ll)
}


lldbeta2<-function(alfa,freq){
  
  ll<-loglikdisbeta2(freq,m,alfa)
  return(-ll)
}



## with covariate

############ CON COVARIATE

###########################################################
lldbcov<-function(nuk,ordinal,Z){
  
  ZZ<-cbind(1,Z)
  
  aa<-exp(ZZ%*%nuk)
  
  vett<-c()
  for (j in 1:length(ordinal)){
    a<-aa[j]
    pri<-disbetaprob(m,a,a)
    vett[j]<-pri[ordinal[j]]
  }
  
  
  return(-sum(log(vett)))
  
}



lldbcov2<-function(param,ordinal,Z1,Z2){
  
  nuk<-param[1:(NCOL(Z1)+1)]
  muk<-param[(NCOL(Z1)+2): length(param)]
  
  ZZ1<-cbind(1,Z1)
  ZZ2<-cbind(1,Z2)
  
  aa<-exp(ZZ1%*%nuk)
  bb<-exp(ZZ2%*%muk)
  
  
  vett<-c()
  for (j in 1:length(ordinal)){
    a<-aa[j]; b<-bb[j]
    pri<-disbetaprob(m,a,b)
    vett[j]<-pri[ordinal[j]]
  }
  
  
  return(-sum(log(vett)))
  
}


############################


#######################  


