

source('script_mihg_all.R')
dati<-read.table("data_CaseStudy2.txt",header=TRUE)

ordinal<-dati$sport_practice
m<-7



fit000<-mihgfit(ordinal,m)
fit000
# $finalest
# [1] 0.30938884 0.04367903 0.28902762
# 
# $varmat
# [,1]         [,2]         [,3]
# [1,] 0.010924421 0.0020367502 0.0038103388
# [2,] 0.002036750 0.0004277817 0.0007077207
# [3,] 0.003810339 0.0007077207 0.0016760752
# 
# $niter
# [1] 132
# 
# $loglikfin
# [1] -1048.892


se<-sqrt(diag(fit000$varmat))
round(se,3)


### figure oresport
paimihg<-fit000$finalest[1]; theta1<-fit000$finalest[2]; theta2<-fit000$finalest[3]

pr<-probmihg(m,paimihg,theta1,theta2)

ds<-dissim(pr,table(ordinal)/554)
#[1] 0.06487733
plot(table(ordinal)/554,main=paste("Sport practice (diss = ",round(ds,3),")"),cex.main=1.3,ylab="",xlab="")
lines(1:m,pr,lty=2,col="blue",lwd=2)



##########################################



### mihg with covariates



fumo<-ifelse(dati$Sigarette==0,0,1)
dichoalcool<-ifelse(alcool>=4,0,1)

gender<-ifelse(dati$Genere=="Maschio",0,1)

eta<-ifelse(2017-dati$Anno_di_nascita <=25,0,1)


stress<-ifelse(dati$Stress<=50,0,1)






Y<-eta
eta<-ifelse(2017-dati$Anno_di_nascita <=25,0,1)
fit101<-mihgfit(ordinal,m,Y=Y,U1=gender,U2=stress)
# $finalest
# [1] -0.5348085 -1.6974777 -2.1759057  2.1127298  2.3697218 -0.9321549
# 
# $varmat
# [,1]          [,2]        [,3]        [,4]        [,5]          [,6]
# [1,]  0.13342154 -0.0158009118  0.32911854 -0.18692712 -0.08467302  0.0332605724
# [2,] -0.01580091  0.1707749480  0.03002776 -0.03469738 -0.01576960 -0.0007255818
# [3,]  0.32911854  0.0300277648  1.16381296 -0.81026918 -0.22109089  0.0745390129
# [4,] -0.18692712 -0.0346973842 -0.81026918  0.75290921  0.15345570 -0.0583523099
# [5,] -0.08467302 -0.0157696019 -0.22109089  0.15345570  0.17361309 -0.1366479798
# [6,]  0.03326057 -0.0007255818  0.07453901 -0.05835231 -0.13664798  0.1500206046
# 
# $niter
# [1] 134
# 
# $loglikfin
# [1] -1025.927

sqrt(diag(fit101$varmat))



fit101$finalest/sqrt(diag(fit101$varmat))
#[1] -1.464149 -4.107636 -2.016966  2.434852  5.687300 -2.406648

param<-fit101$finalest
betas<-param[1:2]; omegas1<-param[3:4]; omegas2<-param[5:6]
pai0<-logis(0,betas)
pai1<-logis(1,betas)


theta10<-logis(0,omegas1)/m
theta11<-logis(1,omegas1)/m


theta20<-1- (m-1)*logis(0,omegas2)/m
theta21<-1-(m-1)*logis(1,omegas2)/m


## BIC
2*1025.927 + 6*log(length(ordinal))
#[1] 2089.757


################### ################### ################### ###################
############### per metodo delta


fit<-fit101

varmatbeta<-fit$varmat[1:2,1:2]

beta0<-fit$finalest[1]; beta1<-fit$finalest[2]


## standard errors for pai0 and pai1
sepai(beta0,beta1,varmatbeta)




varmatheta1<-fit$varmat[3:4,3:4]

omega0<-fit$finalest[3]; omega1<-fit$finalest[4]

## standard errors for theta1_0 and theta1_1

setheta1(omega0,omega1,varmatheta1,m)

#####################################################




varmatheta2<-fit$varmat[5:6,5:6]

omega0<-fit$finalest[5]; omega1<-fit$finalest[6]

## standard errors for theta2_0 and theta2_1

setheta2(omega0,omega1,varmatheta2,m)




##############################################################
################################################################

#### Gecub
age<-2017-as.numeric(dati$Anno)

gender<-ifelse(dati$Genere=="Maschio",0,1)
gecub_1<-GEM(Formula(ordinal~ age|stress|gender+stress),family="cub",shelter=7)
summary(gecub_1)
# 
# ======================================================================= 
#   =====>>> CUB  model    <<<=====   ML-estimates via E-M algorithm   
# ======================================================================= 
#   m= 7  Sample size: n= 554  Iterations= 23  Maxiter= 500 
# ======================================================================= 
#   Uncertainty                                            
# Estimates     StdErr      Wald
# constant -2.74878933 0.65865750 -4.173321
# age       0.07189377 0.02215626  3.244851
# ======================================================================= 
#   Feeling                                            
# Estimates    StdErr     Wald
# constant 1.3374987 0.1841201 7.264275
# stress   0.6502827 0.2737844 2.375163
# ======================================================================= 
#   Shelter effect                                 
# Estimates    StdErr      Wald
# constant -0.5758368 0.3580223 -1.608382
# gender   -1.3996715 0.6097513 -2.295479
# stress   -2.3847676 0.7822891 -3.048448
# ======================================================================= 
#   Log-lik            = -1032.667 
# Mean Log-likelihood= -1.86402 
# ----------------------------------------------------------------------- 
#   AIC       = 2079.334 
# BIC       = 2109.555                 <================================
# ICOMP     = 2078.008 
# ======================================================================= 
#   Elapsed time= 3.36 seconds =====>>> Sun Jan 21 16:45:02 2018 
# ======================================================================= 




##### IHG with Gender, Age, Stress
stress<-dati$Stress/100

ihg_sfa<-GEM(Formula(ordinal~ stress + age  +gender),family="ihg")
summary(ihg_sfa)

# ======================================================================= 
#   =====>>> IHG  model    <<<=====   ML-estimates via E-M algorithm   
# ======================================================================= 
#   m= 7  Sample size: n= 554  Iterations= 1  Maxiter= 1 
# ======================================================================= 
#   Estimates     StdErr       Wald
# constant -3.53021559 0.22748231 -15.518638
# stress    0.93867448 0.19907963   4.715070
# age       0.04343566 0.00678233   6.404238
# gender    0.32698072 0.11328592   2.886331
# ======================================================================= 
#   Log-lik            = -1038.087 
# Mean Log-likelihood= -1.873803 
# ----------------------------------------------------------------------- 
#   AIC       = 2084.174 
# BIC       = 2101.442 
# ICOMP     = 2084.94 
# ======================================================================= 
#   Elapsed time= 0.68 seconds =====>>> Thu Jul 05 16:38:35 2018 
# ======================================================================= 



####################### IHG M1:

mod1<-GEM(Formula(ordinal~age+ gender+fumo+age*gender),family="ihg")
summary(mod1)


# 
# ======================================================================= 
#   =====>>> IHG  model    <<<=====   ML-estimates via E-M algorithm   
# ======================================================================= 
#   m= 7  Sample size: n= 554  Iterations= 1  Maxiter= 1 
# ======================================================================= 
#   Estimates     StdErr       Wald
# constant   -3.67541337 0.29138480 -12.613607
# age         0.06571983 0.01054040   6.235042
# gender      1.39908869 0.37932862   3.688329
# fumo        0.31076861 0.12324123   2.521629
# age:gender -0.03871090 0.01384558  -2.795904
# ======================================================================= 
#   Log-lik            = -1042.005 
# Mean Log-likelihood= -1.880875 
# ----------------------------------------------------------------------- 
#   AIC       = 2094.009 
# BIC       = 2115.595 
# ICOMP     = 2101.773 
# ======================================================================= 
#   Elapsed time= 0.93 seconds =====>>> Thu Jul 05 16:59:00 2018 
# ======================================================================= 



### figure agefumogenere
thetas1<-function(eta,genere,fumo){
  
  val<-sum(coef(modello1)*c(1,eta,genere,fumo,eta*genere))
  return(1/(1+exp(-val)))
  
}
agevett<-15:40


y00<-sapply(agevett,thetas1,genere=0,fumo=0)
y01<-sapply(agevett,thetas1,genere=0,fumo=1)
y10<-sapply(agevett,thetas1,genere=1,fumo=0)
y11<-sapply(agevett,thetas1,genere=1,fumo=1)


plot(agevett,y00,col="blue",ylim=c(0,0.35),type="l",lwd=2,cex.lab=1.4,cex.axis=1.3,ylab=expression(theta),xlab="Age")
points(agevett,y01,col="blue",pch=19)
points(agevett,y11,col="magenta",pch=19)
lines(agevett,y10,col="magenta",lwd=2)
abline(h=1/m )
legend("topleft",legend=c("Smoker","Non-Smoker"),lty=c(3,1),lwd=2,bty="n",cex=1.3)
legend("bottomright",legend=c("Man","Woman"),text.col=c("blue","magenta"),bty="n",cex=1.3)


length(which((eta>=29 & gender==0 & fumo==0)|(eta>=23& gender==0 & fumo==1)| (eta>=19 & gender==1 & fumo==0)|( gender==1 & fumo==1)))/554
#[1][1] [1][1] 0.6877256




############### IHG M2:

######## consumo bevande alcoliche

uno<-which(dati[,40]=="Mai")
due<-which(dati[,40]=="Una_volta_al_mese")
tre<-which(dati[,40]=="2-3_volte_al_mese")
quattro<-which(dati[,40]=="Una_volta_al_settimana")
cinque<-which(dati[,40]=="2-3_volte_alla_settimana")
sei<-which(dati[,40]=="4-5_volte_a_settimana")
sette<-which(dati[,40]=="Tutti_i_giorni")
variab<-rep(NA,length(dati[,40]))
variab[uno]<-1
variab[due]<-2
variab[tre]<-3
variab[quattro]<-4
variab[cinque]<-5
variab[sei]<-6
variab[sette]<-7

alcool<-variab-1

dichoalcool<-ifelse(alcool>=4,1,0)
gender<-ifelse(dati$Genere=="Maschio",0,1)

############################
modello2<-GEM(Formula(ordinal~stress+ dichoalcool + gender + dichoalcool*gender),family="ihg")
summary(modello2)
# ======================================================================= 
#   =====>>> IHG  model    <<<=====   ML-estimates via E-M algorithm   
# ======================================================================= 
#   m= 7  Sample size: n= 554  Iterations= 1  Maxiter= 1 
# ======================================================================= 
#   Estimates    StdErr       Wald
# constant           -2.5423372 0.1466816 -17.332349
# stress              0.9270323 0.2005101   4.623370
# dichoalcool         0.6368067 0.1989791   3.200369
# gender              0.4572086 0.1251271   3.653953
# dichoalcool:gender -0.6530541 0.2997124  -2.178936
# ======================================================================= 
#   Log-lik            = -1052.881 
# Mean Log-likelihood= -1.900506 
# ----------------------------------------------------------------------- 
#   AIC       = 2115.761 
# BIC       = 2137.347 
# ICOMP     = 2109.426 
# ======================================================================= 
#   Elapsed time= 0.6 seconds =====>>> Tue Jan 23 12:00:00 2018 
# ======================================================================= 




### figure stressalcoolgenere

thetas2<-function(stress,genere,alcool){
  
  val<-sum(coef(modello2)*c(1,stress,alcool,genere,alcool*genere))
  return(1/(1+exp(-val)))
  
}
stressvett<-seq(0,1,by=0.05)


y00<-sapply(stressvett,thetas2,genere=0,alcool=0)
y01<-sapply(stressvett,thetas2,genere=0,alcool=1)
y10<-sapply(stressvett,thetas2,genere=1,alcool=0)
y11<-sapply(stressvett,thetas2,genere=1,alcool=1)


plot(stressvett,y00,col="blue",ylim=c(0,0.35),type="l",lwd=2,cex.lab=1.4,cex.axis=1.3,ylab=expression(theta),xlab="Stress")
points(stressvett,y01,col="blue",pch=19)
points(stressvett,y11,col="magenta",pch=19)
lines(stressvett,y10,col="magenta",lwd=2)
abline(h=1/m )
legend("topleft",legend=c("Alcohol Cons.","No Alcohol Cons."),lty=c(3,1),lwd=2,bty="n",cex=1.3)
legend("bottomright",legend=c("Man","Woman"),text.col=c("blue","magenta"),bty="n",cex=1.3)

length(which((stress>=0.8 & gender==0 & dichoalcool==0)|(stress>=0.10 & gender==0 & dichoalcool==1)| (stress>=0.3& gender==1 )))/554
#[1] [1][1] 0.6895307