# Copyright 2018  Rosaria Simone


library(CUB)



disbetaprob<-function(m,alfa,bet){
  
  disbeta<-c()
  for (j in 1:m){
    
    disbeta[j]<- pbeta(j/m,alfa,bet) - pbeta((j-1)/m,alfa,bet)
    
  }
  return(disbeta)
}

#c=0 o c=1/m
probclub2c<-function(m,pai,csi,alfa,bet,cc=1/m){
  
  sb<-probbit(m,csi)
  discrbeta<-disbetaprob(m,alfa,bet)
  
  unccomp<-   (cc+ discrbeta)/(1+cc*m) #   (1/m + discrbeta)/2
  
  return( pai*probbit(m,csi) + (1-pai)*unccomp)
  
}



probunc2<-function(m,alfa,bet,cc=1/m){
  
  discrbeta<-disbetaprob(m,alfa,bet)
  unccomp<-   (cc+ discrbeta)/(1+cc*m) # (1/m + discrbeta)/2
  
  return(unccomp)
}


simclub2<-function(n,m,pai,csi,alfabet,cc=1/m){
  
  dico<-runif(n)<pai;
  
  pr<-probunc2(m,alfabet,alfabet,cc)
  
  vett<-dico*(1+rbinom(n,m-1,1-csi))+(1-dico)*sample(m,n,prob=pr,replace=TRUE)
  return(vett)
  
}




simclubcov<-function(n,m,pai,csi,nu,Z,cc=1/m){
  
  
  ZZ<-cbind(1,Z)
  alfavett<-exp(ZZ%*%nu)
  
  vett<-c()
  for (i in 1:n){
    
    #dico<- runif(1)< pai
    #pri<-probunc(m,alfavett[i],alfavett[i])
    vett[i]<-simclub2(1,m,pai,csi,alfavett[i],cc)
    
    #dico*(1+rbinom(1,m-1,1-csi))+(1-dico)*sample(m,1,prob=pri,replace=TRUE)
  }
  
  return(vett)
  
}




simclubcov2<-function(n,m,pai,gama,nu,W,Z,cc=1/m){
  
  ZZ<-cbind(1,Z)
  alfavett<-exp(ZZ%*%nu)
  
  csivett<-logis(W,gama)
  
  vett<-c()
  for (i in 1:n){
    
    #dico<- runif(1)< pai
    #pri<-probunc(m,alfavett[i],alfavett[i])
    vett[i]<-simclub2(1,m,pai,csivett[i],alfavett[i],cc)
    
    #dico*(1+rbinom(1,m-1,1-csi))+(1-dico)*sample(m,1,prob=pri,replace=TRUE)
  }
  
  return(vett)
  
}


#####################################################################


##########################################################################
#### algoritimo EM per stima club senza covariate



ttau1_2c<-function(pai,csi,delta,m,cc=1/m){
  alfa<-exp(delta)
  
  num<-pai*probbit(m,csi)
  den<-probclub2c(m,pai,csi,alfa,alfa,cc)
  return(num/den)
}


ttau2_2c<-function(pai,csi,delta,m,cc=1/m){   
  
  alfa<-exp(delta)  
  num<-(1-pai)*probunc2(m,alfa,alfa,cc)
  den<-probclub2c(m,pai,csi,alfa,alfa,cc)
  return(num/den)
}


Q1c<-function(pai,ordinal,tau1,tau2){
  
  freq<-tabulate(ordinal,nbins=m)
  
  return(-log(pai)*sum(freq*tau1) - log(1-pai)*sum(freq*tau2))
  
}

Q2_2c<-function(param,ordinal,tau1,tau2,cc=1/m){
  
  csi<-param[1]; delta<-param[2]
  
  freq<-tabulate(ordinal,nbins=m)
  
  alfa<-exp(delta)
  tau1bis<-tau1*log(probbit(m,csi))
  tau2bis<-tau2*log(probunc2(m,alfa,alfa,cc))
  return(-sum(freq*tau1bis) - sum(freq*tau2bis))
  
}

Q2csi<-function(csik,ordinal,tau1){
  
  tau1bis<-tau1*log(probbit(m,csik))
  freq<-tabulate(ordinal,nbins=m)
  return(-sum(freq*tau1bis))
}

Q2eta_2c<-function(deltak,ordinal,tau2,cc=1/m){
  
  alfak<-exp(deltak)  
  tau2bis<-tau2*log(probunc2(m,alfak,alfak,cc))
  freq<-tabulate(ordinal,nbins=m)
  return(-sum(freq*tau2bis))
}



loglikclub2c<-function(freq,m,pai,csi,delta,cc=1/m){
  
  alfabet<-exp(delta)
  
  prob<-probclub2c(m,pai,csi,alfabet,alfabet,cc)
  return(sum(freq*log(prob)))
  
}



inigridclubc <-
  function(m,freq,x,y,z,cc=1/m){
    listap<-expand.grid(x,y,z)
    quanti<-NROW(listap)
    loglik<-rep(NA,quanti)
    for(j in 1:quanti){
      pai<-listap[j,1]; csi<-listap[j,2]; delta<-listap[j,3]
      loglik[j]<-loglikclub2c(freq,m,pai,csi,delta,cc)
    }
    indice<-which.max(loglik)
    return(as.numeric(listap[indice,]))
  }



x<-c(0.3,0.5,0.7)
y<-c(0.2,0.5,0.8)
z<-c(-2,-1,0,1,2)


clubest2c<-function(ordinal,m,cc=1/m,maxiter=500,toler=1e-6,lb=-3,ub=4){
  
  freq<-tabulate(ordinal,nbins=m)
  # loglikini<-loglikfin<-niter<-loglikcub1<-loglikcub2<-alfaest<-alfaest2<-rep(0,nsimul)
  finalest<-rep(0,3)
  cubest<-rep(0,2)
  
  ord<-factor(ordinal,ordered=TRUE)
  fitcub<-GEM(Formula(ord~0|0|0),family="cub")
  loglikcub00<-as.numeric(logLik(fitcub))
  
  
  ini<-inigridclubc(m,freq,x,y,z,cc)
  pai<-ini[1]
  csi<-ini[2]
  delta<-ini[3]
  
  
  loglik<-loglikclub2c(freq,m,pai,csi,delta,cc)
  
  loglikini<-loglik
  
  n<-length(ordinal)
  
  
  nniter<-1
  while(nniter<=maxiter){
    likold<-loglik
    tau1<-ttau1_2c(pai,csi,delta,m,cc)
    tau2<-1-tau1
    
    aa<-sum(freq*tau1)
    pai<-aa/n
    
    #  tau2<-1-tau1 #ttau2(pai,csi,alfa,m)
    #update pai estimates
    # updatepai<-optim(par=pai,fn=Q1,ordinal=ordinal,tau1=tau1,tau2=tau2,hessian=TRUE,method="Brent",lower=0.01, upper=0.99)
    #  pai<-updatepai$par
    
    csik<-csi
    updatecsi<-optim(par=csik,fn=Q2csi,ordinal=ordinal,tau1=tau1,method = "Brent",hessian=TRUE,lower=0.01, upper=0.99)
    csi<-updatecsi$par
    
    deltak<-delta
    updateeta<-optim(par=deltak,fn=Q2eta_2c,ordinal=ordinal,tau2=tau2,cc=cc,method = "Brent",lower=lb, upper=ub)
    delta<-updateeta$par
    
    
    
    logliknew<-loglikclub2c(freq,m,pai,csi,delta,cc)
    # print(logliknew)
    testll<-abs(logliknew-likold) ###### print(testll); 
    # OPTIONAL printing: print(cbind(nniter,testll,pai,csi));
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      #print(c(pai,csi,alfa))
    }
    # OPTIONAL printing: print(loglik);
  }
  finalest<-c(pai,csi,delta)
  
  #############################################
  ### per trovare un numeric hessian di tutte le stime
  
  elle<-function(param,freq){
    m<-length(freq)
    pai<-param[1]
    csi<-param[2]
    delta<-param[3]
    return(-loglikclub2c(freq,m,pai,csi,delta,cc))
  }
  param<-finalest
  stimahess<-optim(par=param,fn=elle,freq=freq,method="L-BFGS-B",hessian=TRUE,lower=c(rep(0.01,2),lb),upper=c(rep(0.99,2),ub))
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-try(solve(neginformat),silent=TRUE)
  if (class(varmat) == "try-error"){
    varmat<-matrix(0,3,3)
    cat("Covariance Matrix not-positive definite","\n")
  }
  ##################################################
  
  loglikfin<-loglik
  loglikcub2<-loglikCUB(ord,m=m,param=c(pai,csi))
  
  return(list("finalest"=finalest,"loglikfin2"=loglikfin2,"varmat"=varmat,
              "niter"=nniter,"loglikfin"=loglikfin,"loglikcub2"=loglikcub2,"loglikcub"=loglikcub00))
}

###

kullleib<-function(prob1,prob2){
  0.5*(sum(log(prob1/prob2)*prob1) + sum(log(prob2/prob1)*prob2))
  
}




##########################################################################
#### algoritimo EM per stima club con covariate su response styles


ttau1cov<-function(ordinal,Z,pai,csi,nuk,cc=1/m){
  
  ZZ<-cbind(1,Z)
  alfavett<-exp(ZZ%*%nuk)
  
  pri<-c()
  tauvett<-c()
  for (i in 1:length(ordinal)){
    pri1<-probbit(m,csi)[ordinal[i]]
    pri2<-probunc2(m,alfavett[i],alfavett[i],cc)[ordinal[i]]
    pri[i]<-pai*pri1 + (1-pai)*pri2
    tauvett[i] <- (pai*pri1)/pri[i]
  }
  
  return(tauvett)
}



loglikclubcov<-function(ordinal,Z,pai,csi,nuk,cc=1/m){
  
  ZZ<-cbind(1,Z)
  alfavett<-exp(ZZ%*%nuk)
  
  pri<-c()
  
  for (i in 1:length(ordinal)){
    
    pri1<-probbit(m,csi)[ordinal[i]]
    pri2<-probunc2(m,alfavett[i],alfavett[i],cc)[ordinal[i]]
    
    pri[i]<-pai*pri1 + (1-pai)*pri2
    
    
  }
  
  return(sum(log(pri)))
  
}


Q2csicov<-function(csik,ordinal,tau1){
  
  tau1bis<-tau1*log(probbit(m,csik)[ordinal])
  freq<-tabulate(ordinal,nbins=m)
  return(-sum(tau1bis))
}


E4<-function(nuk,tau1,ordinal,Z,cc=1/m){
  
  ZZ<-cbind(1,Z)
  
  aa<-exp(ZZ%*%nuk)
  
  vett<-c()
  for (j in 1:length(ordinal)){
    a<-aa[j]
    pri<-probunc2(m,a,a,cc)
    vett[j]<-pri[ordinal[j]]
  }
  
  
  return(-sum((1-tau1)*log(vett+0.001)))
  
}



clubcov<-function(ordinal,m,Z,cc=1/m,maxiter=500,toler=1e-6){
  
  
  t<-NCOL(Z)
  # loglikini<-loglikfin<-niter<-loglikcub1<-loglikcub2<-alfaest<-alfaest2<-rep(0,nsimul)
  finalest<-rep(0,3+t)
  clubest<-rep(0,3)
  
  
  clubfit<-clubest2c(ordinal,m,cc)
  clubest<-clubfit$finalest
  
  pai<-clubest[1]; csi<-clubest[2]
  
  nuest<-clubest[3]
  
  nu<-c(nuest,rep(0,t))
  
  
  loglik<-loglikclubcov(ordinal,Z,pai,csi,nu,cc)
  loglikini<-loglik
  
  nniter<-1
  while(nniter<=maxiter){
    likold<-loglik
    
    tau1<-ttau1cov(ordinal,Z,pai,csi,nu,cc)
    
    
    aa<-sum(tau1)
    pai<-aa/length(ordinal)
    print(pai)
    
    
    #     vett<-m-ordinal
    #     num<-sum(tau1*vett)
    #     den<-(m-1)*aa
    #     csi<-num/den
    #     print(csi)
    csik<-csi
    updatecsi<-optim(par=csik,fn=Q2csicov,ordinal=ordinal,tau1=tau1,method = "Brent",hessian=TRUE,lower=0.01, upper=0.99)
    csi<-updatecsi$par
    #     #print(csi)
    
    nuk<-nu
    updatealfa<-optim(par=nuk,fn=E4,ordinal=ordinal,tau1=tau1,Z=Z,cc=cc,method="L-BFGS-B",hessian=TRUE)  #,lower=rep(-3,t+1),upper=rep(3,t+1)
    nu<-updatealfa$par
    print(nu)
    # cat("###","\n")
    
    
    logliknew<-loglikclubcov(ordinal,Z,pai,csi,nu,cc)
    # cat("update loglik","\n")
    print(logliknew)
    testll<-abs(logliknew-likold) ###### print(testll);
    # OPTIONAL printing: print(cbind(nniter,testll,pai,csi));
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      # cat("update estimate","\n")
      # print(c(pai,csi,alfa,delta))
    }
    # OPTIONAL printing: print(loglik);
  }
  finalest<-c(pai,csi,nu)
  loglikfin<-loglik
  
  
  elle<-function(param,ordinal){
    pai<-param[1]
    csi<-param[2]
    nu<-param[3:length(param)]
    return(-loglikclubcov(ordinal,Z,pai,csi,nu,cc))
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,method="L-BFGS-B",hessian=TRUE,lower=c(rep(0.01,2),rep(-3,NCOL(Z)+1)),upper=c(rep(0.99,2),rep(3,NCOL(Z)+1)))
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  wald<-finalest/sqrt(diag(varmat))
  
  
  return(list("finalest"=finalest,"clubest"=clubest,"varmat"=varmat,"niter"=nniter,"loglikfin"=loglikfin,"wald"=wald))
}










##########################################################################
#### algoritimo EM per stima club con covariate su feeling e response styles



ttau1cov2<-function(ordinal,W,Z,pai,gamak,nuk,cc=1/m){
  
  ZZ<-cbind(1,Z)
  alfavett<-exp(ZZ%*%nuk)
  
  csivett<-logis(W,gamak)
  
  pri<-c()
  tauvett<-c()
  for (i in 1:length(ordinal)){
    pri1<-probbit(m,csivett[i])[ordinal[i]]
    pri2<-probunc2(m,alfavett[i],alfavett[i],cc)[ordinal[i]]
    pri[i]<-pai*pri1 + (1-pai)*pri2
    tauvett[i] <- (pai*pri1)/pri[i]
  }
  
  return(tauvett)
}



loglikclubcov2<-function(ordinal,W,Z,pai,gamak,nuk,cc=1/m){
  
  ZZ<-cbind(1,Z)
  alfavett<-exp(ZZ%*%nuk)
  csivett<-logis(W,gamak)
  
  pri<-c()
  
  for (i in 1:length(ordinal)){
    
    pri1<-probbit(m,csivett[i])[ordinal[i]]
    pri2<-probunc2(m,alfavett[i],alfavett[i],cc)[ordinal[i]]
    
    pri[i]<-pai*pri1 + (1-pai)*pri2
    
    
  }
  
  return(sum(log(pri)))
  
}


Q2csicov2<-function(gamak,W,ordinal,tau1){
  
  covar<-cbind(1,W)
  ss<-sum(tau1*((ordinal-1)*(covar%*%gamak)+(m-1)*log(1+exp(-covar%*%gamak))))
  
  return(ss)
}


E42<-function(nuk,tau1,ordinal,Z,cc=1/m){
  
  ZZ<-cbind(1,Z)
  
  aa<-exp(ZZ%*%nuk)
  
  vett<-c()
  for (j in 1:length(ordinal)){
    a<-aa[j]
    pri<-probunc2(m,a,a,cc)
    vett[j]<-pri[ordinal[j]]
  }
  
  
  return(-sum((1-tau1)*log(vett+0.01)))
  
}





clubcov2<-function(ordinal,m,W,Z,cc=1/m,maxiter=500,toler=1e-6){
  
  
  q<-NCOL(W)
  t<-NCOL(Z)
  # loglikini<-loglikfin<-niter<-loglikcub1<-loglikcub2<-alfaest<-alfaest2<-rep(0,nsimul)
  finalest<-rep(0,3+q+t)
  
  
  clubcov1<-clubcov(ordinal,m,Z,cc,maxiter=20,toler=1e-3)
  pai<-clubcov1$finalest[1]
  nu<-clubcov1$finalest[-c(1,2)]
  
  
  ord<-factor(ordinal,ordered=TRUE)
  fitcub<-GEM(Formula(ord~0|W|0),family="cub",maxiter=100,toler=1e-3)
  gama<-fitcub$estimates[-1]
  
  loglik<-loglikclubcov2(ordinal,W,Z,pai,gama,nu,cc)
  loglikini<-loglik
  
  nniter<-1
  while(nniter<=maxiter){
    print(nniter)
    
    likold<-loglik
    
    tau1<-ttau1cov2(ordinal,W,Z,pai,gama,nu,cc)
    
    
    aa<-sum(tau1)
    pai<-aa/length(ordinal)
    
    
    gamak<-gama
    updatecsi<-optim(par=gamak,fn=Q2csicov2,W=W,ordinal=ordinal,tau1=tau1,method="L-BFGS-B",hessian=TRUE)
    gama<-updatecsi$par
    
    nuk<-nu
    updatealfa<-optim(par=nuk,fn=E42,ordinal=ordinal,tau1=tau1,Z=Z,cc=cc,method="L-BFGS-B",hessian=TRUE) #lower=rep(-3,t+1),upper=rep(3,t+1)
    nu<-updatealfa$par
    print(nu)
    # cat("###","\n")
    
    
    logliknew<-loglikclubcov2(ordinal,W,Z,pai,gama,nu,cc)
    print(logliknew)
    
    testll<-abs(logliknew-likold) ###### print(testll);
    # OPTIONAL printing: print(cbind(nniter,testll,pai,csi));
    if(testll<=toler) break else {
      loglik<-logliknew
      nniter<-nniter+1
      # cat("update estimate","\n")
      # print(c(pai,csi,alfa,delta))
    }
    # OPTIONAL printing: print(loglik);
  }
  
  finalest<-c(pai,gama,nu)
  loglikfin<-loglik
  
  
  elle<-function(param,ordinal){
    pai<-param[1]
    gama<-param[2:(q+2)]
    nu<-param[(q+3):length(param)]
    
    return(-loglikclubcov2(ordinal,W,Z,pai,gama,nu,cc))
  }
  
  stimahess<-optim(par=finalest,fn=elle,ordinal=ordinal,method="L-BFGS-B",hessian=TRUE,lower=c(0.01,rep(-Inf,q+1),rep(-Inf,NCOL(Z)+1)),upper=c(0.99,rep(Inf,q+1),rep(Inf,NCOL(Z)+1)))
  
  est2<-stimahess$par
  loglikfin2<--stimahess$value
  neginformat<-stimahess$hessian
  varmat<-solve(neginformat)
  
  wald<-finalest/sqrt(diag(varmat))
  
  return(list("finalest"=finalest,"clubest"=clubcov1$finalest,"varmat"=varmat,"niter"=nniter,"loglikfin"=loglikfin,"wald"=wald))
}

################################################################################################
################################################################################################


