
source("script_DisBeta.R")

### figure alfabet

m<-8
alfa<-0.6; bet<-0.9
par(mfrow=c(1,2))
plot(1:m,disbetaprob(m,alfa,bet),type="h",lwd=2,ylab="",xlab="",ylim=c(0,0.3))
legend("top",horiz=TRUE,legend=c(as.expression(bquote(alpha==.(alfa))),bquote(beta==.(bet))),bty="n",cex=1.5)

alfa<-5; bet<-3

plot(1:m,disbetaprob(m,alfa,bet),type="h",lwd=2,ylab="",xlab="",ylim=c(0,0.3))
legend("topleft",horiz=TRUE,legend=c(as.expression(bquote(alpha==.(alfa))),bquote(beta==.(bet))),bty="n",cex=1.5)

par(mfrow=c(1,1))


####

library(CUB)

m<-8

theta1<-0.4; theta2<-0.2; theta3<-0.10; theta4<-0.05; theta5<-1/m

pr1<-probihg(m,theta1)
pr2<-probihg(m,theta2)
pr5<-probihg(m,theta5)
pr3<-probihg(m,theta3)
pr4<-probihg(m,theta4)
########### figure ihg1, ihg2,ihg3,ihg4

plot(1:m,pr1,xlab="",ylab="",ylim=c(0,0.43),type="h",lwd=2,main=bquote(theta==.(theta1)),cex.main=2.5,cex.axis=1.5)
plot(1:m,pr2,xlab="",ylab="",ylim=c(0,0.43),type="h",lwd=2,main=bquote(theta==.(theta2)),cex.main=2.5,cex.axis=1.5)
plot(1:m,pr3,xlab="",ylab="",ylim=c(0,0.43),type="h",lwd=2,main=bquote(theta==.(theta3)),cex.main=2.5,cex.axis=1.5)
plot(1:m,pr4,xlab="",ylab="",ylim=c(0,0.43),type="h",lwd=2,main=bquote(theta==.(theta4)),cex.main=2.5,cex.axis=1.5)
plot(1:m,pr5,xlab="",ylab="",ylim=c(0,0.43),type="h",lwd=2,main=bquote(theta==.(theta5)),cex.main=2.5,cex.axis=1.5)


#########################
### figura cub_cubshe
m<-7
pai<-0.4
csi<-0.8
shelter<-2
delta<-0.1

ordinal<-simcubshe(500,m,pai,csi,delta,shelter)
freq<-tabulate(ordinal,nbins=m)/500

prcub<-probcub00(m,pai,csi)
prcubshe<-probcubshe2(m,pai,csi,delta,shelter)

plot(1:m,freq,type="h",xlab="",ylab="",cex.axis=1.5,lwd=2,ylim=c(0,0.35))
lines(1:m,prcubshe,lwd=2,col="blue",lty=2)
lines(1:m,prcub,lwd=2,lty=2,col="red")
legend("topright",legend=c("CUB", "CUB + she(2)"),bty="n",text.col=c("red","blue"),cex=2)
